/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.commands.ErstelleRnnCommand;
import ch.elexis.core.ui.views.rechnung.KonsZumVerrechnenView;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rechnungslauf
implements IRunnableWithProgress {
    private static Logger log = LoggerFactory.getLogger(Rechnungslauf.class);
    private KonsZumVerrechnenView kzv;
    private Mandant mandant;
    private List<Konsultation> kons;
    private List<Konsultation> subResults;
    private List<Fall> skipCase;
    private TimeTool tmpTime;
    private TimeTool now;
    private TimeTool ttFirstBefore;
    private TimeTool ttLastBefore;
    private TimeTool quarterLimit;
    private TimeTool ttFrom;
    private TimeTool ttTo;
    private boolean quarterFilter;
    private boolean billFlagged;
    private boolean skip;
    private Money lowerLimit;
    private String accountSys;

    public Rechnungslauf(KonsZumVerrechnenView kzv, boolean billFlagged, TimeTool ttFirstBefore, TimeTool ttLastBefore, Money lowerLimit, boolean quarterFilter, boolean skip, TimeTool ttFrom, TimeTool ttTo, String accountSys) {
        this.ttFirstBefore = ttFirstBefore;
        this.ttLastBefore = ttLastBefore;
        this.ttFrom = ttFrom;
        this.ttTo = ttTo;
        this.lowerLimit = lowerLimit;
        this.quarterFilter = quarterFilter;
        this.skip = skip;
        this.accountSys = accountSys;
        this.billFlagged = billFlagged;
        this.kzv = kzv;
        this.now = new TimeTool();
        this.calcQuarterLimit();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.mandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        List<Konsultation> dbList = this.getAllKonsultationen(monitor);
        this.kons = this.skipInvalidConsultations(dbList);
        this.subResults = new ArrayList<Konsultation>();
        this.skipCase = new ArrayList<Fall>();
        this.tmpTime = new TimeTool();
        this.applyBillingFlagFilter(monitor);
        this.applyAccountSystemFilter(monitor);
        this.applyStartedFilter(monitor);
        this.applyFinishedFilter(monitor);
        this.applyMinPaymentLimit(monitor);
        this.applyQuarterFilter(monitor);
        this.applyTimespanFilter(monitor);
        for (Fall f : this.skipCase) {
            Konsultation[] konsultationArray = f.getBehandlungen(false);
            int n = konsultationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Konsultation k = konsultationArray[n2];
                this.kons.remove(k);
                ++n2;
            }
        }
        monitor.subTask(Messages.Rechnungslauf_creatingLists);
        for (Konsultation k : this.kons) {
            this.kzv.selectKonsultation(k);
            monitor.worked(1);
        }
        if (this.skip) {
            monitor.subTask(Messages.Rechnungslauf_creatingBills);
            ErstelleRnnCommand.ExecuteWithParams(this.kzv.getViewSite(), this.kzv.tSelection);
        }
        monitor.done();
    }

    private List<Konsultation> skipInvalidConsultations(List<Konsultation> dbList) {
        String rsId = this.mandant.getRechnungssteller().getId();
        ArrayList<Konsultation> list = new ArrayList<Konsultation>();
        for (Konsultation k : dbList) {
            if (k.getMandant() == null) {
                ElexisStatus status = new ElexisStatus(2, "ch.elexis", 1, Messages.Rechnungslauf_warnInvalidMandant, 2);
                StatusManager.getManager().handle((IStatus)status);
                log.warn("...skip Kons [" + k.getId() + "] with invalid mandant");
                continue;
            }
            Fall fall = k.getFall();
            if (fall == null || !fall.exists()) {
                log.warn("...skip Kons [" + k.getId() + "] fall is null/inexisting");
                continue;
            }
            Patient pat = fall.getPatient();
            if (pat == null || !pat.exists()) {
                log.warn("...skip Kons [" + k.getId() + "] patient is null/inexisting");
                continue;
            }
            if (rsId.equals(k.getMandant().getRechnungssteller().getId())) {
                list.add(k);
                continue;
            }
            log.debug("... skip Kons [" + k.getId() + "] as rechnungssteller is divergent");
        }
        return list;
    }

    private List<Konsultation> getAllKonsultationen(IProgressMonitor monitor) {
        Query qbe = new Query(Konsultation.class);
        qbe.add("RechnungsID", "", null);
        qbe.add("billable", "=", "1");
        monitor.beginTask(Messages.Rechnungslauf_analyzingConsultations, -1);
        monitor.subTask(Messages.Rechnungslauf_readingConsultations);
        return qbe.execute();
    }

    private void calcQuarterLimit() {
        String today = this.now.toString(9).substring(4);
        this.quarterLimit = new TimeTool();
        if (today.compareTo("0930") > 0) {
            this.quarterLimit.set(2, 9);
        } else if (today.compareTo("0630") > 0) {
            this.quarterLimit.set(2, 6);
        } else if (today.compareTo("0331") > 0) {
            this.quarterLimit.set(2, 3);
        } else {
            this.quarterLimit.set(2, 1);
        }
    }

    private void applyBillingFlagFilter(IProgressMonitor monitor) {
        if (this.billFlagged) {
            log.debug("filter all that are flagged for billing");
            monitor.subTask("Filtern zum Abrechnen vorgemerkter F\u00e4lle ...");
            for (Konsultation k : this.kons) {
                if (!this.accepted(k)) continue;
                Fall fall = k.getFall();
                this.tmpTime = fall.getBillingDate();
                if (this.tmpTime == null || !this.tmpTime.isBeforeOrEqual(this.now)) continue;
                for (Konsultation k2 : this.kons) {
                    String fid = k2.get("FallID");
                    if (fid == null || !fid.equals(fall.getId()) || this.subResults.contains(k2)) continue;
                    this.subResults.add(k2);
                }
            }
            this.updateKonsList();
            if (this.tmpTime == null) {
                this.tmpTime = new TimeTool();
            }
        }
    }

    private void applyAccountSystemFilter(IProgressMonitor monitor) {
        if (this.accountSys != null) {
            log.debug("apply filter for accounting system: " + this.accountSys);
            monitor.subTask("Filtern nach Abrechnungssystem ...");
            for (Konsultation k : this.kons) {
                Fall fall;
                if (!this.accepted(k) || (fall = k.getFall()) == null || !fall.getAbrechnungsSystem().equals(this.accountSys)) continue;
                this.subResults.add(k);
            }
            this.updateKonsList();
        }
    }

    private void applyStartedFilter(IProgressMonitor monitor) {
        if (this.ttFirstBefore != null) {
            log.debug("apply start time [" + this.ttFirstBefore.toString(9) + "] filter");
            monitor.subTask("Filtern nach Anfangsdatum ...");
            ArrayList<Fall> treated = new ArrayList<Fall>();
            for (Konsultation k : this.kons) {
                if (!this.accepted(k)) continue;
                this.tmpTime.set(k.getDatum());
                Fall kCase = k.getFall();
                if (this.tmpTime.isBefore(this.ttFirstBefore)) {
                    Konsultation[] caseKons;
                    if (kCase == null || treated.contains(kCase) || this.skipCase.contains(kCase)) continue;
                    treated.add(kCase);
                    Konsultation[] konsultationArray = caseKons = kCase.getBehandlungen(false);
                    int n = caseKons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Konsultation cK = konsultationArray[n2];
                        if (this.kons.contains(cK) && !this.subResults.contains(cK)) {
                            this.subResults.add(cK);
                        }
                        ++n2;
                    }
                    continue;
                }
                this.skipCase.add(kCase);
            }
            this.updateKonsList();
        }
    }

    private void applyFinishedFilter(IProgressMonitor monitor) {
        if (this.ttLastBefore != null) {
            log.debug("apply finish time [" + this.ttLastBefore.toString(9) + "] filter");
            monitor.subTask("Filtern Enddatum ...");
            block0: for (Konsultation k : this.kons) {
                if (!this.accepted(k)) continue;
                this.tmpTime.set(k.getDatum());
                if (!this.tmpTime.isBefore(this.ttLastBefore)) continue;
                for (Konsultation k2 : this.kons) {
                    String fId = k.get("FallID");
                    if (fId == null || !fId.equals(k2.getFall().getId())) continue;
                    this.tmpTime.set(k2.getDatum());
                    if (this.tmpTime.isAfter(this.ttLastBefore)) {
                        this.skipCase.add(k.getFall());
                        continue block0;
                    }
                    if (this.subResults.contains(k2)) continue;
                    this.subResults.add(k2);
                }
            }
            this.updateKonsList();
        }
    }

    private void applyTimespanFilter(IProgressMonitor monitor) {
        if (this.ttFrom != null && this.ttTo != null) {
            log.debug("apply filter for timestpan [" + this.ttFrom.toString(9) + " - " + this.ttTo.toString(9));
            monitor.subTask("Filtern nach Zeitspanne ...");
            this.tmpTime.setResolution(1L);
            for (Konsultation k : this.kons) {
                if (!this.accepted(k)) continue;
                this.tmpTime.set(k.getDatum());
                if (!this.tmpTime.isAfterOrEqual(this.ttFrom) || !this.tmpTime.isBeforeOrEqual(this.ttTo)) continue;
                this.subResults.add(k);
            }
            this.updateKonsList();
        }
    }

    private void applyMinPaymentLimit(IProgressMonitor monitor) {
        if (this.lowerLimit != null) {
            log.debug("apply filter for minimal payment amount");
            monitor.subTask("Filtern nach Betragsh\u00f6he ...");
            for (Konsultation k : this.kons) {
                if (!this.accepted(k)) continue;
                Money sum = new Money();
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
                ICoverage encounterCoverage = encounter.getCoverage();
                ArrayList<Konsultation> matchingKons = new ArrayList<Konsultation>();
                List encounters = encounterCoverage.getEncounters();
                for (IEncounter sameCoverageEncounter : encounters) {
                    Konsultation sameCoverageKonsultation = Konsultation.load((String)sameCoverageEncounter.getId());
                    int index = this.kons.indexOf(sameCoverageKonsultation);
                    if (index <= -1) continue;
                    matchingKons.add(this.kons.get(index));
                    for (IBilled vr : sameCoverageEncounter.getBilled()) {
                        sum.addMoney(vr.getTotal());
                    }
                }
                if (sum.isMoreThan(this.lowerLimit)) {
                    for (Konsultation match : matchingKons) {
                        if (this.subResults.contains(match)) continue;
                        this.subResults.add(match);
                    }
                    continue;
                }
                if (this.skipCase.contains(k.getFall())) continue;
                this.skipCase.add(k.getFall());
            }
            this.updateKonsList();
        }
    }

    private void applyQuarterFilter(IProgressMonitor monitor) {
        if (this.quarterFilter) {
            log.debug("applying quarter filter");
            monitor.subTask("Filtern nach Quartal ...");
            for (Konsultation k : this.kons) {
                if (!this.accepted(k)) continue;
                this.tmpTime.set(k.getDatum());
                if (!this.tmpTime.isBefore(this.quarterLimit)) continue;
                this.subResults.add(k);
            }
            this.updateKonsList();
        }
    }

    private boolean accepted(Konsultation k) {
        return !this.subResults.contains(k) && !this.skipCase.contains(k.getFall());
    }

    private void updateKonsList() {
        this.kons.clear();
        this.kons.addAll(this.subResults);
        this.subResults.clear();
    }
}

