/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IReminderResponsibleLink;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.ReminderDetailDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingAction;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.ReminderFilter;
import ch.elexis.data.Reminder;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.LoggerFactory;

public class ReminderListsView
extends ViewPart
implements Heartbeat.HeartListener,
IRefreshable,
ISelectionProvider {
    public static final String ID = "ch.elexis.core.ui.views.reminderlistsview";
    private static final String CURRENTPATIENT = "currentpatient";
    private static final String ALLPATIENTS = "allpatients";
    private static final String GENERALREMINDERS = "generalreminders";
    private static final String MYREMINDERS = "myreminders";
    private static final String GLOBALFILTERS = "global";
    private boolean useGlobalFilters = ConfigServiceHolder.getUser((String)"reminder/useGlobalFilters", (boolean)false);
    private int filterDueDateDays = ConfigServiceHolder.getUser((String)"reminder/filterDueDays/global", (int)-1);
    private boolean autoSelectPatient = ConfigServiceHolder.getUser((String)"reminder/autoSelectPatient/global", (boolean)false);
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private Composite viewParent;
    private Text txtSearch;
    private ReminderFilter filter = new ReminderFilter();
    private ViewerSelectionComposite viewerSelectionComposite;
    private Composite viewersParent;
    private ScrolledComposite viewersScrolledComposite;
    private HeaderComposite currentPatientHeader;
    private TableViewer currentPatientViewer;
    private HeaderComposite generalPatientHeader;
    private TableViewer generalPatientViewer;
    private HeaderComposite generalRemindersHeader;
    private TableViewer generalRemindersViewer;
    private HeaderComposite myHeader;
    private TableViewer myViewer;
    HashMap<TableViewer, String> allViewers = new HashMap();
    private List<GroupComponent> usergroupComponents = new ArrayList<GroupComponent>();
    private List<IUserGroup> userGroups = this.getUserGroups();
    private Font boldFont;
    private Color colorInProgress;
    private Color colorDue;
    private Color colorOverdue;
    private Color colorOpen;
    private List<IReminder> currentSelection = new ArrayList<IReminder>();
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private IPatient actPatient;
    private long cvHighestLastUpdate;
    HashMap<String, FilterActions> filtersMap = new HashMap();
    private Action reloadAction = new Action(Messages.Core_Reload){
        {
            this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            this.setToolTipText(Messages.Core_Reread_List);
        }

        public void run() {
            ReminderListsView.this.refresh();
        }
    };
    private Action toggleGlobalFiltersAction = new Action(Messages.ReminderView_useGlobalFiltersAction, 2){
        {
            this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_useGlobalFiltersToolTip);
            this.setChecked(ReminderListsView.this.useGlobalFilters);
        }

        public void run() {
            ConfigServiceHolder.setUser((String)"reminder/useGlobalFilters", (boolean)this.isChecked());
            ReminderListsView.this.useGlobalFilters = ReminderListsView.this.toggleGlobalFiltersAction.isChecked();
            ReminderListsView.this.refreshUserConfiguration();
            ReminderListsView.this.refresh();
        }
    };
    private Action toggleAutoSelectPatientAction = new Action(Messages.ReminderView_activatePatientAction, 2){
        {
            this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_toggleSelectPatientActionTooltip);
            this.setChecked(ReminderListsView.this.autoSelectPatient);
        }

        public void run() {
            ConfigServiceHolder.setUser((String)"reminder/autoSelectPatient", (boolean)this.isChecked());
        }
    };
    private Action newReminderAction = new Action(Messages.Core_New_ellipsis){
        {
            this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_newReminderToolTip);
        }

        public void run() {
            ReminderDetailDialog erd = null;
            erd = new ReminderDetailDialog(ReminderListsView.this.getViewSite().getShell());
            int retVal = erd.open();
            if (retVal == 0) {
                IReminder reminder = (IReminder)CoreModelServiceHolder.get().load(erd.getReminder().getId(), IReminder.class).get();
                LocalLockServiceHolder.get().acquireLock((Object)reminder);
                LocalLockServiceHolder.get().releaseLock((Object)reminder);
            }
            ReminderListsView.this.refresh();
        }
    };
    private RestrictedAction selectPatientAction = new RestrictedAction((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.VIEW), Messages.ReminderView_activatePatientAction, 0){
        {
            this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
            this.setToolTipText(Messages.ReminderView_activatePatientTooltip);
        }

        @Override
        public void doRun() {
            StructuredSelection sel = (StructuredSelection)ReminderListsView.this.getSelection();
            if (sel != null && sel.size() != 1) {
                SWTHelper.showInfo(Messages.ReminderView_onePatOnly, Messages.ReminderView_onlyOnePatientForActivation);
            } else if (sel != null && sel.size() > 0) {
                IReminder reminder = (IReminder)sel.getFirstElement();
                IContact patient = reminder.getContact();
                IContact creator = reminder.getCreator();
                if (patient != null && patient.isPatient() && !patient.getId().equals(creator.getId())) {
                    ContextServiceHolder.get().setActivePatient(patient.asIPatient());
                }
            }
        }

        public boolean isEnabled() {
            StructuredSelection sel = (StructuredSelection)ReminderListsView.this.getSelection();
            if (sel != null && sel.size() == 1 && sel.getFirstElement() instanceof IReminder) {
                IReminder reminder = (IReminder)sel.getFirstElement();
                return reminder.getContact() != null && reminder.getCreator() != null ? !reminder.getContact().getId().equals(reminder.getCreator().getId()) : false;
            }
            return false;
        }
    };
    private static String SELECTIONCOMP_CURRENTPATIENT_ID = "reminderlistsview.selection.currentpatient";
    private static String SELECTIONCOMP_GENERALPATIENT_ID = "reminderlistsview.selection.generalpatient";
    private static String SELECTIONCOMP_GENERALREMINDERS_ID = "reminderlistsview.selection.generalreminders";
    private static String SELECTIONCOMP_MYREMINDERS_ID = "reminderlistsview.selection.myreminders";
    private static String SELECTIONCOMP_GROUPREMINDERS_PREFIX = "reminderlistsview.selection.groupreminders.";

    private FilterActions createFilterActions(final String config) {
        Action deleteReminderAction = new Action(Messages.Core_Delete, config){
            private TableViewer viewer;
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.ReminderView_deleteToolTip);
                this.viewer = ReminderListsView.this.getViewerForId(string);
            }

            public void run() {
                StructuredSelection sel = (StructuredSelection)this.viewer.getStructuredSelection();
                if (sel != null && sel.size() == 1 && sel.getFirstElement() instanceof IReminder) {
                    IReminder r = (IReminder)sel.getFirstElement();
                    LockResponse lockResponse = LocalLockServiceHolder.get().acquireLock((Object)r);
                    if (lockResponse.isOk()) {
                        CoreModelServiceHolder.get().delete((Deleteable)r);
                        LocalLockServiceHolder.get().releaseLock((Object)r);
                    } else {
                        LockResponseHelper.showInfo(lockResponse, r, null);
                    }
                    ReminderListsView.this.refreshKeepLabels();
                }
            }

            public boolean isEnabled() {
                StructuredSelection sel = (StructuredSelection)this.viewer.getStructuredSelection();
                return sel != null && sel.size() == 1 && sel.getFirstElement() instanceof IReminder;
            }
        };
        RestrictedAction showOthersRemindersAction = new RestrictedAction((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW), Messages.Core_All, 2){
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.setToolTipText(Messages.ReminderView_foreignTooltip);
            }

            public void reload() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(ConfigServiceHolder.getUser((String)"reminder/others/global", (boolean)false));
                } else {
                    this.setChecked(ConfigServiceHolder.getUser((String)("reminder/others/" + config), (boolean)false));
                }
            }

            @Override
            public void doRun() {
                boolean continueOperation;
                if (this.isChecked() && !(continueOperation = SWTHelper.askYesNo(Messages.Core_Warning, Messages.ReminderView_WarningAllFilter))) {
                    this.setChecked(false);
                    return;
                }
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/others/global", (boolean)this.isChecked());
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/others/" + config), (boolean)this.isChecked());
                }
                ReminderListsView.this.resetOtherFilters(config);
                ReminderListsView.this.refresh();
            }
        };
        Action showSelfCreatedReminderAction = new Action(Messages.ReminderView_myRemindersAction, 2){
            {
                super($anonymous0, $anonymous1);
                this.setToolTipText(Messages.ReminderView_myRemindersToolTip);
            }

            public void reload() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(ConfigServiceHolder.getUser((String)"reminder/originator/global", (boolean)false));
                } else {
                    this.setChecked(ConfigServiceHolder.getUser((String)("reminder/originator/" + config), (boolean)false));
                }
            }

            public void reset() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)"reminder/originator/global", (boolean)false);
                } else {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)("reminder/originator/" + config), (boolean)false);
                }
            }

            public void run() {
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/originator/global", (boolean)this.isChecked());
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/originator/" + config), (boolean)this.isChecked());
                }
                ReminderListsView.this.refresh();
            }
        };
        Action showOnlyOwnDueReminderToggleAction = new Action(Messages.ReminderView_onlyDueAction, 2){
            {
                super($anonymous0, $anonymous1);
                this.setToolTipText(Messages.ReminderView_onlyDueToolTip);
            }

            public void reload() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(ConfigServiceHolder.getUser((String)"reminder/onlyclosed/global", (boolean)false));
                } else {
                    this.setChecked(ConfigServiceHolder.getUser((String)("reminder/onlyclosed/" + config), (boolean)false));
                }
            }

            public void reset() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)"reminder/onlyclosed/global", (boolean)false);
                } else {
                    this.setChecked(ConfigServiceHolder.setUser((String)("reminder/onlyclosed/" + config), (boolean)false));
                }
            }

            public void run() {
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/onlyclosed/global", (boolean)this.isChecked());
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/onlyclosed/" + config), (boolean)this.isChecked());
                }
                ReminderListsView.this.refresh();
            }
        };
        Action showNotYetDueReminderToggleAction = new Action(Messages.ShowNotYetDueReminders, 2){
            {
                super($anonymous0, $anonymous1);
                this.setToolTipText(Messages.ShowNotYetDueReminders_Tooltip);
            }

            public void reload() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(ConfigServiceHolder.getUser((String)"reminder/onlyopen/global", (boolean)false));
                } else {
                    this.setChecked(ConfigServiceHolder.getUser((String)("reminder/onlyopen/" + config), (boolean)false));
                }
            }

            public void reset() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)"reminder/onlyopen/global", (boolean)false);
                } else {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)("reminder/onlyopen/" + config), (boolean)false);
                }
            }

            public void run() {
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/onlyopen/global", (boolean)this.isChecked());
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/onlyopen/" + config), (boolean)this.isChecked());
                }
                ReminderListsView.this.refresh();
            }
        };
        Action popupOnLoginReminderToggleAction = new Action(Messages.Reminders_PopupOnLogin, 2){
            {
                super($anonymous0, $anonymous1);
                this.setToolTipText(Messages.Reminders_PopupOnLogin_ToolTip);
            }

            public void reload() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(ConfigServiceHolder.getUser((String)"reminder/popupOnLogin/global", (boolean)false));
                } else {
                    this.setChecked(ConfigServiceHolder.getUser((String)("reminder/popupOnLogin/" + config), (boolean)false));
                }
            }

            public void reset() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)"reminder/popupOnLogin/global", (boolean)false);
                } else {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)("reminder/popupOnLogin/" + config), (boolean)false);
                }
            }

            public void run() {
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/popupOnLogin/global", (boolean)this.isChecked());
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/popupOnLogin/" + config), (boolean)this.isChecked());
                }
                ReminderListsView.this.refresh();
            }
        };
        Action popupOnPatientSelectionReminderToggleAction = new Action(Messages.Reminders_PopupOnPatientSelection, 2){
            {
                super($anonymous0, $anonymous1);
                this.setToolTipText(Messages.Reminders_PopupOnPatientSelection_ToolTip);
            }

            public void reload() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(ConfigServiceHolder.getUser((String)"reminder/popupOnPatientSelection/global", (boolean)false));
                } else {
                    this.setChecked(ConfigServiceHolder.getUser((String)("reminder/popupOnPatientSelection/" + config), (boolean)false));
                }
            }

            public void reset() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)"reminder/popupOnPatientSelection/global", (boolean)false);
                } else {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)("reminder/popupOnPatientSelection/" + config), (boolean)false);
                }
            }

            public void run() {
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/popupOnPatientSelection/global", (boolean)this.isChecked());
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/popupOnPatientSelection/" + config), (boolean)this.isChecked());
                }
                ReminderListsView.this.refresh();
            }
        };
        Action showAssignedToMeAction = new Action(Messages.Reminders_AssignedToMe, 2){
            {
                super($anonymous0, $anonymous1);
                this.setToolTipText(Messages.Reminders_AssignedToMe_ToolTip);
            }

            public void reload() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(ConfigServiceHolder.getUser((String)"reminder/assignedToMe/global", (boolean)false));
                } else {
                    this.setChecked(ConfigServiceHolder.getUser((String)("reminder/assignedToMe/" + config), (boolean)false));
                }
            }

            public void reset() {
                if (ReminderListsView.this.useGlobalFilters) {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)"reminder/assignedToMe/global", (boolean)false);
                } else {
                    this.setChecked(false);
                    ConfigServiceHolder.setUser((String)("reminder/assignedToMe/" + config), (boolean)false);
                }
            }

            public void run() {
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/assignedToMe/global", (boolean)this.isChecked());
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/assignedToMe/" + config), (boolean)this.isChecked());
                }
                ReminderListsView.this.refresh();
            }
        };
        return new FilterActions(deleteReminderAction, showAssignedToMeAction, popupOnPatientSelectionReminderToggleAction, popupOnLoginReminderToggleAction, showNotYetDueReminderToggleAction, showOnlyOwnDueReminderToggleAction, showSelfCreatedReminderAction, showOthersRemindersAction);
    }

    private void resetOtherFilters(String config) {
        if (this.useGlobalFilters) {
            for (Map.Entry<String, FilterActions> set : this.filtersMap.entrySet()) {
                set.getValue().reset();
            }
        } else {
            this.filtersMap.get(config).reset();
        }
        this.toggleAutoSelectPatientAction.setChecked(false);
    }

    @Optional
    @Inject
    void activePatient(final IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (patient.equals(this.actPatient)) {
                return;
            }
            this.actPatient = patient;
            this.clearSelection();
            this.patientRefresh();
            if (!ConfigServiceHolder.getUser((String)"reminder/showPatientChangeReminder", (boolean)true)) {
                UiDesk.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)patient);
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                        query.startGroup();
                        ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                            ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                            subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                            subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                            query.exists(subQuery);
                        });
                        query.or("responsibleValue", IQuery.COMPARATOR.EQUALS, (Object)"ALL");
                        query.andJoinGroups();
                        List list = query.execute();
                        if (!list.isEmpty()) {
                            StringBuilder sb = new StringBuilder();
                            for (IReminder r : list) {
                                sb.append(String.valueOf(r.getSubject()) + "\n");
                                sb.append(String.valueOf(r.getMessage()) + "\n\n");
                            }
                            SWTHelper.alert(Messages.ReminderView_importantRemindersCaption, sb.toString());
                        }
                    }
                });
            }
        }, (Object)this.viewersParent);
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (this.viewersScrolledComposite != null && !this.viewersScrolledComposite.isDisposed()) {
                this.adaptForUser(user);
            }
        });
    }

    private void adaptForUser(IUser user) {
        this.refreshUserConfiguration();
        this.refresh();
    }

    @Optional
    @Inject
    void crudFinding(@UIEventTopic(value="info/elexis/model/*") IReminder reminder) {
        CoreUiUtil.runAsyncIfActive(() -> this.refresh(), (Object)((Object)this.viewerSelectionComposite));
    }

    public void createPartControl(Composite parent) {
        this.viewParent = new Composite(parent, 0);
        this.viewParent.setLayout((Layout)new GridLayout());
        this.txtSearch = new Text(this.viewParent, 128);
        this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtSearch.setMessage(Messages.ReminderView_txtSearch_message);
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ReminderListsView.this.clearSelection();
                ReminderListsView.this.filter.setFilterText(ReminderListsView.this.txtSearch.getText());
                ReminderListsView.this.refreshKeepLabels();
            }
        });
        this.boldFont = SWTResourceManager.getBoldFont(this.txtSearch.getFont());
        this.viewerSelectionComposite = new ViewerSelectionComposite(this.viewParent, 0);
        this.viewerSelectionComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.viewersScrolledComposite = new ScrolledComposite(this.viewParent, 512);
        this.viewersScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewersScrolledComposite.setExpandVertical(true);
        this.viewersScrolledComposite.setExpandHorizontal(true);
        this.viewersScrolledComposite.addListener(11, event -> {
            int width = this.viewersScrolledComposite.getClientArea().width;
            this.viewersScrolledComposite.setMinSize(this.viewersParent.computeSize(width, -1));
        });
        this.viewersParent = new Composite((Composite)this.viewersScrolledComposite, 0);
        this.viewersParent.setBackground(UiDesk.getColor("weiss"));
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.viewersParent.setLayout((Layout)layout);
        this.viewersScrolledComposite.setContent((Control)this.viewersParent);
        this.currentPatientHeader = new HeaderComposite(this.viewersParent, 0);
        this.currentPatientHeader.setTextFont(this.boldFont);
        this.currentPatientHeader.setText("aktueller Patient");
        this.currentPatientViewer = new TableViewer(this.viewersParent, 0x10010800);
        this.setupViewer(this.currentPatientViewer, false);
        this.addDragSupport(this.currentPatientViewer);
        this.addDropSupport(this.currentPatientViewer, TableType.CURRENT_PATIENT);
        this.generalPatientHeader = new HeaderComposite(this.viewersParent, 0);
        this.generalPatientHeader.setTextFont(this.boldFont);
        this.generalPatientHeader.setText("alle Patienten");
        this.generalPatientViewer = new TableViewer(this.viewersParent, 0x10010800);
        this.setupViewer(this.generalPatientViewer, true);
        this.addDragSupport(this.generalPatientViewer);
        this.addDropSupport(this.generalPatientViewer, TableType.GENERAL_PATIENT);
        ((GridData)this.generalPatientViewer.getTable().getLayoutData()).heightHint = 300;
        this.generalRemindersHeader = new HeaderComposite(this.viewersParent, 0);
        this.generalRemindersHeader.setTextFont(this.boldFont);
        this.generalRemindersHeader.setText("Pendenzen ohne Patientenbezug");
        this.generalRemindersViewer = new TableViewer(this.viewersParent, 0x10010800);
        this.setupViewer(this.generalRemindersViewer, false);
        this.addDragSupport(this.generalRemindersViewer);
        this.addDropSupport(this.generalRemindersViewer, TableType.GENERALREMINDERS);
        ((GridData)this.generalPatientViewer.getTable().getLayoutData()).heightHint = 300;
        this.myHeader = new HeaderComposite(this.viewersParent, 0);
        this.myHeader.setTextFont(this.boldFont);
        this.myHeader.setText("meine Pendenzen");
        this.myViewer = new TableViewer(this.viewersParent, 0x10010800);
        this.setupViewer(this.myViewer, true);
        this.addDragSupport(this.myViewer);
        this.addDropSupport(this.myViewer, TableType.MYREMINDERS);
        for (IUserGroup group : this.userGroups) {
            HeaderComposite groupHeader = new HeaderComposite(this.viewersParent, 0);
            groupHeader.setTextFont(this.boldFont);
            groupHeader.setText(String.valueOf(group.getId()) + "-Pendenzen");
            TableViewer groupViewer = new TableViewer(this.viewersParent, 0x10010800);
            this.setupViewer(groupViewer, true);
            this.addDragSupport(groupViewer);
            this.addDropSupport(groupViewer, TableType.GROUP);
            this.usergroupComponents.add(new GroupComponent(group.getId(), groupHeader, groupViewer));
        }
        this.viewerSelectionComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ReminderListsView.this.updateViewerSelection(selection);
                ReminderListsView.this.refresh();
            }
        });
        this.actPatient = ContextServiceHolder.get().getActivePatient().orElse(null);
        this.viewerSelectionComposite.loadSelection();
        this.updateViewerSelection((StructuredSelection)this.viewerSelectionComposite.getSelection());
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.reloadAction, this.newReminderAction, this.toggleGlobalFiltersAction, this.toggleAutoSelectPatientAction});
        this.allViewers.put(this.currentPatientViewer, CURRENTPATIENT);
        this.allViewers.put(this.generalPatientViewer, ALLPATIENTS);
        this.allViewers.put(this.generalRemindersViewer, GENERALREMINDERS);
        this.allViewers.put(this.myViewer, MYREMINDERS);
        for (GroupComponent groupComponent : this.usergroupComponents) {
            this.allViewers.put(groupComponent.viewer(), groupComponent.id());
        }
        for (Map.Entry entry : this.allViewers.entrySet()) {
            String id = (String)entry.getValue();
            Table table = ((TableViewer)entry.getKey()).getTable();
            final FilterActions actions = this.createFilterActions(id);
            this.filtersMap.put(id, actions);
            MenuManager timeFilterSubMenu = new MenuManager("Zeitraum Anzeige (ab heute)");
            CustomTimeAction custom = new CustomTimeAction("Benutzerdefinierte Anzahl", id);
            FilterTimeAction action30 = new FilterTimeAction(30);
            FilterTimeAction action60 = new FilterTimeAction(60);
            FilterTimeAction action90 = new FilterTimeAction(90);
            action30.setOthers(Arrays.asList(new Action[]{action60, action90, custom}));
            action60.setOthers(Arrays.asList(new Action[]{action30, action90, custom}));
            action90.setOthers(Arrays.asList(new Action[]{action30, action60, custom}));
            custom.setOthers(Arrays.asList(new Action[]{action30, action60, action90}));
            timeFilterSubMenu.add((IAction)action30);
            timeFilterSubMenu.add((IAction)action60);
            timeFilterSubMenu.add((IAction)action90);
            timeFilterSubMenu.add((IAction)custom);
            MenuManager menuManager = new MenuManager();
            menuManager.add((IContributionItem)new ReminderStatusSubMenu(id));
            menuManager.add((IAction)actions.deleteReminderAction());
            menuManager.add((IContributionItem)timeFilterSubMenu);
            menuManager.add((IAction)actions.showOnlyOwnDueReminderToggleAction());
            menuManager.add((IAction)actions.showNotYetDueReminderToggleAction());
            menuManager.add((IAction)actions.showSelfCreatedReminderAction());
            menuManager.add((IAction)actions.showAssignedToMeAction());
            menuManager.add((IAction)actions.popupOnLoginReminderToggleAction());
            menuManager.add((IAction)actions.popupOnPatientSelectionReminderToggleAction());
            menuManager.add((IAction)actions.showOthersRemindersAction());
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    actions.deleteReminderAction().setEnabled(actions.deleteReminderAction().isEnabled());
                }
            });
            table.setMenu(menuManager.createContextMenu((Control)table));
        }
        this.refreshUserConfiguration();
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    private void addModifiedScrollListener(Table table) {
        table.addListener(37, e -> {
            Point mouseLocation = table.toControl(Display.getCurrent().getCursorLocation());
            if (table.getItem(mouseLocation) == null) {
                e.doit = false;
                ScrollBar verticalBar = this.viewersScrolledComposite.getVerticalBar();
                if (verticalBar != null && verticalBar.isEnabled()) {
                    int newSelection = verticalBar.getSelection() - e.count * verticalBar.getIncrement();
                    verticalBar.setSelection(newSelection);
                    this.viewersScrolledComposite.setOrigin(this.viewersScrolledComposite.getOrigin().x, newSelection);
                }
            }
        });
    }

    private void setupViewer(final TableViewer tableViewer, boolean patientColumn) {
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 100;
        tableViewer.getTable().setLayoutData((Object)gd);
        tableViewer.setComparator((ViewerComparator)new ReminderComparator());
        tableViewer.addFilter((ViewerFilter)this.filter);
        tableViewer.addSelectionChangedListener(this.getSelectionListener());
        tableViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.createTypeColumn(tableViewer, 20, 0);
        this.createDateColumn(tableViewer, 80, 1);
        this.createResponsibleColumn(tableViewer, 80, 2);
        if (patientColumn) {
            this.createPatientColumn(tableViewer, 150, 3);
        }
        this.createDescriptionColumn(tableViewer, 400, tableViewer.getTable().getColumnCount() + 1);
        TableViewerResizer.enableResizing(tableViewer, this.viewersScrolledComposite);
        this.addModifiedScrollListener(tableViewer.getTable());
        tableViewer.getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                tableViewer.getTable().deselectAll();
            }
        });
    }

    private void updateViewerSelection(StructuredSelection selection) {
        this.viewersParent.setRedraw(false);
        this.hideControl((Control)this.currentPatientHeader);
        this.hideControl((Control)this.currentPatientViewer.getTable());
        this.hideControl((Control)this.generalPatientHeader);
        this.hideControl((Control)this.generalPatientViewer.getTable());
        this.hideControl((Control)this.generalRemindersHeader);
        this.hideControl((Control)this.generalRemindersViewer.getTable());
        this.hideControl((Control)this.myHeader);
        this.hideControl((Control)this.myViewer.getTable());
        for (GroupComponent group : this.usergroupComponents) {
            this.hideControl((Control)group.header());
            this.hideControl((Control)group.viewer().getTable());
        }
        if (selection != null && !selection.isEmpty()) {
            for (GroupComponent selected : selection.toList()) {
                if (!(selected instanceof String)) continue;
                if (SELECTIONCOMP_CURRENTPATIENT_ID.equals(selected)) {
                    this.showControl((Control)this.currentPatientHeader);
                    this.showControl((Control)this.currentPatientViewer.getTable());
                    continue;
                }
                if (SELECTIONCOMP_GENERALPATIENT_ID.equals(selected)) {
                    this.showControl((Control)this.generalPatientHeader);
                    this.showControl((Control)this.generalPatientViewer.getTable());
                    continue;
                }
                if (SELECTIONCOMP_GENERALREMINDERS_ID.equals(selected)) {
                    this.showControl((Control)this.generalRemindersHeader);
                    this.showControl((Control)this.generalRemindersViewer.getTable());
                    continue;
                }
                if (SELECTIONCOMP_MYREMINDERS_ID.equals(selected)) {
                    this.showControl((Control)this.myHeader);
                    this.showControl((Control)this.myViewer.getTable());
                    continue;
                }
                if (this.userGroups.isEmpty()) continue;
                for (GroupComponent group : this.usergroupComponents) {
                    if (!(String.valueOf(SELECTIONCOMP_GROUPREMINDERS_PREFIX) + group.id()).equals(selected)) continue;
                    this.showControl((Control)group.header());
                    this.showControl((Control)group.viewer().getTable());
                }
            }
        }
        this.viewersParent.setRedraw(true);
        int width = this.viewersScrolledComposite.getClientArea().width;
        this.viewersScrolledComposite.setMinSize(this.viewersParent.computeSize(width, -1));
        this.viewParent.layout(true, true);
    }

    private void addDragSupport(final TableViewer viewer) {
        DragSource dragSource = new DragSource((Control)viewer.getTable(), 2);
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)viewer.getStructuredSelection());
            }
        });
    }

    private void addDropSupport(final TableViewer viewer, final TableType tableType) {
        DropTarget dropTarget = new DropTarget((Control)viewer.getTable(), 2);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object element : ((IStructuredSelection)selection).toList()) {
                        if (!(element instanceof IReminder)) continue;
                        IReminder reminder = (IReminder)element;
                        ReminderListsView.this.updateReminderForTarget(reminder, tableType, viewer, ReminderListsView.this.actPatient);
                        CoreModelServiceHolder.get().save((Identifiable)reminder);
                        ReminderListsView.this.refresh();
                    }
                }
            }
        });
    }

    private void updateReminderForTarget(IReminder reminder, TableType type, TableViewer viewer, IPatient patient) {
        switch (type) {
            case CURRENT_PATIENT: {
                break;
            }
            case GENERAL_PATIENT: {
                if (reminder.isResponsibleAll()) break;
                String responsibleText = reminder.getResponsible().stream().map(r -> String.valueOf(r.getDescription1()) + " " + r.getDescription2()).collect(Collectors.joining(", "));
                StringBuilder sb = new StringBuilder("Pendenz ");
                if (!responsibleText.isEmpty()) {
                    sb.append("von: ").append(responsibleText).append(" ");
                }
                sb.append("an Alle zuweisen?");
                if (!MessageDialog.openConfirm((Shell)this.viewParent.getShell(), (String)("Pendenz: " + reminder.getSubject()), (String)sb.toString())) break;
                if (!reminder.getResponsible().isEmpty()) {
                    for (IContact contact : reminder.getResponsible()) {
                        reminder.removeResponsible(contact);
                    }
                }
                reminder.setResponsibleAll(true);
                break;
            }
            case GENERALREMINDERS: {
                break;
            }
            case GROUP: {
                IUserGroup targetGroup = this.findGroupForViewer(viewer);
                if (targetGroup == null) break;
                List currentResponsibles = reminder.getResponsible();
                if (reminder.isResponsibleAll()) {
                    reminder.setResponsibleAll(false);
                }
                if (!currentResponsibles.isEmpty()) {
                    for (IContact contact : currentResponsibles) {
                        reminder.removeResponsible(contact);
                    }
                }
                for (IUser user : targetGroup.getUsers()) {
                    reminder.addResponsible(user.getAssignedContact());
                }
                break;
            }
            case MYREMINDERS: {
                if (reminder.isResponsibleAll()) {
                    reminder.setResponsibleAll(false);
                }
                if (!reminder.getResponsible().isEmpty()) {
                    for (IContact contact : reminder.getResponsible()) {
                        reminder.removeResponsible(contact);
                    }
                }
                reminder.addResponsible((IContact)ContextServiceHolder.getActiveMandatorOrNull());
                break;
            }
        }
    }

    private TableViewer getViewerForId(String id) {
        return (TableViewer)((Map.Entry)this.allViewers.entrySet().stream().filter(c -> ((String)c.getValue()).equalsIgnoreCase(id)).findFirst().orElse(null)).getKey();
    }

    private IUserGroup findGroupForViewer(TableViewer viewer) {
        return this.usergroupComponents.stream().filter(component -> component.viewer().equals(viewer)).map(component -> this.getUserGroupById(component.id())).findFirst().orElse(null);
    }

    private IUserGroup getUserGroupById(String id) {
        return this.userGroups.stream().filter(group -> group.getId().equals(id)).findFirst().orElse(null);
    }

    private void showControl(Control control) {
        if (control != null && control.getLayoutData() != null) {
            control.setVisible(true);
            ((GridData)control.getLayoutData()).exclude = false;
        }
    }

    private void hideControl(Control control) {
        if (control != null && control.getLayoutData() != null) {
            control.setVisible(false);
            ((GridData)control.getLayoutData()).exclude = true;
        }
    }

    public void setFocus() {
        this.viewersParent.setFocus();
    }

    private void refreshKeepLabels() {
        for (Map.Entry<TableViewer, String> set : this.allViewers.entrySet()) {
            TableViewer viewer = set.getKey();
            if (!viewer.getTable().isVisible()) continue;
            viewer.refresh(false);
        }
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(() -> {
            if (!this.filtersMap.isEmpty()) {
                this.filtersMap.values().forEach(fa -> fa.reload());
            }
            this.patientRefresh();
            this.generalRefresh();
            this.generalRemindersRefresh();
            this.myRemindersRefresh();
            this.groupRemindersRefresh();
            int width = this.viewersScrolledComposite.getClientArea().width;
            this.viewersScrolledComposite.setMinSize(this.viewersParent.computeSize(width, -1));
            this.viewParent.layout(true, true);
        });
    }

    private void patientRefresh() {
        if (this.actPatient != null) {
            if (this.currentPatientViewer.getTable().isVisible()) {
                this.refreshCurrentPatientInput(CURRENTPATIENT);
            }
        } else {
            this.currentPatientViewer.setInput(Collections.emptyList());
        }
    }

    private void generalRefresh() {
        if (this.generalPatientViewer.getTable().isVisible()) {
            this.refreshGeneralPatientInput(ALLPATIENTS);
        }
    }

    private void generalRemindersRefresh() {
        if (this.generalRemindersViewer.getTable().isVisible()) {
            this.refreshGeneralInput(GENERALREMINDERS);
        }
    }

    private void myRemindersRefresh() {
        if (this.myViewer.getTable().isVisible()) {
            this.refreshMyRemindersInput(MYREMINDERS);
        }
    }

    private void groupRemindersRefresh() {
        for (GroupComponent group : this.usergroupComponents) {
            if (!group.viewer().getTable().isVisible()) continue;
            this.refreshGroupRemindersInput(group);
        }
    }

    private void refreshCurrentPatientInput(String config) {
        if (this.filtersMap != null || this.filtersMap.isEmpty()) {
            CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new CurrentPatientSupplier(this.actPatient).showAll(ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false) && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.filtersMap.get((Object)config).showOnlyOwnDueReminderToggleAction.isChecked()).showNotYetDueReminders(this.filtersMap.get((Object)config).showNotYetDueReminderToggleAction.isChecked()).showSelfCreated(this.filtersMap.get((Object)config).showSelfCreatedReminderAction.isChecked()).popupOnLogin(this.filtersMap.get((Object)config).popupOnLoginReminderToggleAction.isChecked()).popupOnPatientSelectionToggleAction(this.filtersMap.get((Object)config).popupOnPatientSelectionReminderToggleAction.isChecked()).showAssignedToMeAction(this.filtersMap.get((Object)config).showAssignedToMeAction.isChecked()));
            currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
                if (this.currentPatientViewer != null && !this.currentPatientViewer.getTable().isDisposed()) {
                    try {
                        List input = (List)currentLoader.get();
                        this.currentPatientViewer.setInput((Object)input);
                        this.viewerSelectionComposite.setCount(SELECTIONCOMP_CURRENTPATIENT_ID, this.currentPatientViewer.getTable().getItemCount());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                    }
                }
            }));
        }
    }

    private void refreshGeneralPatientInput(String config) {
        if (this.filtersMap != null || this.filtersMap.isEmpty()) {
            CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new GeneralPatientSupplier(this.actPatient).showAll(ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false) && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.filtersMap.get((Object)config).showOnlyOwnDueReminderToggleAction.isChecked()).showNotYetDueReminders(this.filtersMap.get((Object)config).showNotYetDueReminderToggleAction.isChecked()).showSelfCreated(this.filtersMap.get((Object)config).showSelfCreatedReminderAction.isChecked()).popupOnLoginReminderToggleAction(this.filtersMap.get((Object)config).popupOnLoginReminderToggleAction.isChecked()).popupOnPatientSelectionToggleAction(this.filtersMap.get((Object)config).popupOnPatientSelectionReminderToggleAction.isChecked()).showAssignedToMeAction(this.filtersMap.get((Object)config).showAssignedToMeAction.isChecked()));
            currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
                if (this.generalPatientViewer != null && !this.generalPatientViewer.getTable().isDisposed()) {
                    try {
                        List input = (List)currentLoader.get();
                        this.generalPatientViewer.setInput((Object)input);
                        this.viewerSelectionComposite.setCount(SELECTIONCOMP_GENERALPATIENT_ID, this.generalPatientViewer.getTable().getItemCount());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                    }
                }
            }));
        }
    }

    private void refreshGeneralInput(String config) {
        if (this.filtersMap != null || this.filtersMap.isEmpty()) {
            CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new GeneralSupplier().showAll(ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false) && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.filtersMap.get((Object)config).showOnlyOwnDueReminderToggleAction.isChecked()).showNotYetDueReminders(this.filtersMap.get((Object)config).showNotYetDueReminderToggleAction.isChecked()).showSelfCreated(this.filtersMap.get((Object)config).showSelfCreatedReminderAction.isChecked()).popupOnLogin(this.filtersMap.get((Object)config).popupOnLoginReminderToggleAction.isChecked()).popupOnPatientSelectionToggleAction(this.filtersMap.get((Object)config).popupOnPatientSelectionReminderToggleAction.isChecked()).showAssignedToMeAction(this.filtersMap.get((Object)config).showAssignedToMeAction.isChecked()));
            currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
                if (this.generalRemindersViewer != null && !this.generalRemindersViewer.getTable().isDisposed()) {
                    try {
                        List input = (List)currentLoader.get();
                        this.generalRemindersViewer.setInput((Object)input);
                        this.viewerSelectionComposite.setCount(SELECTIONCOMP_GENERALREMINDERS_ID, this.generalRemindersViewer.getTable().getItemCount());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                    }
                }
            }));
        }
    }

    private void refreshMyRemindersInput(String config) {
        if (this.filtersMap != null || this.filtersMap.isEmpty()) {
            CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new MyRemindersSupplier().showAll(ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false) && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.filtersMap.get((Object)config).showOnlyOwnDueReminderToggleAction.isChecked()).showNotYetDueReminders(this.filtersMap.get((Object)config).showNotYetDueReminderToggleAction.isChecked()).showSelfCreated(this.filtersMap.get((Object)config).showSelfCreatedReminderAction.isChecked()).popupOnLogin(this.filtersMap.get((Object)config).popupOnLoginReminderToggleAction.isChecked()).popupOnPatientSelectionToggleAction(this.filtersMap.get((Object)config).popupOnPatientSelectionReminderToggleAction.isChecked()).showAssignedToMeAction(this.filtersMap.get((Object)config).showAssignedToMeAction.isChecked()));
            currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
                if (this.myViewer != null && !this.myViewer.getTable().isDisposed()) {
                    try {
                        List input = (List)currentLoader.get();
                        this.myViewer.setInput((Object)input);
                        this.viewerSelectionComposite.setCount(SELECTIONCOMP_MYREMINDERS_ID, this.myViewer.getTable().getItemCount());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                    }
                }
            }));
        }
    }

    private void refreshGroupRemindersInput(GroupComponent group) {
        if ((this.filtersMap != null || this.filtersMap.isEmpty()) && group.viewer().getTable().isVisible()) {
            CompletableFuture<List<IReminder>> currentLoader = CompletableFuture.supplyAsync(new GroupRemindersSupplier(group.id()).showAll(ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false) && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))).filterDue(this.filterDueDateDays != -1).showOnlyDue(this.filtersMap.get((Object)group.id()).showOnlyOwnDueReminderToggleAction.isChecked()).showNotYetDueReminders(this.filtersMap.get((Object)group.id()).showNotYetDueReminderToggleAction.isChecked()).showSelfCreated(this.filtersMap.get((Object)group.id()).showSelfCreatedReminderAction.isChecked()).popupOnLogin(this.filtersMap.get((Object)group.id()).popupOnLoginReminderToggleAction.isChecked()).popupOnPatientSelectionToggleAction(this.filtersMap.get((Object)group.id()).popupOnPatientSelectionReminderToggleAction.isChecked()).showAssignedToMeAction(this.filtersMap.get((Object)group.id()).showAssignedToMeAction.isChecked()));
            currentLoader.thenRunAsync(() -> Display.getDefault().asyncExec(() -> {
                if (group.viewer() != null && !group.viewer().getTable().isDisposed()) {
                    try {
                        List input = (List)currentLoader.get();
                        group.viewer().setInput((Object)input);
                        this.viewerSelectionComposite.setCount(String.valueOf(SELECTIONCOMP_GROUPREMINDERS_PREFIX) + group.id(), group.viewer().getTable().getItemCount());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error loading reminders", (Throwable)e);
                    }
                }
            }));
        }
    }

    private void applyDueDateFilter(IQuery<IReminder> query, boolean includeNoDue) {
        LocalDate now = LocalDate.now();
        LocalDate dueDateDays = now.plusDays(this.filterDueDateDays);
        if (!includeNoDue) {
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.NOT_EQUALS, null);
        }
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)now);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)dueDateDays);
    }

    private void refreshUserConfiguration() {
        this.filtersMap.values().forEach(fa -> fa.reload());
        this.colorInProgress = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.IN_PROGRESS.name()), (String)"FFFFFF"));
        this.colorDue = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.DUE.name()), (String)"FFFFFF"));
        this.colorOverdue = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.OVERDUE.name()), (String)"FF0000"));
        this.colorOpen = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.OPEN.name()), (String)"00FF00"));
    }

    private TableViewerColumn createTypeColumn(TableViewer viewer, int width, int columnIndex) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof IReminder) {
                    IReminder reminder = (IReminder)element;
                    Type actionType = reminder.getType();
                    switch (actionType) {
                        case PRINT: 
                        case PRINT_DRUG_STICKER: {
                            return Images.IMG_PRINTER.getImage();
                        }
                        case MAKE_APPOINTMENT: {
                            return Images.IMG_CALENDAR.getImage();
                        }
                        case DISPENSE_MEDICATION: {
                            return Images.IMG_PILL.getImage();
                        }
                        case PROCESS_SERVICE_RECORDING: {
                            return Images.IMG_MONEY.getImage();
                        }
                        case READ_DOCUMENT: 
                        case CHECK_LAB_RESULT: {
                            return Images.IMG_EYE_WO_SHADOW.getImage();
                        }
                        case SEND_DOCUMENT: {
                            return Images.IMG_MAIL_SEND.getImage();
                        }
                    }
                    return null;
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof IReminder) {
                    IReminder reminder = (IReminder)element;
                    Type actionType = reminder.getType();
                    return actionType.getLocaleText();
                }
                return null;
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createDateColumn(TableViewer viewer, int width, int columnIndex) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Datum");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private DateTimeFormatter defaultDateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                if (reminder.getDue() != null) {
                    return this.defaultDateFormatter.format(reminder.getDue());
                }
                return "";
            }

            public Color getBackground(Object element) {
                IReminder reminder = (IReminder)element;
                LocalDate now = LocalDate.now();
                if (reminder.getDue() != null) {
                    if (reminder.getDue().equals(now)) {
                        return ReminderListsView.this.colorDue;
                    }
                    if (reminder.getDue().isBefore(now)) {
                        return ReminderListsView.this.colorOverdue;
                    }
                    ProcessStatus processStatus = reminder.getStatus();
                    if (ProcessStatus.OPEN == processStatus) {
                        return ReminderListsView.this.colorOpen;
                    }
                    if (ProcessStatus.IN_PROGRESS == processStatus) {
                        return ReminderListsView.this.colorInProgress;
                    }
                }
                return null;
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createPatientColumn(TableViewer viewer, int width, int columnIndex) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Patient");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                IContact contact = reminder.getContact();
                return contact != null ? contact.getLabel() : "";
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createDescriptionColumn(TableViewer viewer, int width, int columnIndex) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Betreff");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                return StringUtils.isEmpty((CharSequence)reminder.getSubject()) ? reminder.getMessage() : reminder.getSubject();
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }

            public Font getFont(Object element) {
                IReminder reminder = (IReminder)element;
                Priority prio = reminder.getPriority();
                if (Priority.HIGH == prio) {
                    return ReminderListsView.this.boldFont;
                }
                return null;
            }
        });
        return viewerColumn;
    }

    private TableViewerColumn createResponsibleColumn(TableViewer viewer, int width, int columnIndex) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setWidth(width);
        tableColumn.setText("Zust.");
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(viewer, tableColumn, columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IReminder reminder = (IReminder)element;
                if (reminder.isResponsibleAll()) {
                    return "Alle";
                }
                List responsibles = reminder.getResponsible();
                if (responsibles != null) {
                    StringJoiner sj = new StringJoiner("| ");
                    responsibles.forEach(r -> {
                        if (r.isMandator()) {
                            sj.add(String.valueOf(r.getDescription1()) + " " + r.getDescription2());
                        } else {
                            sj.add(r.getLabel());
                        }
                    });
                    return sj.toString();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }
        });
        return viewerColumn;
    }

    private ISelectionChangedListener getSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ReminderListsView.this.selectionChanged(selection.toList());
                ReminderListsView.this.selectPatientAction.setEnabled(selection.size() <= 1);
                ReminderListsView.this.selectPatientAction.reflectRight();
                if (ReminderListsView.this.toggleAutoSelectPatientAction.isChecked() && ReminderListsView.this.selectPatientAction.isEnabled()) {
                    ReminderListsView.this.selectPatientAction.doRun();
                }
            }
        };
    }

    private IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    final IReminder reminder = (IReminder)selection.getFirstElement();
                    AcquireLockBlockingUi.aquireAndRun((Identifiable)reminder, new ILockHandler(){

                        @Override
                        public void lockAcquired() {
                            ReminderDetailDialog rdd = new ReminderDetailDialog(UiDesk.getTopShell(), (Reminder)NoPoUtil.loadAsPersistentObject((Identifiable)reminder));
                            int retVal = rdd.open();
                            if (retVal == 0) {
                                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)reminder);
                            }
                        }

                        @Override
                        public void lockFailed() {
                            ReminderListsView.this.refreshKeepLabels();
                        }
                    });
                }
            }
        };
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer viewer, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReminderComparator comparator = (ReminderComparator)viewer.getComparator();
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                viewer.getTable().setSortColumn(column);
                viewer.getTable().setSortDirection(dir);
                viewer.refresh(true);
            }
        };
        return selectionAdapter;
    }

    public void heartbeat() {
        long highestLastUpdate = CoreModelServiceHolder.get().getHighestLastUpdate(IReminder.class);
        if (highestLastUpdate > this.cvHighestLastUpdate) {
            this.refresh();
            this.cvHighestLastUpdate = highestLastUpdate;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.currentSelection);
    }

    public void setSelection(ISelection arg0) {
    }

    private List<IUserGroup> getUserGroups() {
        List userGroups = CoreModelServiceHolder.get().getQuery(IUserGroup.class).execute();
        userGroups.sort((u1, u2) -> u1.getLabel().compareTo(u2.getLabel()));
        ArrayList<IUserGroup> filtered = new ArrayList<IUserGroup>();
        for (IUserGroup group : userGroups) {
            if (!group.getUsers().contains(ContextServiceHolder.get().getActiveUser().get())) continue;
            filtered.add(group);
        }
        return filtered;
    }

    private void clearSelection() {
        StructuredSelection clear = new StructuredSelection();
        for (Map.Entry<TableViewer, String> set : this.allViewers.entrySet()) {
            TableViewer viewer = set.getKey();
            viewer.setSelection((ISelection)clear);
        }
    }

    private void selectionChanged(List<IReminder> list) {
        this.currentSelection.clear();
        this.currentSelection.addAll(list);
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        ISelection selection = this.getSelection();
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            listener.selectionChanged(event);
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private class CurrentPatientSupplier
    implements Supplier<List<IReminder>> {
        private IPatient patient;
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;
        private boolean popupOnLogin;
        private boolean popupOnPatientSelection;
        private boolean assignedToMe;
        private boolean showNotYetDueReminders;

        public CurrentPatientSupplier(IPatient actPatient) {
            this.patient = actPatient;
        }

        @Override
        public List<IReminder> get() {
            if (this.patient != null) {
                IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)this.patient);
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
                if (this.showOnlyDue) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
                }
                if (this.showNotYetDueReminders) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
                }
                if (this.popupOnLogin || this.popupOnPatientSelection) {
                    query.startGroup();
                    if (this.popupOnLogin) {
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
                    }
                    if (this.popupOnPatientSelection) {
                        if (this.popupOnLogin) {
                            query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                        } else {
                            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                        }
                    }
                    query.andJoinGroups();
                }
                if (this.showSelfCreated) {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m));
                }
                if (this.assignedToMe) {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                        query.exists(subQuery);
                    });
                }
                if (this.filterDue) {
                    ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
                }
                return query.execute();
            }
            return Collections.emptyList();
        }

        public CurrentPatientSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public CurrentPatientSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public CurrentPatientSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public CurrentPatientSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }

        public CurrentPatientSupplier popupOnLogin(boolean value) {
            this.popupOnLogin = value;
            return this;
        }

        public CurrentPatientSupplier popupOnPatientSelectionToggleAction(boolean value) {
            this.popupOnPatientSelection = value;
            return this;
        }

        public CurrentPatientSupplier showAssignedToMeAction(boolean value) {
            this.assignedToMe = value;
            return this;
        }

        public CurrentPatientSupplier showNotYetDueReminders(boolean value) {
            this.showNotYetDueReminders = value;
            return this;
        }
    }

    private class CustomTimeAction
    extends Action {
        private List<Action> others;
        private String id;

        public CustomTimeAction(String text, String id) {
            super(text, 2);
            this.id = id;
            List<Integer> list = List.of(Integer.valueOf(-1), Integer.valueOf(30), Integer.valueOf(60), Integer.valueOf(90));
            this.setChecked(!list.contains(ReminderListsView.this.filterDueDateDays));
        }

        public void setOthers(List<Action> list) {
            this.others = list;
        }

        public void run() {
            if (this.isChecked()) {
                CustomTimePopupDialog dialog = new CustomTimePopupDialog();
                if (dialog.open() == 0) {
                    int days;
                    ReminderListsView.this.filterDueDateDays = days = dialog.getSelectedDays();
                    if (ReminderListsView.this.useGlobalFilters) {
                        ConfigServiceHolder.setUser((String)"reminder/filterDueDays/global", (int)days);
                    } else {
                        ConfigServiceHolder.setUser((String)("reminder/filterDueDays/" + this.id), (int)days);
                    }
                }
            } else {
                ReminderListsView.this.filterDueDateDays = -1;
                if (ReminderListsView.this.useGlobalFilters) {
                    ConfigServiceHolder.setUser((String)"reminder/filterDueDays/global", (int)-1);
                } else {
                    ConfigServiceHolder.setUser((String)("reminder/filterDueDays/" + this.id), (int)-1);
                }
            }
            ReminderListsView.this.clearSelection();
            ReminderListsView.this.refresh();
            if (this.others != null) {
                for (Action other : this.others) {
                    other.setChecked(false);
                }
            }
        }
    }

    private class CustomTimePopupDialog
    extends Dialog {
        LocalDate today;
        private int selectedDays;
        private String title;

        public CustomTimePopupDialog() {
            super(ReminderListsView.this.getViewSite().getShell());
            this.today = LocalDate.now();
            this.selectedDays = 0;
            this.title = "N\u00e4chste %s Tage";
        }

        protected Control createDialogArea(Composite parent) {
            this.updateTitle(parent);
            Composite area = (Composite)super.createDialogArea(parent);
            area.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime(area, 3072);
            calendar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            calendar.addListener(13, e -> {
                LocalDate selectedDate = LocalDate.of(calendar.getYear(), calendar.getMonth() + 1, calendar.getDay());
                if (selectedDate.isBefore(this.today)) {
                    calendar.setDate(this.today.getYear(), this.today.getMonthValue() - 1, this.today.getDayOfMonth());
                } else {
                    this.selectedDays = (int)ChronoUnit.DAYS.between(this.today, selectedDate);
                    this.updateTitle(parent);
                }
            });
            return area;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        public int getSelectedDays() {
            return this.selectedDays;
        }

        private void updateTitle(Composite parent) {
            parent.getShell().setText(String.format(this.title, this.selectedDays));
        }
    }

    private record FilterActions(Action deleteReminderAction, Action showAssignedToMeAction, Action popupOnPatientSelectionReminderToggleAction, Action popupOnLoginReminderToggleAction, Action showNotYetDueReminderToggleAction, Action showOnlyOwnDueReminderToggleAction, Action showSelfCreatedReminderAction, RestrictedAction showOthersRemindersAction) {
        public void reload() {
            Object[] objectArray = new Object[]{this.showAssignedToMeAction, this.popupOnPatientSelectionReminderToggleAction, this.popupOnLoginReminderToggleAction, this.showNotYetDueReminderToggleAction, this.showOnlyOwnDueReminderToggleAction, this.showSelfCreatedReminderAction, this.showOthersRemindersAction};
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object action = objectArray[n2];
                try {
                    Method refreshMethod = action.getClass().getMethod("reload", new Class[0]);
                    refreshMethod.invoke(action, new Object[0]);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error reloading filters", (Throwable)e);
                }
                ++n2;
            }
        }

        public void reset() {
            Object[] objectArray = new Object[]{this.showAssignedToMeAction, this.popupOnPatientSelectionReminderToggleAction, this.popupOnLoginReminderToggleAction, this.showNotYetDueReminderToggleAction, this.showOnlyOwnDueReminderToggleAction, this.showSelfCreatedReminderAction};
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object action = objectArray[n2];
                try {
                    Method refreshMethod = action.getClass().getMethod("reset", new Class[0]);
                    refreshMethod.invoke(action, new Object[0]);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error resetting filters", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    private class FilterTimeAction
    extends Action {
        private List<Action> others;
        private int days;

        public FilterTimeAction(int days) {
            super(String.format("n\u00e4chste %d Tage", days), 2);
            this.days = days;
            if (ReminderListsView.this.filterDueDateDays == days) {
                this.setChecked(true);
            }
        }

        public void setOthers(List<Action> list) {
            this.others = list;
        }

        public void run() {
            if (this.isChecked()) {
                ConfigServiceHolder.setUser((String)"reminder/filterDueDays", (int)this.days);
                ReminderListsView.this.filterDueDateDays = this.days;
                ReminderListsView.this.clearSelection();
                ReminderListsView.this.refresh();
            } else {
                ConfigServiceHolder.setUser((String)"reminder/filterDueDays", (int)-1);
                ReminderListsView.this.filterDueDateDays = -1;
                ReminderListsView.this.clearSelection();
                ReminderListsView.this.refresh();
            }
            if (this.others != null) {
                for (Action other : this.others) {
                    other.setChecked(false);
                }
            }
        }
    }

    private class GeneralPatientSupplier
    implements Supplier<List<IReminder>> {
        private IPatient patient;
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;
        private boolean popupOnLogin;
        private boolean popupOnPatientSelection;
        private boolean assignedToMe;
        private boolean showNotYetDueReminders;

        public GeneralPatientSupplier(IPatient actPatient) {
            this.patient = actPatient;
        }

        @Override
        public List<IReminder> get() {
            IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
            if (!this.showAll) {
                query.andFeatureCompare((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.NOT_EQUALS, (EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT);
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
            }
            if (this.showOnlyDue) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.showNotYetDueReminders) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.popupOnLogin || this.popupOnPatientSelection) {
                query.startGroup();
                if (this.popupOnLogin) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
                }
                if (this.popupOnPatientSelection) {
                    if (this.popupOnLogin) {
                        query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    } else {
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    }
                }
                query.andJoinGroups();
            }
            if (this.showSelfCreated) {
                ContextServiceHolder.get().getActiveMandator().ifPresent(m -> query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m));
            }
            if (this.assignedToMe) {
                ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                    ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                    subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                    subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                    query.exists(subQuery);
                });
            }
            if (this.filterDue) {
                ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
            }
            return query.execute();
        }

        public GeneralPatientSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public GeneralPatientSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public GeneralPatientSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public GeneralPatientSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }

        public GeneralPatientSupplier popupOnLoginReminderToggleAction(boolean value) {
            this.popupOnLogin = value;
            return this;
        }

        public GeneralPatientSupplier popupOnPatientSelectionToggleAction(boolean value) {
            this.popupOnPatientSelection = value;
            return this;
        }

        public GeneralPatientSupplier showAssignedToMeAction(boolean value) {
            this.assignedToMe = value;
            return this;
        }

        public GeneralPatientSupplier showNotYetDueReminders(boolean value) {
            this.showNotYetDueReminders = value;
            return this;
        }
    }

    private class GeneralSupplier
    implements Supplier<List<IReminder>> {
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;
        private boolean popupOnLogin;
        private boolean popupOnPatientSelection;
        private boolean assignedToMe;
        private boolean showNotYetDueReminders;

        private GeneralSupplier() {
        }

        @Override
        public List<IReminder> get() {
            IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
            query.andFeatureCompare((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, (EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT);
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
            if (this.showOnlyDue) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.showNotYetDueReminders) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.popupOnLogin || this.popupOnPatientSelection) {
                query.startGroup();
                if (this.popupOnLogin) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
                }
                if (this.popupOnPatientSelection) {
                    if (this.popupOnLogin) {
                        query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    } else {
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    }
                }
                query.andJoinGroups();
            }
            if (!this.showAll) {
                if (this.showSelfCreated) {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m));
                }
                if (this.assignedToMe) {
                    ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                        query.exists(subQuery);
                    });
                }
            }
            if (this.filterDue) {
                ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
            }
            return query.execute();
        }

        public GeneralSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public GeneralSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public GeneralSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public GeneralSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }

        public GeneralSupplier popupOnLogin(boolean value) {
            this.popupOnLogin = value;
            return this;
        }

        public GeneralSupplier popupOnPatientSelectionToggleAction(boolean value) {
            this.popupOnPatientSelection = value;
            return this;
        }

        public GeneralSupplier showAssignedToMeAction(boolean value) {
            this.assignedToMe = value;
            return this;
        }

        public GeneralSupplier showNotYetDueReminders(boolean value) {
            this.showNotYetDueReminders = value;
            return this;
        }
    }

    record GroupComponent(String id, HeaderComposite header, TableViewer viewer) {
    }

    private class GroupRemindersSupplier
    implements Supplier<List<IReminder>> {
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;
        private boolean popupOnLogin;
        private boolean popupOnPatientSelection;
        private boolean assignedToMe;
        private boolean showNotYetDueReminders;
        private String groupId;

        public GroupRemindersSupplier(String id) {
            this.groupId = id;
        }

        @Override
        public List<IReminder> get() {
            IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
            if (this.showOnlyDue) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.showNotYetDueReminders) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.popupOnLogin || this.popupOnPatientSelection) {
                query.startGroup();
                if (this.popupOnLogin) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
                }
                if (this.popupOnPatientSelection) {
                    if (this.popupOnLogin) {
                        query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    } else {
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    }
                }
                query.andJoinGroups();
            }
            if (!this.showAll && this.showSelfCreated) {
                ContextServiceHolder.get().getActiveMandator().ifPresent(m -> query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m));
            }
            IUserGroup group = null;
            for (IUserGroup g : ReminderListsView.this.userGroups) {
                if (!g.getId().equalsIgnoreCase(this.groupId)) continue;
                group = g;
            }
            if (group != null) {
                List contactList = group.getUsers().stream().map(user -> user.getAssignedContact()).collect(Collectors.toList());
                for (IContact c : contactList) {
                    ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                    subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                    subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)c);
                    query.exists(subQuery);
                }
                ISubQuery excludeQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                excludeQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                for (IContact c : contactList) {
                    excludeQuery.and("responsible", IQuery.COMPARATOR.NOT_EQUALS, (Object)c);
                }
                query.notExists(excludeQuery);
            }
            if (this.filterDue) {
                ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
            }
            return query.execute();
        }

        public GroupRemindersSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public GroupRemindersSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public GroupRemindersSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public GroupRemindersSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }

        public GroupRemindersSupplier popupOnLogin(boolean value) {
            this.popupOnLogin = value;
            return this;
        }

        public GroupRemindersSupplier popupOnPatientSelectionToggleAction(boolean value) {
            this.popupOnPatientSelection = value;
            return this;
        }

        public GroupRemindersSupplier showAssignedToMeAction(boolean value) {
            this.assignedToMe = value;
            return this;
        }

        public GroupRemindersSupplier showNotYetDueReminders(boolean value) {
            this.showNotYetDueReminders = value;
            return this;
        }
    }

    private class HeaderComposite
    extends Composite {
        private Label header;
        private ToolBarManager toolbarManager;

        public HeaderComposite(Composite parent, int style) {
            super(parent, style);
            this.setBackground(parent.getBackground());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            this.header = new Label((Composite)this, 0);
            this.header.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.header.setBackground(this.getBackground());
            this.toolbarManager = new ToolBarManager();
            ToolBar toolbar = this.toolbarManager.createControl((Composite)this);
            toolbar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            toolbar.setBackground(this.getBackground());
        }

        public void setTextFont(Font font) {
            this.header.setFont(font);
        }

        public void setText(String text) {
            this.header.setText(text);
            ReminderListsView.this.viewParent.layout(true, true);
        }
    }

    private class MyRemindersSupplier
    implements Supplier<List<IReminder>> {
        private boolean showAll;
        private boolean filterDue;
        private boolean showSelfCreated;
        private boolean showOnlyDue;
        private boolean popupOnLogin;
        private boolean popupOnPatientSelection;
        private boolean assignedToMe;
        private boolean showNotYetDueReminders;

        private MyRemindersSupplier() {
        }

        @Override
        public List<IReminder> get() {
            IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
            if (this.showOnlyDue) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.showNotYetDueReminders) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)LocalDate.now());
            }
            if (this.popupOnLogin || this.popupOnPatientSelection) {
                query.startGroup();
                if (this.popupOnLogin) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
                }
                if (this.popupOnPatientSelection) {
                    if (this.popupOnLogin) {
                        query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    } else {
                        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
                    }
                }
                query.andJoinGroups();
            }
            if (!this.showAll && this.showSelfCreated) {
                ContextServiceHolder.get().getActiveMandator().ifPresent(m -> query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, m));
            }
            ContextServiceHolder.get().getActiveMandator().ifPresent(m -> {
                ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, m);
                query.exists(subQuery);
                ISubQuery secondSubQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                secondSubQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                secondSubQuery.and("responsible", IQuery.COMPARATOR.NOT_EQUALS, m);
                query.notExists(secondSubQuery);
            });
            if (this.filterDue) {
                ReminderListsView.this.applyDueDateFilter((IQuery<IReminder>)query, false);
            }
            return query.execute();
        }

        public MyRemindersSupplier showAll(boolean value) {
            this.showAll = value;
            return this;
        }

        public MyRemindersSupplier filterDue(boolean value) {
            this.filterDue = value;
            return this;
        }

        public MyRemindersSupplier showSelfCreated(boolean value) {
            this.showSelfCreated = value;
            return this;
        }

        public MyRemindersSupplier showOnlyDue(boolean showOnlyDueReminders) {
            this.showOnlyDue = showOnlyDueReminders;
            return this;
        }

        public MyRemindersSupplier popupOnLogin(boolean value) {
            this.popupOnLogin = value;
            return this;
        }

        public MyRemindersSupplier popupOnPatientSelectionToggleAction(boolean value) {
            this.popupOnPatientSelection = value;
            return this;
        }

        public MyRemindersSupplier showAssignedToMeAction(boolean value) {
            this.assignedToMe = value;
            return this;
        }

        public MyRemindersSupplier showNotYetDueReminders(boolean value) {
            this.showNotYetDueReminders = value;
            return this;
        }
    }

    private class ReminderComparator
    extends ViewerComparator
    implements Comparator<IReminder> {
        private int column = -1;
        private int direction = 1024;

        @Override
        public int compare(IReminder r1, IReminder r2) {
            int result = 0;
            switch (this.column) {
                case 0: {
                    result = this.compareByString(r1.getType().toString(), r2.getType().toString());
                    break;
                }
                case 1: {
                    result = this.compareByDate(r1, r2);
                    break;
                }
                case 2: {
                    result = this.compareByString(r1.getResponsible().toString(), r2.getResponsible().toString());
                    break;
                }
                case 3: {
                    result = this.compareByString(r1.getContact().getLabel(), r2.getContact().getLabel());
                    break;
                }
                case 4: {
                    result = this.compareByString(r1.getSubject(), r2.getSubject());
                    break;
                }
                default: {
                    result = this.compareByDate(r1, r2);
                }
            }
            return this.direction == 128 ? -result : result;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare((IReminder)e1, (IReminder)e2);
        }

        private int compareByDate(IReminder r1, IReminder r2) {
            if (r1.getDue() != null && r2.getDue() != null) {
                return r1.getDue().compareTo(r2.getDue());
            }
            if (r1.getDue() == null && r2.getDue() == null) {
                return 0;
            }
            return r1.getDue() == null ? 1 : -1;
        }

        private int compareByString(String s1, String s2) {
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareToIgnoreCase(s2);
        }

        public void setColumn(int index) {
            if (this.column == index) {
                this.direction = this.direction == 1024 ? 128 : 1024;
            } else {
                this.column = index;
                this.direction = 1024;
            }
        }

        public int getDirection() {
            return this.direction;
        }
    }

    private class ReminderStatusSubMenu
    extends MenuManager {
        private TableViewer viewer;

        public ReminderStatusSubMenu(String id) {
            super("Status...");
            this.viewer = ReminderListsView.this.getViewerForId(id);
            this.setRemoveAllWhenShown(true);
            this.addMenuListener(new ReminderStatusSubMenuListener());
        }

        private class ReminderStatusSubMenuListener
        implements IMenuListener {
            private ReminderStatusSubMenuListener() {
            }

            public void menuAboutToShow(IMenuManager manager) {
                StructuredSelection selection = (StructuredSelection)ReminderStatusSubMenu.this.viewer.getStructuredSelection();
                if (selection != null && selection.size() == 1) {
                    if (selection.getFirstElement() instanceof IReminder) {
                        IReminder reminder = (IReminder)selection.getFirstElement();
                        manager.add((IAction)new StatusAction(ProcessStatus.OPEN, reminder));
                        manager.add((IAction)new StatusAction(ProcessStatus.IN_PROGRESS, reminder));
                        manager.add((IAction)new StatusAction(ProcessStatus.CLOSED, reminder));
                        manager.add((IAction)new StatusAction(ProcessStatus.ON_HOLD, reminder));
                    }
                } else {
                    manager.add((IAction)new Action("Multiple selection"){

                        public boolean isEnabled() {
                            return false;
                        }
                    });
                }
            }

            private class StatusAction
            extends LockRequestingAction<IReminder> {
                private final ProcessStatus representedStatus;
                private IReminder reminder;

                public StatusAction(ProcessStatus representedStatus, IReminder reminder) {
                    super(representedStatus.getLocaleText(), 16);
                    this.representedStatus = representedStatus;
                    this.reminder = reminder;
                    ProcessStatus status = reminder.getStatus();
                    if (ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) {
                        this.setChecked(representedStatus == ProcessStatus.OPEN);
                    } else {
                        this.setChecked(representedStatus == status);
                    }
                }

                public boolean isChecked() {
                    ProcessStatus status = this.reminder.getStatus();
                    if (ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) {
                        return this.representedStatus == ProcessStatus.OPEN;
                    }
                    return this.representedStatus == this.reminder.getStatus();
                }

                public String getText() {
                    String text = super.getText();
                    ProcessStatus status = this.reminder.getStatus();
                    if ((ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) && ProcessStatus.OPEN == this.representedStatus) {
                        return String.valueOf(text) + " (" + status.getLocaleText() + ")";
                    }
                    return text;
                }

                @Override
                public IReminder getTargetedObject() {
                    return this.reminder;
                }

                @Override
                public void doRun(IReminder element) {
                    element.setStatus(this.representedStatus);
                    CoreModelServiceHolder.get().save((Identifiable)element);
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)element);
                }
            }
        }
    }

    private static enum TableType {
        CURRENT_PATIENT,
        GENERAL_PATIENT,
        GENERALREMINDERS,
        MYREMINDERS,
        GROUP;

    }

    private class TableViewerResizer {
        private static int lastY = 0;
        private static int newY = 0;
        private static int tolerance = 15;
        private static int minHeight = 25;

        private TableViewerResizer() {
        }

        public static void enableResizing(TableViewer tableViewer, final ScrolledComposite scrolledComposite) {
            final Table table = tableViewer.getTable();
            final Composite parent = table.getParent();
            table.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (TableViewerResizer.isNearBottomEdge(table, e.y)) {
                        table.setCursor(parent.getDisplay().getSystemCursor(21));
                    } else if (e.stateMask != 524288 && table.getCursor() != null) {
                        table.setCursor(null);
                    }
                    if (e.stateMask == 524288 && lastY != 0) {
                        newY = e.y;
                    }
                }
            });
            table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (TableViewerResizer.isNearBottomEdge(table, e.y)) {
                        lastY = e.y;
                        table.setCursor(parent.getDisplay().getSystemCursor(21));
                    }
                }

                public void mouseUp(MouseEvent e) {
                    if (lastY != 0 && lastY != newY) {
                        int newHeight;
                        int deltaY = newY - lastY;
                        GridData gd = (GridData)table.getLayoutData();
                        if (deltaY != 0 && (newHeight = gd.heightHint + deltaY) > minHeight) {
                            gd.heightHint = newHeight;
                            table.setLayoutData((Object)gd);
                            lastY += deltaY;
                            table.getParent().layout(true, true);
                            Point newSize = table.getParent().computeSize(-1, -1);
                            scrolledComposite.setMinSize(newSize.x, Math.max(newSize.y, scrolledComposite.getClientArea().height));
                            scrolledComposite.layout(true, true);
                        }
                    }
                    lastY = 0;
                }
            });
        }

        private static boolean isNearBottomEdge(Table table, int y) {
            int tableHeight = table.getBounds().height;
            if (table.getHorizontalBar().isVisible()) {
                tableHeight -= table.getHorizontalBar().getSize().y;
            }
            return y >= tableHeight - tolerance && y <= tableHeight + tolerance;
        }
    }

    private class ViewerSelectionComposite
    extends Composite
    implements ISelectionProvider {
        private List<Action> currentSelection;
        private ListenerList<ISelectionChangedListener> selectionChangedListeners;
        private ToolBarManager manager;

        public ViewerSelectionComposite(Composite parent, int style) {
            super(parent, style);
            this.currentSelection = new ArrayList<Action>();
            this.selectionChangedListeners = new ListenerList();
            this.createContent();
        }

        public void setCount(String id, int itemCount) {
            IContributionItem[] iContributionItemArray = this.manager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item.getId().equals(id)) {
                    IAction action = ((ActionContributionItem)item).getAction();
                    String text = action.getText();
                    if (text.indexOf(" (") != -1) {
                        text = text.substring(0, text.indexOf(" ("));
                    }
                    action.setText(String.valueOf(text) + " (" + itemCount + ")");
                    item.update();
                }
                ++n2;
            }
            this.manager.update(true);
            this.layout();
        }

        private void createContent() {
            this.setBackground(UiDesk.getColor("weiss"));
            this.setLayout((Layout)new FillLayout());
            this.manager = new ToolBarManager(64);
            this.manager.add((IAction)new Action("aktueller Patient", 2){

                public String getId() {
                    return SELECTIONCOMP_CURRENTPATIENT_ID;
                }

                public void run() {
                    if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                        ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                    } else {
                        ViewerSelectionComposite.this.currentSelection.add(this);
                    }
                    ViewerSelectionComposite.this.fireSelectionChanged();
                    ViewerSelectionComposite.this.manager.update(true);
                    ViewerSelectionComposite.this.saveSelection();
                }
            });
            this.manager.add((IAction)new Action("alle Patienten", 2){

                public String getId() {
                    return SELECTIONCOMP_GENERALPATIENT_ID;
                }

                public void run() {
                    if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                        ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                    } else {
                        ViewerSelectionComposite.this.currentSelection.add(this);
                    }
                    ViewerSelectionComposite.this.fireSelectionChanged();
                    ViewerSelectionComposite.this.manager.update(true);
                    ViewerSelectionComposite.this.saveSelection();
                }
            });
            this.manager.add((IAction)new Action("Pendenzen ohne Patientenbezug", 2){

                public String getId() {
                    return SELECTIONCOMP_GENERALREMINDERS_ID;
                }

                public void run() {
                    if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                        ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                    } else {
                        ViewerSelectionComposite.this.currentSelection.add(this);
                    }
                    ViewerSelectionComposite.this.fireSelectionChanged();
                    ViewerSelectionComposite.this.manager.update(true);
                    ViewerSelectionComposite.this.saveSelection();
                }
            });
            this.manager.add((IAction)new Action("meine Pendenzen", 2){

                public String getId() {
                    return SELECTIONCOMP_MYREMINDERS_ID;
                }

                public void run() {
                    if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                        ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                    } else {
                        ViewerSelectionComposite.this.currentSelection.add(this);
                    }
                    ViewerSelectionComposite.this.fireSelectionChanged();
                    ViewerSelectionComposite.this.manager.update(true);
                    ViewerSelectionComposite.this.saveSelection();
                }
            });
            for (final IUserGroup group : ReminderListsView.this.userGroups) {
                this.manager.add((IAction)new Action(group.getId(), 2){

                    public String getId() {
                        return String.valueOf(SELECTIONCOMP_GROUPREMINDERS_PREFIX) + group.getId();
                    }

                    public void run() {
                        if (ViewerSelectionComposite.this.currentSelection.contains((Object)this)) {
                            ViewerSelectionComposite.this.currentSelection.remove((Object)this);
                        } else {
                            ViewerSelectionComposite.this.currentSelection.add(this);
                        }
                        ViewerSelectionComposite.this.fireSelectionChanged();
                        ViewerSelectionComposite.this.manager.update(true);
                        ViewerSelectionComposite.this.saveSelection();
                    }
                });
            }
            this.manager.createControl((Composite)this);
        }

        private void saveSelection() {
            List<String> selectedIds = this.currentSelection.stream().map(action -> action.getId()).collect(Collectors.toList());
            StringJoiner sj = new StringJoiner(",");
            selectedIds.forEach(id -> {
                StringJoiner stringJoiner2 = sj.add((CharSequence)id);
            });
            ConfigServiceHolder.setUser((String)"reminder/viewerSelection", (String)sj.toString());
        }

        public void loadSelection() {
            String[] loadedIds;
            this.currentSelection.clear();
            String[] stringArray = loadedIds = ConfigServiceHolder.getUser((String)"reminder/viewerSelection", (String)"").split(",");
            int n = loadedIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IContributionItem[] iContributionItemArray = this.manager.getItems();
                int n3 = iContributionItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IContributionItem item = iContributionItemArray[n4];
                    if (item.getId().equals(id)) {
                        IAction action = ((ActionContributionItem)item).getAction();
                        action.setChecked(true);
                        this.currentSelection.add((Action)action);
                    }
                    ++n4;
                }
                this.fireSelectionChanged();
                this.manager.update(true);
                this.layout();
                ++n2;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            return new StructuredSelection(this.currentSelection.stream().map(action -> action.getId()).collect(Collectors.toList()));
        }

        public void setSelection(ISelection selection) {
        }

        private void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
                listener.selectionChanged(event);
            }
        }
    }
}

