/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.model.IContact;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.data.dto.MakroDTO;
import java.util.Optional;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.LoggerFactory;

public class MakroDetailComposite
extends Composite {
    private WritableValue<MakroDTO> value;
    private DataBindingContext bindingContext;
    private Text makroName;
    private boolean nameDirty;
    private StyledText makroContent;
    private boolean contentDirty;

    public MakroDetailComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, true));
        this.createContent();
    }

    private void createContent() {
        this.value = new WritableValue();
        this.bindingContext = new DataBindingContext();
        this.makroName = new Text((Composite)this, 2048);
        this.makroName.setMessage("Makro Name");
        this.makroName.setLayoutData((Object)new GridData(4, 128, true, false));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.makroName), PojoProperties.value((String)"makroName").observeDetail(this.value));
        this.makroName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MakroDetailComposite.this.nameDirty = true;
            }
        });
        this.makroName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (MakroDetailComposite.this.nameDirty) {
                    MakroDetailComposite.this.save(MakroDetailComposite.this.getMakro());
                }
                super.focusLost(e);
            }
        });
        this.makroContent = new StyledText((Composite)this, 2050);
        this.makroContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.makroContent), PojoProperties.value((String)"makroContent").observeDetail(this.value));
        this.makroContent.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MakroDetailComposite.this.contentDirty = true;
            }
        });
        this.makroContent.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (MakroDetailComposite.this.contentDirty) {
                    MakroDetailComposite.this.save(MakroDetailComposite.this.getMakro());
                }
                super.focusLost(e);
            }
        });
    }

    public void setMakro(MakroDTO makro) {
        this.value.setValue((Object)makro);
        this.nameDirty = false;
        this.contentDirty = false;
    }

    public MakroDTO getMakro() {
        return (MakroDTO)this.value.getValue();
    }

    private void save(MakroDTO makro) {
        if (this.nameDirty) {
            MakroDetailComposite.removeMakro(makro);
            StringBuilder name = new StringBuilder(makro.getMakroName());
            makro.setMakroParam("makros/" + name.reverse());
        }
        MakroDetailComposite.saveMakro(makro);
        this.nameDirty = false;
        this.contentDirty = false;
    }

    public static void saveMakro(MakroDTO makro) {
        Optional userContact = CoreModelServiceHolder.get().load(makro.getMakroUserId(), IContact.class);
        if (userContact.isPresent()) {
            ConfigServiceHolder.get().set((IContact)userContact.get(), makro.getMakroParam(), makro.getMakroContent());
        } else {
            LoggerFactory.getLogger(MakroDetailComposite.class).warn("No user to save makro [" + makro.getMakroName() + "] userid [" + makro.getMakroUserId() + "]");
        }
    }

    public static void removeMakro(MakroDTO makro) {
        Optional userContact = CoreModelServiceHolder.get().load(makro.getMakroUserId(), IContact.class);
        if (userContact.isPresent()) {
            ConfigServiceHolder.get().set((IContact)userContact.get(), makro.getMakroParam(), null);
        } else {
            LoggerFactory.getLogger(MakroDetailComposite.class).warn("No user to remove makro [" + makro.getMakroName() + "] userid [" + makro.getMakroUserId() + "]");
        }
    }
}

