/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.FallDetailBlatt2;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Fall;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;

public class FallDetailView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.FallDetailView";
    FallDetailBlatt2 fdb;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (this.fdb != null && !this.fdb.isDisposed()) {
                this.adaptForUser(user);
            }
        });
    }

    private void adaptForUser(IUser user) {
        this.fdb.setUser(user);
        this.fdb.reloadBillingSystemsMenu();
    }

    @Inject
    public void activeCoverage(@Optional ICoverage coverage) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Fall fall = (Fall)NoPoUtil.loadAsPersistentObject((Identifiable)coverage, Fall.class);
            Fall deselectedFall = this.fdb.getFall();
            if (fall != null) {
                this.fdb.setFall((IFall)fall);
                if (deselectedFall != null) {
                    this.releaseAndRefreshLock((IPersistentObject)deselectedFall, "ch.elexis.core.ui.command.ToggleCurrentCaseLockCommand");
                }
            } else {
                this.fdb.setFall(null);
                if (deselectedFall != null) {
                    this.releaseAndRefreshLock((IPersistentObject)deselectedFall, "ch.elexis.core.ui.command.ToggleCurrentCaseLockCommand");
                }
            }
        }, (Object)this.fdb);
    }

    @Optional
    @Inject
    void lockedCoverage(@UIEventTopic(value="info/elexis/locking/aquired") ICoverage coverage) {
        Fall fall = (Fall)NoPoUtil.loadAsPersistentObject((Identifiable)coverage, Fall.class);
        if (this.fdb != null && fall.equals((Object)this.fdb.getFall())) {
            this.fdb.setUnlocked(true);
        }
    }

    @Optional
    @Inject
    void unlockedCoverage(@UIEventTopic(value="info/elexis/locking/released") ICoverage coverage) {
        Fall fall = (Fall)NoPoUtil.loadAsPersistentObject((Identifiable)coverage, Fall.class);
        if (this.fdb != null && fall.equals((Object)this.fdb.getFall())) {
            this.fdb.setUnlocked(false);
        }
    }

    private void releaseAndRefreshLock(IPersistentObject object, String commandId) {
        if (object != null && LocalLockServiceHolder.get().isLockedLocal((Object)object)) {
            LocalLockServiceHolder.get().releaseLock((Object)object);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.fdb = new FallDetailBlatt2(parent);
        this.fdb.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.fdb.setUnlocked(false);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setFocus() {
        this.fdb.setFocus();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    public Fall getActiveFall() {
        return this.fdb.getFall();
    }

    @Override
    public void refresh() {
        this.fdb.setFall((IFall)NoPoUtil.loadAsPersistentObject((Identifiable)ContextServiceHolder.get().getActiveCoverage().orElse(null), Fall.class));
    }
}

