/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.JobPool;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.rgw.tools.Tree;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeContentProvider
implements ITreeContentProvider,
BackgroundJob.BackgroundJobListener,
ViewerConfigurer.ICommonViewerContentProvider {
    BackgroundJob job;
    CommonViewer viewer;

    public TreeContentProvider(CommonViewer v, BackgroundJob loader) {
        this.job = loader;
        this.viewer = v;
        if (JobPool.getJobPool().getJob(this.job.getJobname()) == null) {
            JobPool.getJobPool().addJob(this.job);
        }
        this.job.addListener(this);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof Tree) {
            Tree tr = (Tree)element;
            return tr.getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof Tree) {
            Tree tr = (Tree)element;
            return tr.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Tree) {
            Tree tr = (Tree)element;
            return tr.hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Tree result = (Tree)this.job.getData();
        if (result == null) {
            JobPool.getJobPool().activate(this.job.getJobname(), 20);
            return new String[]{Messages.Core_Load_Files_ellipsis};
        }
        if (this.viewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            result.setFilter(null);
        } else {
            result.setFilter(((DefaultControlFieldProvider)this.viewer.getConfigurer().getControlFieldProvider()).createFilter());
        }
        Collection c = result.getChildren();
        return c.toArray();
    }

    @Override
    public void startListening() {
        this.viewer.getConfigurer().controlFieldProvider.addChangeListener(this);
    }

    @Override
    public void stopListening() {
        this.viewer.getConfigurer().controlFieldProvider.removeChangeListener(this);
    }

    public void dispose() {
        this.job.removeListener(this);
    }

    public void inputChanged(Viewer pViewer, Object oldInput, Object newInput) {
    }

    @Override
    public void jobFinished(BackgroundJob j) {
        this.viewer.notify(CommonViewer.Message.update);
    }

    @Override
    public void changed(HashMap<String, String> vals) {
        if (this.viewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            this.viewer.notify(CommonViewer.Message.empty);
        } else {
            this.viewer.notify(CommonViewer.Message.notempty);
        }
        this.job.invalidate();
        this.viewer.notify(CommonViewer.Message.update);
    }

    @Override
    public void reorder(String field) {
        this.job.invalidate();
    }

    @Override
    public void selected() {
    }

    @Override
    public void init() {
    }
}

