/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.GenericObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Tree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewSite;
import org.slf4j.LoggerFactory;

public class CommonViewer
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final boolean OS_IS_WIN = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    protected ViewerConfigurer viewerConfigurer;
    protected StructuredViewer viewer;
    protected Button bNew;
    private IAction createObjectAction;
    private Composite parent;
    private ISelectionChangedListener selChangeListener;
    private String namedSelection;
    private HashSet<PoDoubleClickListener> dlListeners;
    private MenuManager mgr;
    private Composite composite;
    private String viewName = "unknown";
    private boolean scrolledToBottom;
    private boolean showDisableLimit;
    private Button disableLimitBtn;
    private boolean changeContextSelection = true;

    public Composite getParent() {
        return this.parent;
    }

    public void setNamedSelection(String name) {
        this.namedSelection = name;
    }

    public void setViewName(String s) {
        this.viewName = s;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setObjectCreateAction(IViewSite site, IAction action) {
        site.getActionBars().getToolBarManager().add(action);
        action.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
        this.createObjectAction = action;
    }

    public void create(ViewerConfigurer viewerConfigurer, Composite parent, int style, Object input) {
        ViewerConfigurer.ControlFieldProvider cfp;
        this.viewerConfigurer = viewerConfigurer;
        this.parent = parent;
        Composite ret = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        ret.setLayout((Layout)layout);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(1808);
            ret.setLayoutData((Object)gd);
        }
        if ((cfp = viewerConfigurer.getControlFieldProvider()) != null) {
            ret.setData("TEST_COMP_NAME", (Object)("cv_ret_" + this.viewName));
            Composite ctlf = viewerConfigurer.getControlFieldProvider().createControl(ret);
            ctlf.setData("TEST_COMP_NAME", (Object)("cv_ctlf_" + this.viewName));
            ctlf.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        }
        this.viewer = viewerConfigurer.getWidgetProvider().createViewer(ret);
        GridData gdView = new GridData(1808);
        gdView.verticalAlignment = 4;
        this.viewer.setUseHashlookup(true);
        this.viewer.getControl().setLayoutData((Object)gdView);
        this.viewer.setContentProvider((IContentProvider)viewerConfigurer.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)viewerConfigurer.getLabelProvider());
        if (viewerConfigurer.getSelectionChangedListener() != null) {
            this.viewer.addSelectionChangedListener(viewerConfigurer.getSelectionChangedListener());
        } else {
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.viewer.getControl() instanceof Table) {
            final Table table = (Table)this.viewer.getControl();
            final ScrollBar verticalBar = table.getVerticalBar();
            verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CommonViewer.this.showDisableLimit && table.getItemCount() > 25) {
                        boolean bl = CommonViewer.this.scrolledToBottom = verticalBar.getSelection() + verticalBar.getThumb() == verticalBar.getMaximum();
                        if (CommonViewer.this.scrolledToBottom) {
                            CommonViewer.this.showDisableLimitButton();
                        } else {
                            CommonViewer.this.hideDisableLimitButton();
                        }
                    }
                }
            });
        }
        if (viewerConfigurer.getDoubleClickListener() != null) {
            this.viewer.addDoubleClickListener(viewerConfigurer.getDoubleClickListener());
        }
        this.bNew = viewerConfigurer.getButtonProvider().createButton(ret);
        if (this.bNew != null) {
            if (this.viewName != null) {
                this.bNew.setData("TEST_COMP_NAME", (Object)("cv_bNew_" + this.viewName + "_btn"));
            }
            GridData gdNew = new GridData(768);
            this.bNew.setLayoutData((Object)gdNew);
            if (!viewerConfigurer.getButtonProvider().isAlwaysEnabled()) {
                this.bNew.setEnabled(false);
            }
        }
        if (viewerConfigurer.getContentType() == ViewerConfigurer.ContentType.PERSISTENTOBJECT) {
            if (viewerConfigurer.poSelectionRenderer != null) {
                new PersistentObjectDragSource(this.viewer.getControl(), viewerConfigurer.poSelectionRenderer);
            } else {
                new PersistentObjectDragSource(this.viewer.getControl(), new PersistentObjectDragSource.ISelectionRenderer(){

                    @Override
                    public List<PersistentObject> getSelection() {
                        Object[] sel = CommonViewer.this.getSelection();
                        ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>(sel.length);
                        Object[] objectArray = sel;
                        int n = sel.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object b;
                            Object o = objectArray[n2];
                            if (o instanceof PersistentObject) {
                                ret.add((PersistentObject)o);
                            } else if (o instanceof Tree && (b = ((Tree)o).contents) instanceof PersistentObject) {
                                ret.add((PersistentObject)b);
                            }
                            ++n2;
                        }
                        return ret;
                    }
                });
            }
        } else if (viewerConfigurer.getContentType() == ViewerConfigurer.ContentType.GENERICOBJECT) {
            if (viewerConfigurer.goSelectionRenderer != null) {
                new GenericObjectDragSource(this.viewer, viewerConfigurer.goSelectionRenderer);
            } else {
                new GenericObjectDragSource(this.viewer);
            }
        }
        if (this.mgr != null) {
            this.viewer.getControl().setMenu(this.mgr.createContextMenu(this.viewer.getControl()));
        }
        viewerConfigurer.getContentProvider().init();
        this.viewer.setInput(input);
        this.viewer.getControl().pack();
        this.composite = ret;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Object[] getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (sel != null) {
            return sel.toArray();
        }
        return null;
    }

    public void setSelection(Object o, boolean fireEvents) {
        if (!fireEvents) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.viewer.setSelection((ISelection)new StructuredSelection(o), true);
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection(o), true);
        }
    }

    public StructuredViewer getViewerWidget() {
        return this.viewer;
    }

    public Object getViewerWidgetFirstSelection() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return null;
        }
        return selection.getFirstElement();
    }

    public ViewerConfigurer getConfigurer() {
        return this.viewerConfigurer;
    }

    public void notify(Message m) {
        this.notify(m, null);
    }

    public void notify(final Message m, final Object object) {
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                switch (m) {
                    case update: {
                        if (CommonViewer.this.viewer.getControl().isDisposed()) break;
                        CommonViewer.this.viewer.refresh(true);
                        break;
                    }
                    case updateSingle: {
                        if (CommonViewer.this.viewer.getControl().isDisposed() || object == null) break;
                        CommonViewer.this.viewer.refresh(object, true);
                        break;
                    }
                    case update_keeplabels: {
                        if (CommonViewer.this.viewer.getControl().isDisposed()) break;
                        CommonViewer.this.viewer.refresh(false);
                        break;
                    }
                    case empty: {
                        if (CommonViewer.this.bNew != null && !CommonViewer.this.viewerConfigurer.getButtonProvider().isAlwaysEnabled()) {
                            CommonViewer.this.bNew.setEnabled(false);
                        }
                        if (CommonViewer.this.createObjectAction == null) break;
                        CommonViewer.this.createObjectAction.setEnabled(false);
                        break;
                    }
                    case notempty: {
                        if (CommonViewer.this.bNew != null) {
                            CommonViewer.this.bNew.setEnabled(true);
                        }
                        if (CommonViewer.this.createObjectAction == null) break;
                        CommonViewer.this.createObjectAction.setEnabled(true);
                    }
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] sel = this.getSelection();
        if (sel != null && sel.length != 0) {
            if (sel[0] instanceof Tree) {
                sel[0] = ((Tree)sel[0]).contents;
            }
            if (this.changeContextSelection) {
                if (sel[0] instanceof PersistentObject) {
                    Optional modelClass = ElexisEventDispatcher.getCoreModelInterfaceForElexisClass(sel[0].getClass());
                    if (modelClass.isPresent()) {
                        NoPoUtil.loadAsIdentifiable((PersistentObject)((PersistentObject)sel[0]), (Class)((Class)modelClass.get())).ifPresent(indentifiable -> ContextServiceHolder.get().getRootContext().setTyped(indentifiable));
                    } else {
                        LoggerFactory.getLogger(this.getClass()).warn("PersistentObject selection [" + sel[0] + "] in context");
                        ContextServiceHolder.get().getRootContext().setTyped(sel[0]);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)this.namedSelection)) {
                    ContextServiceHolder.get().getRootContext().setNamed(this.namedSelection, sel[0]);
                } else if (sel[0] instanceof Identifiable) {
                    ContextServiceHolder.get().getRootContext().setTyped(sel[0]);
                }
            }
        }
        if (this.selChangeListener != null) {
            this.selChangeListener.selectionChanged(event);
        }
    }

    public void dispose() {
        if (this.viewerConfigurer.getDoubleClickListener() != null) {
            this.viewer.removeDoubleClickListener(this.viewerConfigurer.getDoubleClickListener());
        }
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void addDoubleClickListener(PoDoubleClickListener dl) {
        if (this.dlListeners == null) {
            this.dlListeners = new HashSet();
            this.getViewerWidget().addDoubleClickListener((IDoubleClickListener)this);
        }
        this.dlListeners.add(dl);
    }

    public void setSelectionChangedListener(@Nullable ISelectionChangedListener selChangeListener) {
        this.selChangeListener = selChangeListener;
    }

    public void removeDoubleClickListener(PoDoubleClickListener dl) {
        if (this.dlListeners == null) {
            return;
        }
        this.dlListeners.remove(dl);
        if (this.dlListeners.isEmpty()) {
            this.getViewerWidget().removeDoubleClickListener((IDoubleClickListener)this);
            this.dlListeners = null;
        }
    }

    public void setContextMenu(MenuManager mgr) {
        this.mgr = mgr;
        if (this.viewer != null) {
            this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
        }
    }

    public Button getButton() {
        return this.bNew;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.dlListeners != null) {
            for (PoDoubleClickListener dl : this.dlListeners) {
                if (this.viewerConfigurer.poSelectionRenderer != null) {
                    List<PersistentObject> selected = this.viewerConfigurer.poSelectionRenderer.getSelection();
                    if (selected.isEmpty()) continue;
                    dl.doubleClicked(selected.get(0), this);
                    continue;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel == null || sel.isEmpty()) continue;
                Object element = sel.getFirstElement();
                if (element instanceof Tree) {
                    element = ((Tree)element).contents;
                }
                if (!(element instanceof PersistentObject)) continue;
                dl.doubleClicked((PersistentObject)element, this);
            }
        }
    }

    public MenuManager getMgr() {
        return this.mgr;
    }

    public boolean isDisposed() {
        return this.viewer == null || this.viewer.getControl().isDisposed();
    }

    public void setLimitReached(boolean value, int limit) {
        this.showDisableLimit = value;
        Display.getDefault().asyncExec(() -> {
            if (this.disableLimitBtn == null) {
                this.addLimitButton(limit);
            }
            if (value && this.isNoScroll()) {
                this.showDisableLimitButton();
            } else {
                this.hideDisableLimitButton();
            }
        });
    }

    public void resetScrollbarPosition(TableViewer tv, boolean limit) {
        Table table = (Table)tv.getControl();
        ScrollBar scrollbar = table.getVerticalBar();
        int position = scrollbar.getSelection() + scrollbar.getThumb();
        if (!limit && position > scrollbar.getMinimum()) {
            table.setSelection(0);
        }
    }

    private boolean isNoScroll() {
        Table table;
        ScrollBar verticalBar;
        if (this.viewer.getControl() instanceof Table && !this.viewer.getControl().isDisposed() && (verticalBar = (table = (Table)this.viewer.getControl()).getVerticalBar()) != null) {
            return verticalBar.getSelection() + verticalBar.getThumb() == verticalBar.getMaximum();
        }
        return false;
    }

    private void addLimitButton(int limit) {
        if (this.disableLimitBtn == null) {
            this.disableLimitBtn = new Button(this.composite, 0x800000);
            this.disableLimitBtn.setText("Mehr als " + limit + " laden ...");
            this.disableLimitBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((CommonViewerContentProvider)CommonViewer.this.viewer.getContentProvider()).setIgnoreLimit(true);
                    CommonViewer.this.notify(Message.update);
                    CommonViewer.this.showDisableLimit = false;
                    CommonViewer.this.hideDisableLimitButton();
                }
            });
            this.disableLimitBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
    }

    private void showDisableLimitButton() {
        if (this.disableLimitBtn != null) {
            ((GridData)this.disableLimitBtn.getLayoutData()).exclude = false;
            this.disableLimitBtn.setVisible(true);
        }
        this.composite.layout();
        this.viewer.getControl().getParent().layout();
    }

    private void hideDisableLimitButton() {
        if (this.disableLimitBtn != null) {
            ((GridData)this.disableLimitBtn.getLayoutData()).exclude = true;
            this.disableLimitBtn.setVisible(false);
        }
        this.composite.layout();
        this.viewer.getControl().getParent().layout();
    }

    public void disableContextSelection() {
        this.changeContextSelection = false;
    }

    public static enum Message {
        update,
        empty,
        notempty,
        update_keeplabels,
        updateSingle;

    }

    public static interface PoDoubleClickListener {
        public void doubleClicked(PersistentObject var1, CommonViewer var2);
    }
}

