/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.Messages;
import ch.rgw.tools.StringTool;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class SWTHelper {
    private static FocusListener selectOnFocusListener = null;
    private static Log log = Log.get("Global: ");

    public static void center(Shell parent, Composite child) {
        if (parent != null && child != null) {
            Rectangle par = parent.getBounds();
            Rectangle ch = child.getBounds();
            if (par != null && ch != null) {
                int xOff = (par.width - ch.width) / 2;
                int yOff = (par.height - ch.height) / 2;
                child.setBounds(par.x + xOff, par.y + yOff, ch.width, ch.height);
            }
        }
    }

    public static void center(Shell parent, Shell child) {
        if (parent != null && child != null) {
            Rectangle par = parent.getBounds();
            Rectangle ch = child.getBounds();
            if (par != null && ch != null) {
                int xOff = (par.width - ch.width) / 2;
                int yOff = (par.height - ch.height) / 2;
                child.setBounds(par.x + xOff, par.y + yOff, ch.width, ch.height);
            }
        }
    }

    public static void center(Shell child) {
        Rectangle ch;
        Rectangle par;
        Display display;
        if (child != null && (display = UiDesk.getDisplay()) != null && (par = display.getBounds()) != null && (ch = child.getBounds()) != null) {
            ch.width = Math.max(30, ch.width);
            ch.height = Math.max(20, ch.height);
            int xOff = (par.width - ch.width) / 2;
            int yOff = (par.height - ch.height) / 2;
            child.setBounds(par.x + xOff, par.y + yOff, ch.width, ch.height);
        }
    }

    public static void writeCentered(GC gc, String text, Rectangle bounds) {
        int w = gc.getFontMetrics().getAverageCharWidth();
        int h = gc.getFontMetrics().getHeight();
        int woff = bounds.width - text.length() * w >> 1;
        int hoff = bounds.height - h >> 1;
        gc.drawString(text, bounds.x + woff, bounds.y + hoff);
    }

    public static void alert(final String title, final String message) {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = UiDesk.getDisplay().getActiveShell();
                if (shell == null) {
                    shell = new Shell(UiDesk.getDisplay());
                }
                MessageBox msg2 = new MessageBox(shell, 33);
                msg2.setText(title);
                msg2.setMessage(message);
                msg2.open();
            }
        });
    }

    public static void showError(final String title, final String message) {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = UiDesk.getTopShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static void showError(String logHeader, final String title, final String message) {
        log.log(String.valueOf(logHeader) + ": " + title + "->" + message, 2);
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = UiDesk.getDisplay().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static void showInfo(final String title, final String message) {
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = UiDesk.getTopShell();
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static boolean askYesNo(String title, String message) {
        InSync rn = new InSync(title, message);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static int ask(String title, String message, String ... dialogButtonLabels) {
        InSyncMulti rn = new InSyncMulti(title, message, dialogButtonLabels);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static Boolean askYesNoCancel(String title, String message) {
        InSyncYesNoCancel rn = new InSyncYesNoCancel(title, message);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static GridData getFillGridData() {
        return SWTHelper.getFillGridData(1, true, 1, true);
    }

    public static GridData getFillGridData(int hSpan, boolean hFill, int vSpan, boolean vFill) {
        int ld = 0;
        if (hFill) {
            ld = 768;
        }
        if (vFill) {
            ld |= 0x410;
        }
        GridData ret = new GridData(ld);
        ret.horizontalSpan = hSpan < 1 ? 1 : hSpan;
        ret.verticalSpan = vSpan < 1 ? 1 : vSpan;
        return ret;
    }

    public static GridData fillGrid(Composite parent, int cols) {
        parent.setLayout((Layout)new GridLayout(cols, false));
        return SWTHelper.getFillGridData(1, true, 1, true);
    }

    public static GridData setGridDataHeight(Control control, int lines, boolean fillHorizontal) {
        int h = Math.round(control.getFont().getFontData()[0].height);
        GridData gd = SWTHelper.getFillGridData(1, fillHorizontal, 1, false);
        gd.heightHint = lines * (h + 2);
        control.setLayoutData((Object)gd);
        return gd;
    }

    public static TableWrapLayout createTableWrapLayout(int numColumns, boolean makeColumnsEqualWidth) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        return layout;
    }

    public static TableWrapData getFillTableWrapData(int hSpan, boolean hFill, int vSpan, boolean vFill) {
        TableWrapData layoutData = new TableWrapData(2, 16);
        if (hFill) {
            layoutData.grabHorizontal = true;
            layoutData.align = 128;
        }
        if (vFill) {
            layoutData.grabVertical = true;
            layoutData.valign = 128;
        }
        layoutData.colspan = hSpan < 1 ? 1 : hSpan;
        layoutData.rowspan = vSpan < 1 ? 1 : vSpan;
        return layoutData;
    }

    public static Color getContrast(Color col) {
        double val = (double)col.getRed() * 0.56 + (double)col.getGreen() * 0.33 + (double)col.getBlue() * 0.11;
        if (val <= 110.0) {
            return UiDesk.getDisplay().getSystemColor(1);
        }
        return UiDesk.getDisplay().getSystemColor(2);
    }

    public static Label createHyperlink(Composite parent, final String text, final IHyperlinkListener lis) {
        final Label ret = new Label(parent, 0);
        ret.setText(text);
        ret.setForeground(UiDesk.getColorRegistry().get(Messages.Core_Blue));
        ret.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (lis != null) {
                    lis.linkActivated(new HyperlinkEvent((Widget)ret, (Object)ret, text, e.stateMask));
                }
            }
        });
        return ret;
    }

    public static Text createText(Composite parent, int lines, int flags) {
        int lNum = 4;
        if (lines > 1) {
            lNum = 66;
        }
        Text ret = new Text(parent, 0x800 | flags | lNum);
        GridData gd = SWTHelper.getFillGridData(1, true, 1, false);
        int h = Math.round(ret.getFont().getFontData()[0].height);
        gd.heightHint = gd.minimumHeight = (lines + 1) * (h + 2);
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static Text createText(FormToolkit tk, Composite parent, int lines, int flags) {
        int lNum = 4;
        if (lines > 1) {
            lNum = 66;
        }
        Text ret = tk.createText(parent, "", lNum | flags | 0x800);
        GridData gd = SWTHelper.getFillGridData(1, true, 1, true);
        int h = Math.round(ret.getFont().getFontData()[0].height);
        gd.heightHint = gd.minimumHeight = (lines + 1) * (h + 2);
        ret.setLayoutData((Object)gd);
        return ret;
    }

    public static LabeledInputField createLabeledField(Composite parent, String label, LabeledInputField.Typ typ) {
        LabeledInputField ret = new LabeledInputField(parent, label, typ);
        ret.setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
        return ret;
    }

    public static boolean blameEmptyString(String test, String name) {
        if (StringTool.isNothing((Object)test)) {
            SWTHelper.showError(Messages.SWTHelper_BadParameter, String.valueOf(name) + Messages.SWTHelper_HasNoValidContents);
            return false;
        }
        return true;
    }

    public static void setSelectOnFocus(Text text) {
        if (selectOnFocusListener == null) {
            selectOnFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    Text t = (Text)e.widget;
                    t.selectAll();
                }

                public void focusLost(FocusEvent e) {
                    Text t = (Text)e.widget;
                    if (t.getSelectionCount() > 0) {
                        t.clearSelection();
                    }
                }
            };
        }
        text.addFocusListener(selectOnFocusListener);
    }

    public static java.awt.Font createAWTFontFromSWTFont(Font swtFont) {
        String name = swtFont.getFontData()[0].getName();
        int style = swtFont.getFontData()[0].getStyle();
        int height = swtFont.getFontData()[0].getHeight();
        java.awt.Font awtFont = new java.awt.Font(name, style, height);
        return awtFont;
    }

    public static int size(Rectangle r) {
        if (r == null) {
            return 0;
        }
        return (r.width - r.x) * (r.height - r.y);
    }

    public static Point getStringBounds(Composite c, String s) {
        GC gc = new GC((Drawable)c);
        Point ret = gc.textExtent(s);
        gc.dispose();
        return ret;
    }

    public static void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        Layout parentlayout = parent.getLayout();
        if (parentlayout instanceof GridLayout) {
            int columns = ((GridLayout)parentlayout).numColumns;
            GridData gridData = new GridData(4, 0, true, false, columns, 1);
            separator.setLayoutData((Object)gridData);
        }
    }

    public static void reloadViewPart(String viewID) {
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IViewPart page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewID);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(page);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID);
            }
            catch (PartInitException e) {
                Status status = new Status(4, "ch.elexis.core.ui", "Error reopening viewPart " + viewID, (Throwable)e);
                StatusManager.getManager().handle((IStatus)status, 2);
            }
        }
    }

    public static GridLayout createGridLayout(boolean noGaps, int numColumns) {
        GridLayout gd = new GridLayout(numColumns, false);
        if (noGaps) {
            gd.horizontalSpacing = 0;
            gd.verticalSpacing = 0;
            gd.marginHeight = 0;
            gd.marginWidth = 0;
        }
        return gd;
    }

    public static Label createDemoInfoLabel(Composite parent, String text) {
        Label demoInfo = new Label(parent, 64);
        demoInfo.setText(text);
        demoInfo.setFont(SWTResourceManager.getFont("Lucida Grande", 10, 1));
        demoInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        return demoInfo;
    }

    public static interface IControlProvider {
        public Control getControl(Composite var1);

        public void beforeClosing();
    }

    private static class InSync
    implements Runnable {
        boolean ret;
        String title;
        String message;

        InSync(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            Shell shell = UiDesk.getTopShell();
            this.ret = MessageDialog.openConfirm((Shell)shell, (String)this.title, (String)this.message);
        }
    }

    private static class InSyncMulti
    implements Runnable {
        private int ret;
        private String title;
        private String message;
        private String[] dialogButtonLabels;

        InSyncMulti(String title, String message, String ... dialogButtonLabels) {
            this.title = title;
            this.message = message;
            this.dialogButtonLabels = dialogButtonLabels;
        }

        @Override
        public void run() {
            Shell shell = UiDesk.getTopShell();
            this.ret = MessageDialog.open((int)3, (Shell)shell, (String)this.title, (String)this.message, (int)0x10000000, (String[])this.dialogButtonLabels);
        }
    }

    private static class InSyncYesNoCancel
    implements Runnable {
        Boolean ret = null;
        String title;
        String message;

        InSyncYesNoCancel(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            Shell shell = UiDesk.getTopShell();
            MessageDialog dialog = new MessageDialog(shell, this.title, null, this.message, 3, new String[]{Messages.SWTHelper_yes, Messages.SWTHelper_no, Messages.SWTHelper_cancel}, 0);
            int result = dialog.open();
            if (result != 2) {
                this.ret = result == 0;
            }
        }
    }

    public static class SimpleDialog
    extends Dialog {
        IControlProvider dialogAreaProvider;

        public SimpleDialog(IControlProvider control) {
            super(UiDesk.getTopShell());
            this.dialogAreaProvider = control;
        }

        protected Control createDialogArea(Composite parent) {
            return this.dialogAreaProvider.getControl(parent);
        }

        protected void okPressed() {
            this.dialogAreaProvider.beforeClosing();
            super.okPressed();
        }
    }
}

