/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.text.model.SSDRange;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.UserTextPref;
import ch.elexis.core.ui.text.ETFDropReceiver;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.text.Messages;
import ch.elexis.core.ui.text.ShortcutListener;
import ch.elexis.core.ui.text.TransparentTextModificationLockHandler;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.core.ui.util.IKonsMakro;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.GenericRange;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class EnhancedTextField
extends Composite
implements IRichTextDisplay {
    public static final String MACRO_ENABLED = "enhancedtextfield/macro_enabled";
    public static final String MACRO_KEY = "enhancedtextfield/macro_key";
    public static final String MACRO_KEY_DEFAULT = "$";
    StyledText text;
    Map<String, IKonsExtension> hXrefs;
    ETFDropReceiver dropper;
    private List<Samdas.XRef> links;
    private List<Samdas.Markup> markups;
    private List<Samdas.Range> ranges;
    Samdas samdas;
    Samdas.Record record;
    boolean dirty;
    MenuManager menuMgr;
    private IEncounter actEncounter;
    private static Pattern outline = Pattern.compile("^\\S+:", 8);
    private static Pattern bold = Pattern.compile("\\*\\S+\\*");
    private static Pattern italic = Pattern.compile("\\/\\S+\\/");
    private static Pattern underline = Pattern.compile("_\\S+_");
    private IAction copyAction;
    private IAction cutAction;
    private IAction pasteAction;
    private IMenuListener globalMenuListener;
    private List<IKonsMakro> externalMakros;
    private int lastCurserPosition = 0;
    private RangeTracker rangeTracker;
    private boolean unlocked = false;

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().syncExec(() -> {
            if (this.text != null && !this.text.isDisposed()) {
                this.text.setFont(UiDesk.getFont("anwender/stdfont"));
            }
        });
    }

    public void setExternalMakros(List<IKonsMakro> makros) {
        this.externalMakros = makros;
    }

    @Override
    public void setXrefHandlers(Map<String, IKonsExtension> xrefs) {
        this.hXrefs = xrefs;
    }

    @Override
    public void addXrefHandler(String id, IKonsExtension xref) {
        if (this.hXrefs == null) {
            this.hXrefs = new Hashtable<String, IKonsExtension>();
        }
        this.hXrefs.put(id, xref);
    }

    public void setKons(IEncounter encounter) {
        if (this.actEncounter != null && this.actEncounter.equals(encounter)) {
            while (this.lastCurserPosition > 0 && this.isLineDelimiter(this.lastCurserPosition)) {
                --this.lastCurserPosition;
            }
            this.text.setCaretOffset(this.lastCurserPosition);
        }
        this.actEncounter = encounter;
    }

    private boolean isLineDelimiter(int offset) {
        if (this.text.getContent() != null && offset <= this.text.getContent().getCharCount() && offset > 0) {
            int line = this.text.getContent().getLineAtOffset(offset);
            int lineOffset = this.text.getContent().getOffsetAtLine(line);
            int offsetInLine = offset - lineOffset;
            return offsetInLine > this.text.getContent().getLine(line).length();
        }
        return false;
    }

    public void connectGlobalActions(IViewSite site) {
        this.makeActions();
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteAction);
        this.globalMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (EnhancedTextField.this.text.getSelectionCount() == 0) {
                    EnhancedTextField.this.copyAction.setEnabled(false);
                    EnhancedTextField.this.cutAction.setEnabled(false);
                } else {
                    EnhancedTextField.this.copyAction.setEnabled(true);
                    EnhancedTextField.this.cutAction.setEnabled(true);
                }
            }
        };
    }

    public void disconnectGlobalActions(IViewSite site) {
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
    }

    public void addDropReceiver(Class clazz, IKonsExtension ext) {
        this.dropper.addReceiver(clazz, ext);
    }

    public void removeDropReceiver(Class clazz, IKonsExtension ext) {
        this.dropper.removeReceiver(clazz, ext);
    }

    public EnhancedTextField(Composite parent) {
        this(parent, 2624);
    }

    public EnhancedTextField(final Composite parent, int style) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.text = new StyledText((Composite)this, style);
        this.text.setFont(UiDesk.getFont("anwender/stdfont"));
        this.text.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.text.addVerifyListener((VerifyListener)new ETFVerifyListener());
        this.text.addVerifyKeyListener((VerifyKeyListener)new ShortcutListener(this));
        TransparentTextModificationLockHandler atmlh = new TransparentTextModificationLockHandler(this);
        this.text.addVerifyKeyListener((VerifyKeyListener)atmlh);
        this.setBackground(UiDesk.getColor("blau"));
        this.dropper = new ETFDropReceiver(this);
        this.menuMgr = new MenuManager();
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)GlobalActions.cutAction);
                manager.add((IAction)GlobalActions.copyAction);
                manager.add((IAction)GlobalActions.pasteAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new Action(Messages.EnhancedTextField_asMacro){
                    String tx;
                    {
                        super($anonymous0);
                        this.tx = (this).EnhancedTextField.this.text.getSelectionText();
                        if (StringTool.isNothing((Object)this.tx)) {
                            this.setEnabled(false);
                        } else {
                            this.setEnabled(true);
                        }
                    }

                    public void run() {
                        InputDialog in = new InputDialog(parent.getShell(), Messages.EnhancedTextField_newMacro, Messages.EnhancedTextField_enterNameforMacro, null, null);
                        if (in.open() == 0) {
                            StringBuilder name = new StringBuilder(in.getValue());
                            name.reverse();
                            ConfigServiceHolder.setUser((String)("makros/" + name), (String)this.tx);
                        }
                    }
                });
                if (EnhancedTextField.this.hXrefs != null) {
                    boolean bAdditions = false;
                    for (IKonsExtension k : EnhancedTextField.this.hXrefs.values()) {
                        IAction[] acs = k.getActions();
                        if (acs == null) continue;
                        IAction[] iActionArray = acs;
                        int n = acs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAction ac = iActionArray[n2];
                            manager.add(ac);
                            bAdditions = true;
                            ++n2;
                        }
                    }
                    if (bAdditions) {
                        manager.add((IAction)new Action(Messages.EnhancedTextField_RemoveXref){
                            Samdas.XRef actRef;
                            {
                                this.actRef = null;
                                this.setEnabled(false);
                                int cp = (this).EnhancedTextField.this.text.getCaretOffset();
                                this.actRef = EnhancedTextField.this.findLinkRef(cp);
                                if (this.actRef != null) {
                                    this.setEnabled(true);
                                }
                            }

                            public void run() {
                                IKonsExtension ex = (this).EnhancedTextField.this.hXrefs.get(this.actRef.getProvider());
                                if (ex != null) {
                                    int length = this.actRef.getLength();
                                    String remText = (this).EnhancedTextField.this.text.getTextRange(this.actRef.getPos(), length);
                                    while (remText.endsWith("\r")) {
                                        remText = (this).EnhancedTextField.this.text.getTextRange(this.actRef.getPos(), length);
                                    }
                                    (this).EnhancedTextField.this.text.replaceTextRange(this.actRef.getPos(), length, "");
                                    ex.removeXRef(this.actRef.getProvider(), this.actRef.getID());
                                }
                                (this).EnhancedTextField.this.links.remove(this.actRef);
                                (this).EnhancedTextField.this.record.remove((Samdas.Range)this.actRef);
                                EnhancedTextField.this.doFormat(EnhancedTextField.this.getContentsAsXML());
                            }
                        });
                        manager.add((IAction)new Action("Referenz aktualisieren"){
                            Samdas.XRef actRef;
                            {
                                this.actRef = null;
                                this.setEnabled(false);
                                int cp = (this).EnhancedTextField.this.text.getCaretOffset();
                                this.actRef = EnhancedTextField.this.findLinkRef(cp);
                                if (this.actRef != null) {
                                    this.setEnabled(true);
                                }
                            }

                            public ImageDescriptor getImageDescriptor() {
                                return Images.IMG_REFRESH.getImageDescriptor();
                            }

                            public void run() {
                                if (this.actRef != null) {
                                    EnhancedTextField.this.updateXRef(this.actRef);
                                }
                            }
                        });
                    }
                }
            }
        });
        Menu menu = this.menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
        this.text.setWordWrap(true);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    super.mouseDoubleClick(e);
                } else if (EnhancedTextField.this.links != null) {
                    try {
                        int ch = EnhancedTextField.this.text.getOffsetAtLocation(new Point(e.x, e.y));
                        Samdas.XRef lr = EnhancedTextField.this.findLinkRef(ch);
                        if (lr != null) {
                            IKonsExtension xr = EnhancedTextField.this.hXrefs.get(lr.getProvider());
                            xr.doXRef(lr.getProvider(), lr.getID());
                            EnhancedTextField.this.updateXRef(lr);
                            EnhancedTextField.this.text.notifyListeners(4, new Event());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        });
        this.rangeTracker = new RangeTracker();
        this.text.addExtendedModifyListener((ExtendedModifyListener)this.rangeTracker);
        new GenericObjectDropTarget((Control)this.text, this.dropper);
        CoreUiUtil.injectServicesWithContext((Object)this);
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean d) {
        this.dirty = d;
    }

    void doFormat(String tx) {
        StyleRange n;
        this.text.setStyleRange(null);
        if (tx.startsWith("<")) {
            this.doFormatXML(tx);
            tx = this.text.getText();
        } else {
            this.samdas = new Samdas(tx);
            this.record = this.samdas.getRecord();
            this.text.setText(tx);
        }
        Matcher matcher = outline.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.fontStyle = 1;
            this.text.setStyleRange(n);
        }
        matcher = bold.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.fontStyle = 1;
            this.text.setStyleRange(n);
        }
        matcher = italic.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.fontStyle = 2;
            this.text.setStyleRange(n);
        }
        matcher = underline.matcher(tx);
        while (matcher.find()) {
            n = new StyleRange();
            n.start = matcher.start();
            n.length = matcher.end() - n.start;
            n.underline = true;
            this.text.setStyleRange(n);
        }
    }

    void doFormatXML(String tx) {
        StyleRange n;
        this.samdas = new Samdas(tx);
        this.record = this.samdas.getRecord();
        List xrefs = this.record.getXrefs();
        this.text.setText(this.record.getText());
        int textlen = this.text.getCharCount();
        this.markups = this.record.getMarkups();
        this.links = new ArrayList<Samdas.XRef>(xrefs.size());
        this.ranges = new ArrayList<Samdas.Range>(xrefs.size() + this.markups.size());
        for (Samdas.Markup m : this.markups) {
            String type = m.getType();
            n = new StyleRange();
            n.start = m.getPos();
            n.length = m.getLength();
            if (type.equalsIgnoreCase("emphasized")) {
                n.strikeout = true;
            } else if (type.equalsIgnoreCase("bold")) {
                n.fontStyle = 1;
            } else if (type.equalsIgnoreCase("italic")) {
                n.fontStyle = 2;
            } else if (type.equalsIgnoreCase("underlined")) {
                n.underline = true;
            }
            if (n.start + n.length > textlen) {
                n.length = textlen - n.start;
            }
            if (n.length > 0 && n.start >= 0) {
                this.text.setStyleRange(n);
                this.ranges.add((Samdas.Range)m);
                continue;
            }
            this.record.remove((Samdas.Range)m);
        }
        if (this.hXrefs != null) {
            for (Samdas.XRef xref : xrefs) {
                IKonsExtension xProvider = this.hXrefs.get(xref.getProvider());
                if (xProvider == null) continue;
                n = new StyleRange();
                n.start = xref.getPos();
                n.length = xref.getLength();
                if (xProvider.doLayout(n, xref.getProvider(), xref.getID())) {
                    this.links.add(xref);
                }
                if (n.start + n.length > this.text.getCharCount()) {
                    n.length = this.text.getCharCount() - n.start;
                }
                if (n.length > 0 && n.start >= 0) {
                    this.text.setStyleRange(n);
                    this.ranges.add((Samdas.Range)xref);
                    continue;
                }
                xref.setPos(0);
            }
        }
    }

    @Override
    public void insertXRef(int pos, String string, String provider, String id) {
        if (pos == -1) {
            pos = this.text.getCaretOffset();
        } else {
            this.text.setCaretOffset(pos);
        }
        int len = string.trim().length();
        this.text.insert(string);
        this.record.setText(this.text.getText());
        Samdas.XRef xref = new Samdas.XRef(provider, id, pos, len);
        this.record.add((Samdas.Range)xref);
        this.setDirty(true);
        this.doFormat(this.getContentsAsXML());
    }

    public void updateXRef(Samdas.XRef xref) {
        IKonsExtension xr = this.hXrefs.get(xref.getProvider());
        String updatedText = xr.updateXRef(xref.getProvider(), xref.getID());
        if (updatedText != null) {
            this.rangeTracker.setUpdateXRefMode(true);
            int start = xref.getPos() >= this.text.getContent().getCharCount() ? this.text.getContent().getCharCount() : xref.getPos();
            int end = xref.getPos() + xref.getLength() >= this.text.getContent().getCharCount() ? this.text.getContent().getCharCount() : xref.getPos() + xref.getLength();
            System.out.println(String.valueOf(start) + "-" + end);
            this.text.setSelection(start, end);
            this.text.insert(updatedText);
            xref.setLength(updatedText.length());
            this.record.setText(this.text.getText());
            this.setDirty(true);
            this.doFormat(this.getContentsAsXML());
            this.rangeTracker.setUpdateXRefMode(false);
        }
    }

    public void createMarkup(char type, int pos, int len) {
        String typ = "bold";
        switch (type) {
            case '/': {
                typ = "italic";
                break;
            }
            case '_': {
                typ = "underline";
            }
        }
        Samdas.Markup markup = new Samdas.Markup(pos, len, typ);
        this.record.add((Samdas.Range)markup);
        this.doFormat(this.getContentsAsXML());
    }

    public void replace(int start, int len, String nt) {
        this.text.replaceTextRange(start, len, nt);
    }

    public void setText(String ntext) {
        this.lastCurserPosition = this.text.getCaretOffset();
        this.doFormat(ntext);
        this.setDirty(false);
    }

    public void putCaretToEnd() {
        this.text.setCaretOffset(this.text.getCharCount());
        this.text.setFocus();
    }

    public void undo() {
        XMLOutputter xo = new XMLOutputter(Format.getRawFormat());
        String oldText = xo.outputString(this.samdas.getDocument());
        this.setText(oldText);
    }

    public Samdas getContents() {
        return this.samdas;
    }

    public Document getDocument() {
        this.record.setText(this.text.getText());
        return this.samdas.getDocument();
    }

    @Override
    public String getContentsAsXML() {
        XMLOutputter xo = new XMLOutputter(Format.getRawFormat());
        return xo.outputString(this.getDocument());
    }

    public String getSelectedText() {
        return this.text.getSelectionText();
    }

    @Override
    public String getWordUnderCursor() {
        return StringTool.getWordAtIndex((String)this.text.getText(), (int)this.text.getCaretOffset());
    }

    public Samdas.XRef findLinkRef(int cp) {
        Samdas.XRef ret = null;
        if (this.links != null) {
            for (Samdas.XRef lr : this.links) {
                if (lr.getPos() > cp || lr.getPos() + lr.getLength() < cp) continue;
                ret = lr;
                break;
            }
        }
        return ret;
    }

    public Control getControl() {
        return this.text;
    }

    private void makeActions() {
        this.cutAction = new Action(Messages.EnhancedTextField_cutAction){

            public void run() {
                EnhancedTextField.this.text.cut();
            }
        };
        this.pasteAction = new Action(Messages.EnhancedTextField_pasteAction){

            public void run() {
                EnhancedTextField.this.text.paste();
            }
        };
        this.copyAction = new Action(Messages.EnhancedTextField_copyAction){

            public void run() {
                EnhancedTextField.this.text.copy();
            }
        };
    }

    @Override
    public String getContentsPlaintext() {
        return this.text.getText();
    }

    @Override
    public GenericRange getSelectedRange() {
        Point pt = this.text.getSelection();
        GenericRange gr = new GenericRange(pt.x);
        gr.setEnd(pt.y);
        return gr;
    }

    @Override
    public void insertRange(SSDRange range) {
    }

    public void setEditable(boolean unlocked) {
        IContributionItem[] items;
        this.unlocked = unlocked;
        this.text.setEditable(unlocked);
        IContributionItem[] iContributionItemArray = items = this.menuMgr.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)iContributionItem).getAction();
                if (action instanceof RestrictedAction) {
                    ((RestrictedAction)action).reflectRight();
                } else {
                    action.setEnabled(unlocked);
                }
            }
            ++n2;
        }
        if (unlocked) {
            this.text.setForeground(UiDesk.getColor("schwarz"));
        } else {
            this.text.setForeground(UiDesk.getColor("dunkelgrau"));
        }
    }

    public void setTextBackground(Color color) {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setBackground(color);
        }
    }

    protected boolean isUnlocked() {
        return this.unlocked;
    }

    protected IEncounter getEncounter() {
        return this.actEncounter;
    }

    class ETFVerifyListener
    implements VerifyListener {
        ETFVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            block11: {
                block9: {
                    int start;
                    StringBuilder s;
                    block10: {
                        String code;
                        String comp;
                        EnhancedTextField.this.dirty = true;
                        String macroKey = ConfigServiceHolder.getUser((String)EnhancedTextField.MACRO_KEY, (String)EnhancedTextField.MACRO_KEY_DEFAULT);
                        if (!e.text.equals(macroKey)) break block9;
                        s = new StringBuilder();
                        start = e.start;
                        while (--start >= 0) {
                            String t = EnhancedTextField.this.text.getTextRange(start, 1);
                            if (!t.matches("\\S")) break;
                            s.append(t);
                        }
                        if ((comp = ConfigServiceHolder.getUser((String)("makros/" + (code = s.toString())), null)) == null) break block10;
                        EnhancedTextField.this.text.replaceTextRange(++start, e.end - start, comp);
                        e.doit = false;
                        EnhancedTextField.this.doFormat(EnhancedTextField.this.getContentsAsXML());
                        EnhancedTextField.this.text.setCaretOffset(start + comp.length());
                        break block11;
                    }
                    ++start;
                    String makro = s.reverse().toString();
                    boolean makroFound = false;
                    StringBuilder replace = new StringBuilder();
                    if (EnhancedTextField.this.externalMakros != null) {
                        for (IKonsMakro extMakro : EnhancedTextField.this.externalMakros) {
                            String makroValue;
                            if (!this.isMakroEnabled(extMakro) || (makroValue = extMakro.executeMakro(makro)) == null) continue;
                            replace.append(makroValue);
                            makroFound = true;
                        }
                    }
                    if (!makroFound) break block11;
                    EnhancedTextField.this.text.replaceTextRange(start, e.end - start, replace.toString());
                    e.doit = false;
                    EnhancedTextField.this.doFormat(EnhancedTextField.this.getContentsAsXML());
                    EnhancedTextField.this.text.setCaretOffset(start + replace.toString().length());
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)EnhancedTextField.this.actEncounter);
                    break block11;
                }
                if (e.text.equals(":")) {
                    int lineStart = EnhancedTextField.this.text.getOffsetAtLine(EnhancedTextField.this.text.getLineAtOffset(e.start));
                    String line = EnhancedTextField.this.text.getText(lineStart, e.start - 1);
                    if (line.matches("^\\S+")) {
                        int caretOffset = EnhancedTextField.this.text.getCaretOffset();
                        EnhancedTextField.this.createMarkup('*', lineStart, line.length());
                        EnhancedTextField.this.text.setCaretOffset(caretOffset);
                    }
                } else if (e.text.matches("[\\*/_]")) {
                    int start = e.start;
                    String t = "";
                    while (--start >= 0) {
                        t = EnhancedTextField.this.text.getTextRange(start, 1);
                        if (t.equals(e.text)) {
                            int caretOffset = EnhancedTextField.this.text.getCaretOffset();
                            EnhancedTextField.this.createMarkup(t.charAt(0), start, e.start - start);
                            e.doit = true;
                            EnhancedTextField.this.text.setCaretOffset(caretOffset);
                            break;
                        }
                        if (t.matches(Messages.EnhancedTextField_5)) break;
                    }
                }
            }
        }

        private boolean isMakroEnabled(IKonsMakro extMakro) {
            UserTextPref.setMakroEnabledDefaults();
            return ConfigServiceHolder.getUser((String)("enhancedtextfield/macro_enabled/" + extMakro.getClass().getName()), (boolean)false);
        }
    }

    class RangeTracker
    implements ExtendedModifyListener {
        private boolean updateXRefMode;

        RangeTracker() {
        }

        public void modifyText(ExtendedModifyEvent event) {
            if (EnhancedTextField.this.ranges != null) {
                int pos = event.start;
                int len = event.length;
                String text = event.replacedText;
                int diff = len - text.length();
                for (Samdas.Range r : EnhancedTextField.this.ranges) {
                    int spos = r.getPos();
                    if (this.updateXRefMode) {
                        if (spos <= pos) continue;
                        r.setPos(spos + diff);
                        continue;
                    }
                    if (spos < pos) continue;
                    r.setPos(spos + diff);
                }
            }
        }

        public void setUpdateXRefMode(boolean mode) {
            this.updateXRefMode = mode;
        }
    }
}

