/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.processor;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.Messages;
import ch.elexis.core.ui.dialogs.PrescriptionSignatureTitleAreaDialog;
import ch.elexis.core.ui.dialogs.ResultDialog;
import ch.rgw.tools.Result;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.PlatformUI;

public class BillingProcessor {
    private final IEncounter actEncounter;

    public BillingProcessor(IEncounter actEncounter) {
        this.actEncounter = actEncounter;
    }

    public void processArticle(IArticle selectedArticle) {
        if (this.isArticleAlreadyBilled(selectedArticle)) {
            this.billArticleDirectly(selectedArticle);
            return;
        }
        List<IPrescription> prescriptions = BillingProcessor.getRecentPatientPrescriptions(this.actEncounter.getPatient(), this.actEncounter.getDate().atStartOfDay());
        boolean medicationExistsType = this.fixOrReserveWithArticleExists(prescriptions, selectedArticle);
        boolean showDialog = ConfigServiceHolder.getUser((String)"medication/settings/showDialogOnBilling", (boolean)false);
        if (showDialog && !medicationExistsType) {
            this.handleArticleBillingDialog(selectedArticle);
        } else {
            this.billArticleDirectly(selectedArticle);
        }
    }

    private boolean isArticleAlreadyBilled(IArticle selectedArticle) {
        return this.actEncounter.getBilled().stream().anyMatch(billed -> billed.getBillable() instanceof IArticle && ((IArticle)billed.getBillable()).getId().equals(selectedArticle.getId()));
    }

    private void billArticleDirectly(IArticle selectedArticle) {
        Result billResult = BillingServiceHolder.get().bill((IBillable)selectedArticle, this.actEncounter, 1.0);
        if (billResult.isOK()) {
            IBilled billed = (IBilled)billResult.get();
            CoreModelServiceHolder.get().refresh((Identifiable)this.actEncounter, true);
            this.postRefreshMedicationEvent();
            this.updatePrescriptionsWithDosage(billed);
        } else {
            ResultDialog.show(billResult);
        }
    }

    private void handleArticleBillingDialog(IArticle selectedArticle) {
        Optional prescriptionOpt;
        PrescriptionSignatureTitleAreaDialog dialog = new PrescriptionSignatureTitleAreaDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), selectedArticle);
        dialog.lookup();
        dialog.setFromBillingDialog(true);
        if (dialog.open() != 0) {
            return;
        }
        IArticleDefaultSignature signature = dialog.getSignature();
        List<IPrescription> prescriptions = BillingProcessor.getRecentPatientPrescriptions(this.actEncounter.getPatient(), this.actEncounter.getDate().atStartOfDay());
        boolean medicationExists = this.checkIfMedicationExists(prescriptions, selectedArticle, signature);
        if (medicationExists) {
            return;
        }
        Result billResult = BillingServiceHolder.get().bill((IBillable)selectedArticle, this.actEncounter, 1.0);
        if (!billResult.isOK()) {
            ResultDialog.show(billResult);
            return;
        }
        IBilled billed = (IBilled)billResult.get();
        String prescId = billed.getExtInfo((Object)"prescriptionId").toString();
        if (prescId != null && (prescriptionOpt = CoreModelServiceHolder.get().load(prescId, IPrescription.class)).isPresent()) {
            IPrescription prescription = (IPrescription)prescriptionOpt.get();
            prescription.setDosageInstruction(signature.getSignatureAsDosisString());
            prescription.setRemark(signature.getComment());
            prescription.setExtInfo((Object)"verrechnetId", (Object)billed.getId());
            prescription.setEntryType(signature.getDisposalType());
            prescription.setDateFrom(this.actEncounter.getDate().atStartOfDay());
            CoreModelServiceHolder.get().save((Identifiable)prescription);
        }
        CoreModelServiceHolder.get().save((Identifiable)this.actEncounter);
        this.postRefreshMedicationEvent();
    }

    private boolean checkIfMedicationExists(List<IPrescription> prescriptions, IArticle selectedArticle, IArticleDefaultSignature signature) {
        String signatureDosage = signature.getSignatureAsDosisString();
        EntryType signatureEntryType = signature.getMedicationType();
        return prescriptions.stream().anyMatch(prescription -> {
            boolean sameArticle = prescription.getArticle().getId().equals(selectedArticle.getId());
            boolean sameDosage = Objects.equals(prescription.getDosageInstruction(), signatureDosage);
            boolean sameEntryType = prescription.getEntryType().equals((Object)signatureEntryType);
            return sameArticle && sameDosage && sameEntryType;
        });
    }

    private boolean fixOrReserveWithArticleExists(List<IPrescription> prescriptions, IArticle selectedArticle) {
        return prescriptions.stream().anyMatch(prescription -> prescription.getArticle().getId().equals(selectedArticle.getId()) && (prescription.getEntryType() == EntryType.FIXED_MEDICATION || prescription.getEntryType() == EntryType.RESERVE_MEDICATION));
    }

    public void updatePrescriptionsWithDosage(IBilled billed) {
        List<IPrescription> prescriptions = BillingProcessor.getRecentPatientPrescriptions(this.actEncounter.getPatient(), this.actEncounter.getDate().atStartOfDay());
        ArrayList<IPrescription> reversedPrescriptions = new ArrayList<IPrescription>(prescriptions);
        Collections.reverse(reversedPrescriptions);
        Optional<IPrescription> lastPrescriptionWithDosage = reversedPrescriptions.stream().filter(prescription -> this.isMatchingPrescription((IPrescription)prescription, billed)).findFirst();
        lastPrescriptionWithDosage.ifPresent(lastPrescription -> prescriptions.stream().filter(prescription -> {
            IArticle article = prescription.getArticle();
            return article != null && article.getGtin() != null && billed.getCode().equals(article.getGtin());
        }).filter(prescription -> {
            String dosageInstruction = prescription.getDosageInstruction();
            return dosageInstruction == null || dosageInstruction.isEmpty() || !dosageInstruction.equals(lastPrescription.getDosageInstruction());
        }).forEach(prescription -> {
            prescription.setDosageInstruction(lastPrescription.getDosageInstruction());
            prescription.setRemark(lastPrescription.getRemark());
            prescription.setDateFrom(this.actEncounter.getDate().atStartOfDay());
            CoreModelServiceHolder.get().save((Identifiable)prescription);
        }));
    }

    private boolean isMatchingPrescription(IPrescription prescription, IBilled billed) {
        IArticle article = prescription.getArticle();
        String dosage = prescription.getDosageInstruction();
        return article != null && article.getGtin() != null && billed.getCode().equals(article.getGtin()) && dosage != null && !dosage.isEmpty();
    }

    public static List<IPrescription> getRecentPatientPrescriptions(IPatient patient, LocalDateTime referenceDate) {
        return BillingProcessor.getMedicationRecent(patient, Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION, EntryType.SELF_DISPENSED), referenceDate);
    }

    public void processCodeElementBlock(ICodeElementBlock block) {
        List elements = block.getElements();
        ArrayList<String> notOkResults = new ArrayList<String>();
        for (ICodeElement element : elements) {
            this.processCodeElement(element, notOkResults);
        }
        this.handleBillingFailures(notOkResults);
        this.handleUnbillableElements(block, elements);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.actEncounter);
    }

    private void processCodeElement(ICodeElement element, List<String> notOkResults) {
        if (element instanceof IBillable) {
            this.billCodeElement((IBillable)element, notOkResults);
        } else if (element instanceof IDiagnosis) {
            this.processDiagnosis((IDiagnosis)element);
        }
    }

    private void billCodeElement(IBillable element, List<String> notOkResults) {
        String message;
        Result billResult = BillingServiceHolder.get().bill(element, this.actEncounter, 1.0);
        if (!billResult.isOK() && !notOkResults.contains(message = String.valueOf(element.getCode()) + " - " + ResultDialog.getResultMessage(billResult))) {
            notOkResults.add(message);
        }
    }

    private void handleBillingFailures(List<String> notOkResults) {
        if (!notOkResults.isEmpty()) {
            String combinedMessages = String.join((CharSequence)"\n", notOkResults);
            ResultDialog.show(Result.ERROR((String)(String.valueOf(Messages.ArticleProcessorBilledFail) + combinedMessages)));
        }
    }

    private void handleUnbillableElements(ICodeElementBlock block, List<ICodeElement> elements) {
        List diff = block.getDiffToReferences(elements);
        if (!diff.isEmpty()) {
            StringJoiner sb = new StringJoiner("\n");
            diff.forEach(r -> {
                StringJoiner stringJoiner2 = sb.add(r.toString());
            });
            ResultDialog.show(Result.ERROR((String)(String.valueOf(Messages.ArticleProcessorBilledWarningContext) + sb.toString())));
        }
    }

    public void processOtherObject(Object object) {
        if (object instanceof IBillable) {
            this.billOtherObject((IBillable)object);
        } else if (object instanceof IDiagnosis) {
            this.processDiagnosis((IDiagnosis)object);
        }
    }

    private void billOtherObject(IBillable billable) {
        Result billResult = BillingServiceHolder.get().bill(billable, this.actEncounter, 1.0);
        if (billResult.isOK()) {
            CoreModelServiceHolder.get().refresh((Identifiable)this.actEncounter, true);
        } else {
            ResultDialog.show(billResult);
        }
    }

    private void processDiagnosis(IDiagnosis diagnosis) {
        this.actEncounter.addDiagnosis(diagnosis);
        CoreModelServiceHolder.get().save((Identifiable)this.actEncounter);
    }

    private void postRefreshMedicationEvent() {
        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IPrescription.class);
    }

    public static List<IPrescription> getMedicationRecent(IPatient patient, List<EntryType> filterType, LocalDateTime referenceDate) {
        LocalDateTime startDate = referenceDate.minus(3L, ChronoUnit.MONTHS);
        IQuery query = CoreModelServiceHolder.get().getQuery(IPrescription.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        query.and((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__DATE_FROM, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)startDate);
        List iPrescriptions = query.execute();
        if (filterType != null && !filterType.isEmpty()) {
            return iPrescriptions.stream().filter(p -> filterType.contains(p.getEntryType())).collect(Collectors.toList());
        }
        return iPrescriptions;
    }
}

