/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.rgw.io.Settings;
import java.util.LinkedList;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SettingsPreferenceStore
implements IPreferenceStore {
    private IScopeContext defaultContext = null;
    Settings base;
    private LinkedList<IPropertyChangeListener> listeners = new LinkedList();

    public SettingsPreferenceStore(Settings base) {
        this.base = base;
    }

    public SettingsPreferenceStore(Settings base, String pluginId) {
        this.base = base;
        this.defaultContext = new DefaultScope();
        this.defaultContext.getNode(pluginId);
    }

    public Settings getBase() {
        return this.base;
    }

    public void flush() {
        this.base.flush();
    }

    public void undo() {
        this.base.undo();
    }

    private void set(String field, String value) {
        this.base.set(field, value);
    }

    private String get(String field) {
        String z = this.base.get(field, null);
        if (z == null && (z = this.base.get(String.valueOf(field) + "_default", null)) == null) {
            z = "";
        }
        return z;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean contains(String name) {
        return this.base.get(name, null) != null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        for (IPropertyChangeListener l : this.listeners) {
            l.propertyChange(new PropertyChangeEvent((Object)this, name, oldValue, newValue));
        }
    }

    public boolean getBoolean(String name) {
        String z = this.get(name);
        if (z.isEmpty()) {
            return false;
        }
        if (z.equals("0")) {
            return false;
        }
        return !z.equalsIgnoreCase("FALSE");
    }

    public boolean getDefaultBoolean(String name) {
        return this.getBoolean(String.valueOf(name) + "_default");
    }

    public double getDefaultDouble(String name) {
        return this.getDouble(String.valueOf(name) + "_default");
    }

    public float getDefaultFloat(String name) {
        return this.getFloat(String.valueOf(name) + "_default");
    }

    public int getDefaultInt(String name) {
        return this.getInt(String.valueOf(name) + "_default");
    }

    public long getDefaultLong(String name) {
        return this.getLong(String.valueOf(name) + "_default");
    }

    public String getDefaultString(String name) {
        return this.getString(String.valueOf(name) + "_default");
    }

    public double getDouble(String name) {
        return Double.parseDouble(this.get(name));
    }

    public float getFloat(String name) {
        return Float.parseFloat(this.get(name));
    }

    public int getInt(String name) {
        try {
            return Integer.parseInt(this.get(name));
        }
        catch (NumberFormatException ne) {
            return 0;
        }
    }

    public long getLong(String name) {
        return Long.parseLong(this.get(name));
    }

    public String getString(String name) {
        return this.get(name);
    }

    public boolean isDefault(String name) {
        String def = this.get(String.valueOf(name) + "_default");
        String act = this.get(name);
        return def.equals(act);
    }

    public boolean needsSaving() {
        return this.base.isDirty();
    }

    public void putValue(String name, String value) {
        this.set(name, value);
    }

    public void remove(String name) {
        this.base.remove(name);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setDefault(String name, double value) {
        this.set(String.valueOf(name) + "_default", Double.toString(value));
    }

    public void setDefault(String name, float value) {
        this.set(String.valueOf(name) + "_default", Float.toString(value));
    }

    public void setDefault(String name, int value) {
        this.set(String.valueOf(name) + "_default", Integer.toString(value));
    }

    public void setDefault(String name, long value) {
        this.set(String.valueOf(name) + "_default", Long.toString(value));
    }

    public void setDefault(String name, String defaultObject) {
        this.set(String.valueOf(name) + "_default", defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.set(String.valueOf(name) + "_default", Boolean.toString(value));
    }

    public void setToDefault(String name) {
        this.set(name, this.get(String.valueOf(name) + "_default"));
    }

    public void setValue(String name, double value) {
        this.firePropertyChangeEvent(name, this.getDouble(name), value);
        this.set(name, Double.toString(value));
    }

    public void setValue(String name, float value) {
        this.firePropertyChangeEvent(name, Float.valueOf(this.getFloat(name)), Float.valueOf(value));
        this.set(name, Float.toString(value));
    }

    public void setValue(String name, int value) {
        this.firePropertyChangeEvent(name, this.getInt(name), value);
        this.set(name, Integer.toString(value));
    }

    public void setValue(String name, long value) {
        this.firePropertyChangeEvent(name, this.getLong(name), value);
        this.set(name, Long.toString(value));
    }

    public void setValue(String name, String value) {
        this.firePropertyChangeEvent(name, this.getString(name), value);
        this.set(name, value);
    }

    public void setValue(String name, boolean value) {
        this.firePropertyChangeEvent(name, this.getBoolean(name), value);
        this.set(name, Boolean.toString(value));
    }
}

