/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.AccountTransaction;
import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AccountsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer viewer;
    private ToolBarManager toolbarmgr;

    public void init(IWorkbench workbench) {
        this.setTitle("Konti f\u00fcr Buchungen");
        this.setDescription("Die hier verwalteten Konti, k\u00f6nnen bei Buchungen vergeben werden, und sind dann bei den Auswertungen (Zahlungsjournal) ersichtlich.");
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        this.toolbarmgr = new ToolBarManager();
        this.toolbarmgr.add((IAction)new AddAccountAction());
        this.toolbarmgr.add((IAction)new RemoveAccountAction());
        this.toolbarmgr.add((IAction)new InitDefaultsAction());
        ToolBar toolbar = this.toolbarmgr.createControl(ret);
        toolbar.setLayoutData((Object)new GridData(131072, 128, true, false));
        Composite tableComposite = new Composite(ret, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(tableComposite, 67584);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.getTable().setHeaderVisible(true);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText("Nummer");
        columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 60));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AccountTransaction.Account) {
                    return Integer.toString(((AccountTransaction.Account)element).getNumeric());
                }
                return super.getText(element);
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText("Name");
        columnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(70, 140));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AccountTransaction.Account) {
                    return ((AccountTransaction.Account)element).getName();
                }
                return super.getText(element);
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof AccountTransaction.Account && e2 instanceof AccountTransaction.Account) {
                    Integer e1Num = ((AccountTransaction.Account)e1).getNumeric();
                    Integer e2Num = ((AccountTransaction.Account)e2).getNumeric();
                    return e1Num.compareTo(e2Num);
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.updateViewer();
        return ret;
    }

    private void updateViewer() {
        HashMap accounts = AccountTransaction.Account.getAccounts();
        accounts.remove(-1);
        this.viewer.setInput(accounts.values());
    }

    private class AddAccountAction
    extends Action {
        private AddAccountAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public String getToolTipText() {
            return "Account hinzuf\u00fcgen";
        }

        public void run() {
            AccountTransaction.Account newAccount = new AccountTransaction.Account(-1, "?");
            EditAccountDialog dialog = new EditAccountDialog(AccountsPreferencePage.this.getShell(), newAccount);
            if (dialog.open() == 0) {
                AccountTransaction.Account.addAccount((AccountTransaction.Account)newAccount);
                AccountsPreferencePage.this.updateViewer();
            }
        }
    }

    private class EditAccountDialog
    extends TitleAreaDialog {
        private AccountTransaction.Account account;
        private Text numericText;
        private Text nameText;

        public EditAccountDialog(Shell parentShell, AccountTransaction.Account account) {
            super(parentShell);
            this.account = account;
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            ret.setLayout((Layout)new GridLayout(2, false));
            this.setTitle("Konto editieren");
            Label lbl = new Label(ret, 0);
            lbl.setText("Nummer");
            this.numericText = new Text(ret, 2048);
            GridData gd = new GridData(16384, 128, false, false);
            gd.widthHint = 100;
            this.numericText.setLayoutData((Object)gd);
            if (this.account != null) {
                this.numericText.setText(Integer.toString(this.account.getNumeric()));
            }
            lbl = new Label(ret, 0);
            lbl.setText("Name");
            this.nameText = new Text(ret, 2048);
            this.nameText.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            if (this.account != null) {
                this.nameText.setText(this.account.getName());
            }
            return ret;
        }

        protected void okPressed() {
            String name = this.nameText.getText();
            String numeric = this.numericText.getText();
            if (name == null || name.isEmpty()) {
                this.setErrorMessage("Bitte Name eingeben.");
                return;
            }
            if (numeric == null || numeric.isEmpty()) {
                this.setErrorMessage("Bitte Nummer eingeben.");
                return;
            }
            Integer numericInt = -1;
            try {
                numericInt = Integer.parseInt(numeric);
            }
            catch (NumberFormatException nfe) {
                this.setErrorMessage("Bitte numerischen Wert als Nummer eingeben.");
                return;
            }
            HashMap accounts = AccountTransaction.Account.getAccounts();
            if (accounts.containsKey(numericInt)) {
                this.setErrorMessage("Der Wert " + numericInt + " ist bereits vergeben.");
                return;
            }
            this.account.setNumeric(numericInt);
            this.account.setName(name);
            super.okPressed();
        }
    }

    private class InitDefaultsAction
    extends Action {
        private InitDefaultsAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DATA.getImageDescriptor();
        }

        public String getToolTipText() {
            return "Defaults Accounts initialisieren";
        }

        public void run() {
            AccountTransaction.Account.initDefaults();
            AccountsPreferencePage.this.updateViewer();
        }
    }

    private class RemoveAccountAction
    extends Action {
        private RemoveAccountAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public String getToolTipText() {
            return "Account entfernen";
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)AccountsPreferencePage.this.viewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                AccountTransaction.Account account = (AccountTransaction.Account)selection.getFirstElement();
                AccountTransaction.Account.removeAccount((AccountTransaction.Account)account);
                AccountsPreferencePage.this.updateViewer();
            }
        }
    }
}

