/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.data.PersistentObject;
import java.util.Optional;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class LockStatusDialog
extends TitleAreaDialog {
    private CheckboxTableViewer checkboxTableViewer;

    public LockStatusDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(final Composite parent) {
        this.setMessage("Overview on the locks currently held by this Elexis instance");
        this.setTitle("Lock Status");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)67584);
        Table table = this.checkboxTableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.checkboxTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Optional identifiable;
                LockInfo li = (LockInfo)element;
                PersistentObject po = CoreHub.poFactory.createFromString(li.getElementStoreToString());
                String label = po != null ? po.getLabel() : ((identifiable = StoreToStringServiceHolder.get().loadFromString(li.getElementStoreToString())).isPresent() ? ((Identifiable)identifiable.get()).getLabel() : "null");
                return String.valueOf(li.getElementType()) + ": " + label;
            }
        });
        this.checkboxTableViewer.setInput((Object)LocalLockServiceHolder.get().getCopyOfAllHeldLocks());
        Label lblSystemUuid = new Label(container, 0);
        lblSystemUuid.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSystemUuid.setText("System UUID: " + LocalLockServiceHolder.get().getSystemUuid());
        Link accessTokenLink = new Link(container, 0);
        accessTokenLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        accessTokenLink.setText("<a>Copy Access Token to Clipboard</a>");
        accessTokenLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String token = ((AccessToken)ContextServiceHolder.get().getTyped(AccessToken.class).get()).getToken();
                Clipboard clipboard = new Clipboard(parent.getDisplay());
                clipboard.setContents(new Object[]{token}, new Transfer[]{TextTransfer.getInstance()});
                LockStatusDialog.this.setMessage("Access Token copied to Clipboard!");
            }
        });
        accessTokenLink.setEnabled(ContextServiceHolder.get().getTyped(AccessToken.class).isPresent());
        Label lblLockStatus = new Label(container, 0);
        IElexisServerService.ConnectionStatus connectionStatus = ElexisServerServiceHolder.get().getConnectionStatus();
        StringBuilder statusString = new StringBuilder();
        statusString.append("Lock-Service: " + connectionStatus.name());
        if (connectionStatus != IElexisServerService.ConnectionStatus.STANDALONE) {
            statusString.append(" @ " + ElexisServerServiceHolder.get().getConnectionUrl());
        }
        lblLockStatus.setText(statusString.toString());
        return area;
    }

    protected void okPressed() {
        this.setErrorMessage(null);
        Object[] checkedElements = this.checkboxTableViewer.getCheckedElements();
        boolean error = false;
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            LockInfo lockInfo = (LockInfo)object;
            LockResponse lockResponse = LocalLockServiceHolder.get().releaseLock(lockInfo);
            if (!lockResponse.isOk()) {
                this.setErrorMessage("Error releasing lock " + lockInfo.getElementStoreToString());
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            super.okPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }
}

