/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.actions.ScannerEvents;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.text.ElexisText;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class OrderImportDialog
extends TitleAreaDialog {
    private static final String ALLE_MARKIEREN = " Alle markieren ";
    private static final int DIFF_SPINNER_MIN = 1;
    private static final int DIFF_SPINNER_DEFAULT = 1;
    public static int ACTION_MODE_REGISTER = 0;
    public static int ACTION_MODE_INVENTORY = 1;
    @Inject
    private IContextService contextService;
    private String previousBarcodeInputConsumer;
    private List<OrderElement> orderElements;
    private IOrder order;
    private Spinner diffSpinner;
    private ElexisText eanText;
    private TableViewer viewer;
    private Color verifiedColor;
    private Font boldFont;
    private int actionMode;
    private TableColumnLayout tcLayout;
    boolean subscribed = true;

    public OrderImportDialog(Shell parentShell, IOrder order) {
        this(parentShell, order, 0);
    }

    public OrderImportDialog(Shell parentShell, IOrder order, int actionMode) {
        super(parentShell);
        this.order = order;
        this.actionMode = actionMode;
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        CoreUiUtil.injectServices((Object)((Object)this));
        this.previousBarcodeInputConsumer = this.contextService.getNamed("barcodeInputConsumer").orElse(null);
        this.contextService.getRootContext().setNamed("barcodeInputConsumer", (Object)OrderImportDialog.class.getName());
        this.orderElements = new ArrayList<OrderElement>();
        List items = order != null ? order.getEntries() : Collections.emptyList();
        for (IOrderEntry entry : items) {
            OrderElement orderElement;
            IStockEntry stockEntry;
            if (entry.getState() == OrderEntryState.DONE) continue;
            IStock stock = entry.getStock();
            if (stock != null) {
                stockEntry = StockServiceHolder.get().findStockEntryForArticleInStock(stock, StoreToStringServiceHolder.getStoreToString((Object)entry.getArticle()));
                if (stockEntry == null) continue;
                orderElement = new OrderElement(entry, stockEntry, entry.getAmount());
                this.orderElements.add(orderElement);
                continue;
            }
            stockEntry = StockServiceHolder.get().findPreferredStockEntryForArticle(StoreToStringServiceHolder.getStoreToString((Object)entry.getArticle()), ElexisEventDispatcher.getSelectedMandator().getId());
            if (stockEntry != null) {
                orderElement = new OrderElement(entry, stockEntry, entry.getAmount());
                this.orderElements.add(orderElement);
                continue;
            }
            TransientStockEntry transienStockEntry = new TransientStockEntry(entry.getArticle());
            OrderElement orderElement2 = new OrderElement(entry, transienStockEntry, entry.getAmount());
            this.orderElements.add(orderElement2);
        }
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = new Composite(parent, 0);
        mainArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        mainArea.setLayout((Layout)new GridLayout());
        Composite scannerArea = new Composite(mainArea, 0);
        scannerArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        scannerArea.setLayout((Layout)new GridLayout());
        Group scannerGroup = new Group(scannerArea, 0);
        scannerGroup.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        scannerGroup.setLayout((Layout)new GridLayout(4, false));
        scannerGroup.setText("Einlesen mit Barcode-Scanner");
        this.diffSpinner = new Spinner((Composite)scannerGroup, 0);
        this.diffSpinner.setMinimum(1);
        this.diffSpinner.setSelection(1);
        Label eanLabel = new Label((Composite)scannerGroup, 0);
        eanLabel.setText("EAN:");
        this.eanText = new ElexisText((Composite)scannerGroup, 0);
        this.eanText.setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
        this.eanText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    OrderImportDialog.this.applyScanner();
                }
            }
        });
        Button button = new Button((Composite)scannerGroup, 8);
        button.setText("\u00dcbernehmen");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OrderImportDialog.this.applyScanner();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite tableArea = new Composite(mainArea, 0);
        tableArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        tableArea.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(tableArea, 65536);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tcLayout = new TableColumnLayout();
        tableArea.setLayout((Layout)this.tcLayout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.verifiedColor = table.getDisplay().getSystemColor(6);
        this.boldFont = this.createBoldFont(table.getFont());
        TableViewerFocusCellManager mgr = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || event.character == ' ') || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)mgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.createViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ViewerContentProvider());
        this.viewer.setInput((Object)this);
        if (this.actionMode == ACTION_MODE_REGISTER) {
            this.viewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    IArticle a1 = ((OrderElement)e1).getArticle();
                    IArticle a2 = ((OrderElement)e2).getArticle();
                    if (a1 != null && a2 != null) {
                        return a1.getName().compareTo(a2.getName());
                    }
                    return 0;
                }
            });
        }
        Composite cButtons = new Composite(mainArea, 0);
        cButtons.setLayout((Layout)new GridLayout(2, false));
        final Button clickAllButton = new Button(cButtons, 8);
        clickAllButton.setText(ALLE_MARKIEREN);
        clickAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bv = true;
                if (clickAllButton.getText().equals(OrderImportDialog.ALLE_MARKIEREN)) {
                    bv = true;
                    clickAllButton.setText("Alle demarkieren");
                } else {
                    bv = false;
                    clickAllButton.setText(OrderImportDialog.ALLE_MARKIEREN);
                }
                for (OrderElement oe : OrderImportDialog.this.orderElements) {
                    oe.setVerified(bv);
                }
                OrderImportDialog.this.viewer.refresh(true);
            }
        });
        Button importButton = new Button(cButtons, 8);
        importButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        importButton.setText("Lagerbest\u00e4nde markierte anpassen");
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OrderImportDialog.this.actionMode == ACTION_MODE_REGISTER) {
                    OrderImportDialog.this.doImport();
                } else if (OrderImportDialog.this.actionMode == ACTION_MODE_INVENTORY) {
                    OrderImportDialog.this.doFixInventory();
                }
            }
        });
        cButtons.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        return mainArea;
    }

    private Font createBoldFont(Font baseFont) {
        FontData fd = baseFont.getFontData()[0];
        Font font = new Font(baseFont.getDevice(), fd.getName(), fd.getHeight(), fd.getStyle() | 1);
        return font;
    }

    private void createViewerColumns() {
        final CheckboxCellEditor checkboxCellEditor = new CheckboxCellEditor((Composite)this.viewer.getTable());
        final TextCellEditor textCellEditor = new TextCellEditor((Composite)this.viewer.getTable());
        TableViewerColumn column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.Core_ok);
        this.tcLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(50, true, true));
        column.setLabelProvider((CellLabelProvider)new CheckboxLabelProvider());
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            public boolean canEdit(Object element) {
                return true;
            }

            public CellEditor getCellEditor(Object element) {
                return checkboxCellEditor;
            }

            public Object getValue(Object element) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    return orderElement.isVerified();
                }
                return null;
            }

            public void setValue(Object element, Object value) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    if (value instanceof Boolean) {
                        Boolean bValue = (Boolean)value;
                        orderElement.setVerified(bValue);
                    }
                    OrderImportDialog.this.viewer.update((Object)orderElement, null);
                }
            }
        });
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.BestellView_delivered);
        this.tcLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(60, true, true));
        column.setLabelProvider((CellLabelProvider)new AmountLabelProvider());
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            public boolean canEdit(Object element) {
                return true;
            }

            public CellEditor getCellEditor(Object element) {
                return textCellEditor;
            }

            public Object getValue(Object element) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    return orderElement.getAmountAsString();
                }
                return null;
            }

            public void setValue(Object element, Object value) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    if (value instanceof String) {
                        String text = (String)value;
                        try {
                            int amount = Integer.parseInt(text);
                            orderElement.setAmount(amount);
                            orderElement.setVerified(true);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    OrderImportDialog.this.viewer.update((Object)orderElement, null);
                }
            }
        });
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.BestellView_inventory);
        this.tcLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(60, true, true));
        column.setLabelProvider((CellLabelProvider)new StockLabelProvider());
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.Core_Phamacode);
        this.tcLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(70, true, true));
        column.setLabelProvider((CellLabelProvider)new PharamcodeLabelProvider());
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.Core_EAN);
        this.tcLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(70, true, true));
        column.setLabelProvider((CellLabelProvider)new EANLabelProvider());
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.UI_description);
        this.tcLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(200, true, true));
        column.setLabelProvider((CellLabelProvider)new DescriptionLabelProvider());
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText(Messages.Core_Stock);
        this.tcLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(100, true, true));
        column.setLabelProvider((CellLabelProvider)new StockNameLabelProvider());
    }

    public void create() {
        super.create();
        if (this.actionMode == ACTION_MODE_REGISTER) {
            if (this.order != null) {
                this.setTitle("Bestellung " + this.order.getLabel() + " im Lager einbuchen");
            } else {
                this.setTitle("Bestellung im Lager einbuchen");
            }
            this.setMessage("Bitte \u00fcberpr\u00fcfen Sie alle bestellten Artikel. \u00dcberpr\u00fcfte Artikel werden gr\u00fcn angezeigt. Bei der Anpassung der Lagerbest\u00e4nde werden nur jene Artikel ber\u00fccksichtigt, bei denen unter \"OK\" ein Haken gesetzt ist.");
            this.getShell().setText("Bestellung im Lager einbuchen");
        } else if (this.actionMode == ACTION_MODE_INVENTORY) {
            this.setTitle("Inventurmodus");
            this.getShell().setText("Inventurmodus");
            this.setMessage("Scannen Sie die Medikamente zur Inventur. Mehrfach-Scans m\u00f6glich. Gescannte Medikamente werden unten angezeigt und k\u00f6nnen als IST-Bestand \u00fcbernommen werden.");
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Schliessen", false);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public boolean close() {
        this.contextService.getRootContext().setNamed("barcodeInputConsumer", (Object)this.previousBarcodeInputConsumer);
        CoreUiUtil.uninjectServices((Object)((Object)this));
        return super.close();
    }

    private void applyScanner() {
        int diff = this.diffSpinner.getSelection();
        String ean = this.eanText.getText().trim();
        this.applyScanner(ean, diff, null);
    }

    private void applyScanner(String gtin, int diff, IArticle article) {
        gtin = gtin.replaceAll(Character.valueOf('\r').toString(), "");
        gtin = gtin.replaceAll(Character.valueOf('\n').toString(), "");
        gtin = gtin.replaceAll(Character.valueOf('\u0000').toString(), "");
        this.eanText.setText("");
        this.diffSpinner.setSelection(1);
        OrderElement orderElement = this.findOrderElementByEAN(gtin);
        if (orderElement != null) {
            int newAmount = orderElement.getAmount() + diff;
            this.updateOrderElement(orderElement, newAmount);
        } else if (this.actionMode == ACTION_MODE_INVENTORY) {
            String mandatorId = ((IMandator)ContextServiceHolder.get().getActiveMandator().get()).getId();
            IStock mandatorDefaultStock = StockServiceHolder.get().getMandatorDefaultStock(mandatorId);
            TransientStockEntry transientStockEntry = new TransientStockEntry(article, mandatorDefaultStock);
            OrderElement _orderElement = new OrderElement(TransientOrderEntry.getInstance(), transientStockEntry, diff);
            this.orderElements.add(_orderElement);
        } else {
            ScannerEvents.beep();
            SWTHelper.alert("Artikel nicht bestellt", "Dieser Artikel wurde nicht bestellt. Der Bestand kann nicht automatisch angepasst werden.");
        }
        this.viewer.refresh();
    }

    @Inject
    public void barcodeEvent(@Optional @UIEventTopic(value="info/elexis/event/barcodeinput") Object object, IContextService contextService) {
        if (object instanceof IArticle && StringUtils.equals((CharSequence)OrderImportDialog.class.getName(), (CharSequence)contextService.getNamed("barcodeInputConsumer").orElse(null))) {
            IArticle article = (IArticle)object;
            this.applyScanner(article.getGtin(), 1, article);
        }
    }

    private OrderElement findOrderElementByEAN(String ean) {
        if (ean == null) {
            return null;
        }
        for (OrderElement orderElement : this.orderElements) {
            if (!orderElement.getArticle().getGtin().equals(ean)) continue;
            return orderElement;
        }
        return null;
    }

    private void updateOrderElement(OrderElement orderElement, int newAmount) {
        orderElement.setAmount(newAmount);
        if (ACTION_MODE_INVENTORY != this.actionMode) {
            orderElement.setVerified(true);
        }
        this.viewer.update((Object)orderElement, null);
    }

    private void doFixInventory() {
        for (OrderElement orderElement : this.orderElements) {
            if (!orderElement.isVerified()) continue;
            IStock stock = orderElement.getStockEntry().getStock();
            IStockEntry realEntry = StockServiceHolder.get().findStockEntryForArticleInStock(stock, orderElement.getStockEntry().getArticle());
            if (realEntry == null) continue;
            LockResponse lockResponse = LocalLockServiceHolder.get().acquireLockBlocking((Object)realEntry, 1, (IProgressMonitor)new NullProgressMonitor());
            if (lockResponse.isOk()) {
                realEntry.setCurrentStock(orderElement.getAmount());
                orderElement.setVerified(false);
                CoreModelServiceHolder.get().save((Identifiable)realEntry);
                LocalLockServiceHolder.get().releaseLock(lockResponse.getLockInfo());
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)realEntry);
                continue;
            }
            throw new IllegalStateException("Could not acquire lock for stockEntry [" + realEntry.getArticle().getLabel() + "]");
        }
        this.viewer.refresh();
    }

    public void doImport() {
        try {
            for (OrderElement orderElement : this.orderElements) {
                LockResponse lockResponse;
                if (!orderElement.isVerified()) continue;
                IStockEntry stockEntry = orderElement.getStockEntry();
                if (stockEntry instanceof TransientStockEntry) {
                    stockEntry = ((TransientStockEntry)stockEntry).create(orderElement);
                }
                if ((lockResponse = LocalLockServiceHolder.get().acquireLockBlocking((Object)stockEntry, 1, (IProgressMonitor)new NullProgressMonitor())).isOk()) {
                    int diff = orderElement.getAmount();
                    int oldAmount = stockEntry.getCurrentStock();
                    int newAmount = oldAmount + diff;
                    stockEntry.setCurrentStock(newAmount);
                    orderElement.setAmount(0);
                    orderElement.setVerified(false);
                    if (diff > 0) {
                        if (orderElement.getOrderState() == OrderEntryState.PARTIAL_DELIVER) {
                            orderElement.setOrderState(3);
                        } else if (diff >= orderElement.getOrderAmount()) {
                            orderElement.setOrderState(3);
                        } else if (diff < orderElement.getOrderAmount()) {
                            orderElement.setOrderState(2);
                        }
                    }
                    CoreModelServiceHolder.get().save(Arrays.asList(stockEntry, orderElement.getOrderEntry()));
                    LocalLockServiceHolder.get().releaseLock(lockResponse.getLockInfo());
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)stockEntry);
                    continue;
                }
                throw new IllegalStateException("Could not acquire lock for stockEntry [" + stockEntry.getArticle().getLabel() + "]");
            }
        }
        catch (Exception ex) {
            SWTHelper.showError("Fehler bei Anpassung der Best\u00e4nde", "Best\u00e4nde konnten teilweise nicht korrekt angepasst werden: " + ex.getMessage());
        }
        this.viewer.refresh();
    }

    private class AmountLabelProvider
    extends BaseLabelProvider {
        private AmountLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getAmountAsString();
            }
            return text;
        }
    }

    private class BaseLabelProvider
    extends ColumnLabelProvider {
        private BaseLabelProvider() {
        }

        public Color getForeground(Object element) {
            OrderElement orderElement;
            Color color = null;
            if (element instanceof OrderElement && (orderElement = (OrderElement)element).isVerified()) {
                color = OrderImportDialog.this.verifiedColor;
            }
            return color;
        }

        public Font getFont(Object element) {
            OrderElement orderElement;
            Font font = null;
            if (element instanceof OrderElement && (orderElement = (OrderElement)element).isVerified() && orderElement.getAmount() > 0) {
                font = OrderImportDialog.this.boldFont;
            }
            return font;
        }
    }

    private class CheckboxLabelProvider
    extends BaseLabelProvider {
        private CheckboxLabelProvider() {
        }

        public String getText(Object element) {
            OrderElement orderElement;
            String text = "";
            if (element instanceof OrderElement && (orderElement = (OrderElement)element).isVerified()) {
                text = "X";
            }
            return text;
        }
    }

    private class DescriptionLabelProvider
    extends BaseLabelProvider {
        private DescriptionLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getArticle().getName();
            }
            return text;
        }
    }

    private class EANLabelProvider
    extends BaseLabelProvider {
        private EANLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getArticle().getGtin();
            }
            return text;
        }
    }

    private class OrderElement {
        private boolean verified = false;
        private final IOrderEntry orderEntry;
        private final IStockEntry stockEntry;
        private int amount;

        OrderElement(IOrderEntry orderEntry, IStockEntry stockEntry, int amount) {
            this.orderEntry = orderEntry;
            this.stockEntry = stockEntry;
            this.amount = amount;
        }

        int getAmount() {
            return this.amount;
        }

        int getOrderAmount() {
            return this.orderEntry.getAmount();
        }

        void setOrderState(int state) {
            this.orderEntry.setState(OrderEntryState.ofValue((int)state));
        }

        OrderEntryState getOrderState() {
            return this.orderEntry.getState();
        }

        void setAmount(int amount) {
            this.amount = amount;
        }

        public IArticle getArticle() {
            return this.stockEntry.getArticle();
        }

        String getAmountAsString() {
            return Integer.valueOf(this.amount).toString();
        }

        public IStockEntry getStockEntry() {
            return this.stockEntry;
        }

        boolean isVerified() {
            return this.verified;
        }

        void setVerified(boolean verified) {
            this.verified = verified;
        }

        IOrderEntry getOrderEntry() {
            return this.orderEntry;
        }
    }

    private class PharamcodeLabelProvider
    extends BaseLabelProvider {
        private PharamcodeLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getArticle().getCode();
            }
            return text;
        }
    }

    private class StockLabelProvider
    extends BaseLabelProvider {
        private StockLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                IStockEntry stockEntry = orderElement.getStockEntry();
                if (stockEntry instanceof TransientStockEntry) {
                    if (((TransientStockEntry)stockEntry).isCreated()) {
                        IStockEntry created = ((TransientStockEntry)stockEntry).getCreated();
                        text = Integer.valueOf(created.getCurrentStock()).toString();
                    } else {
                        text = ACTION_MODE_INVENTORY == OrderImportDialog.this.actionMode ? stockEntry.getStock().getCode() : "bisher kein Lagerartikel";
                    }
                } else {
                    text = Integer.valueOf(stockEntry.getCurrentStock()).toString();
                }
            }
            return text;
        }
    }

    private class StockNameLabelProvider
    extends BaseLabelProvider {
        private StockNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                IStock stock = orderElement.getStockEntry().getStock();
                return stock.getId().contains("PatientStock-") ? stock.getDescription() : stock.getCode();
            }
            return null;
        }
    }

    private static class TransientOrderEntry
    implements IOrderEntry {
        private static TransientOrderEntry instance;

        private TransientOrderEntry() {
        }

        public String getId() {
            return null;
        }

        public static IOrderEntry getInstance() {
            if (instance == null) {
                instance = new TransientOrderEntry();
            }
            return instance;
        }

        public String getLabel() {
            return null;
        }

        public boolean addXid(String domain, String id, boolean updateIfExists) {
            return false;
        }

        public IXid getXid(String domain) {
            return null;
        }

        public Long getLastupdate() {
            return null;
        }

        public boolean isDeleted() {
            return false;
        }

        public void setDeleted(boolean value) {
        }

        public IOrder getOrder() {
            return null;
        }

        public void setOrder(IOrder value) {
        }

        public IStock getStock() {
            return null;
        }

        public void setStock(IStock value) {
        }

        public int getAmount() {
            return 0;
        }

        public void setAmount(int value) {
        }

        public IArticle getArticle() {
            return null;
        }

        public void setArticle(IArticle value) {
        }

        public IContact getProvider() {
            return null;
        }

        public void setProvider(IContact value) {
        }

        public OrderEntryState getState() {
            return null;
        }

        public void setState(OrderEntryState value) {
        }

        public int getDelivered() {
            return 0;
        }

        public void setDelivered(int value) {
        }
    }

    private class TransientStockEntry
    implements IStockEntry {
        private IArticle article;
        private IStock stock;
        private IStockEntry created = null;

        public TransientStockEntry(IArticle article) {
            this(article, null);
        }

        public TransientStockEntry(IArticle article, IStock stock) {
            this.article = article;
            this.stock = stock;
        }

        public IStockEntry create(OrderElement orderElement) {
            IStock stock = StockServiceHolder.get().getDefaultStock();
            this.created = StockServiceHolder.get().storeArticleInStock(stock, StoreToStringServiceHolder.getStoreToString((Object)this.article));
            this.created.setMinimumStock(0);
            this.created.setCurrentStock(0);
            this.created.setMaximumStock(0);
            CoreModelServiceHolder.get().save((Identifiable)this.created);
            return this.created;
        }

        public boolean isCreated() {
            return this.created != null;
        }

        public IStockEntry getCreated() {
            return this.created;
        }

        public IArticle getArticle() {
            return this.article;
        }

        public int getMinimumStock() {
            return 0;
        }

        public void setMinimumStock(int minStock) {
        }

        public int getCurrentStock() {
            return 0;
        }

        public void setCurrentStock(int currentStock) {
        }

        public int getMaximumStock() {
            return 0;
        }

        public void setMaximumStock(int maxStock) {
        }

        public int getFractionUnits() {
            return 0;
        }

        public void setFractionUnits(int rest) {
        }

        public IContact getProvider() {
            String providerId = ConfigServiceHolder.getGlobal((String)"inventory/defaultArticleProvider", null);
            if (providerId != null) {
                java.util.Optional defProvider = CoreModelServiceHolder.get().load(providerId, IContact.class);
                return defProvider.orElse(null);
            }
            return null;
        }

        public void setProvider(IContact provider) {
        }

        public IStock getStock() {
            if (this.stock == null) {
                return StockServiceHolder.get().getDefaultStock();
            }
            return this.stock;
        }

        public String getId() {
            return null;
        }

        public String getLabel() {
            return this.article.getLabel();
        }

        public boolean addXid(String domain, String id, boolean updateIfExists) {
            return false;
        }

        public IXid getXid(String domain) {
            return null;
        }

        public boolean isDeleted() {
            return false;
        }

        public void setDeleted(boolean value) {
        }

        public void setStock(IStock value) {
        }

        public void setArticle(IArticle value) {
        }

        public Long getLastupdate() {
            return null;
        }
    }

    private class ViewerContentProvider
    implements IStructuredContentProvider {
        private ViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return OrderImportDialog.this.orderElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

