/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePicker;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditAUFDialog
extends TitleAreaDialog {
    private ISickCertificate auf;
    private ICoverage fall;
    private DatePicker dpVon;
    private DatePicker dpBis;
    private Text tProzent;
    private Text tGrund;
    private Text tZusatz;
    TimeTool tt = new TimeTool();

    public EditAUFDialog(Shell shell, ISickCertificate a, ICoverage fall) {
        super(shell);
        this.auf = a;
        if (this.auf != null && fall == null) {
            fall = this.auf.getCoverage();
        }
        this.fall = fall;
        if (this.fall == null) {
            this.close();
            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Neue AUF", (String)"Bitte w\u00e4hlen Sie zuerst einen Fall f\u00fcr diese AUF aus"));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, true));
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        new Label(ret, 0).setText(Messages.Core_Since);
        new Label(ret, 0).setText(Messages.Core_Date_Until);
        this.dpVon = new DatePicker(ret, 0);
        this.dpBis = new DatePicker(ret, 0);
        this.dpBis.addVerifyListener(new Listener(){

            public void handleEvent(Event event) {
                EditAUFDialog.this.checkDateSpan(EditAUFDialog.this.dpVon.getDate(), (Date)event.data, event);
            }
        });
        this.dpVon.addVerifyListener(new Listener(){

            public void handleEvent(Event event) {
                EditAUFDialog.this.checkDateSpan((Date)event.data, EditAUFDialog.this.dpBis.getDate(), event);
            }
        });
        new Label(ret, 0).setText(Messages.EditAUFDialog_percent);
        new Label(ret, 0).setText(Messages.Core_Reason);
        this.tProzent = new Text(ret, 2048);
        this.tGrund = new Text(ret, 2048);
        this.tProzent.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tGrund.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Label lbZusatz = new Label(ret, 0);
        lbZusatz.setText(Messages.EditAUFDialog_additional);
        lbZusatz.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.tZusatz = new Text(ret, 2626);
        GridData tZusatzLayout = SWTHelper.getFillGridData(2, true, 1, true);
        tZusatzLayout.heightHint = 150;
        this.tZusatz.setLayoutData((Object)tZusatzLayout);
        if (this.auf != null) {
            this.dpVon.setDate(this.asDate(this.auf.getStart()));
            this.dpBis.setDate(this.asDate(this.auf.getEnd()));
            this.tGrund.setText(this.auf.getReason());
            this.tProzent.setText(Integer.toString(this.auf.getPercent()));
            this.tZusatz.setText(this.auf.getNote());
        } else {
            this.tGrund.setText(this.fall.getReason());
            this.tProzent.setText("100");
            this.dpVon.setDate(this.tt.getTime());
            this.dpBis.setDate(this.tt.getTime());
        }
        return ret;
    }

    private void checkDateSpan(Date start, Date end, Event event) {
        if (!EditAUFDialog.validDateSpan(start, end)) {
            event.doit = false;
            SWTHelper.showError(Messages.EditAUFDialog_invalidDateSpan, Messages.EditAUFDialog_checkIfDatesValid);
        }
    }

    private Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private LocalDate asLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public void create() {
        super.create();
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        String patLabel = sp != null ? sp.getLabel() : "missing patient name";
        this.setTitle(String.valueOf(Messages.EditAUFDialog_auf) + " - " + patLabel);
        if (this.auf == null) {
            this.setMessage(Messages.EditAUFDialog_enterNewAUF);
        } else {
            this.setMessage(Messages.EditAUFDialog_editAufDetails);
        }
        this.getShell().setText(Messages.EditAUFDialog_auf);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void okPressed() {
        String zus = this.tZusatz.getText();
        if (this.auf == null) {
            this.auf = (ISickCertificate)CoreModelServiceHolder.get().create(ISickCertificate.class);
            this.auf.setDate(LocalDate.now());
            this.auf.setPatient(this.fall.getPatient());
        }
        this.auf.setCoverage(this.fall);
        this.auf.setStart(this.asLocalDate(this.dpVon.getDate()));
        this.auf.setEnd(this.asLocalDate(this.dpBis.getDate()));
        this.auf.setPercent(Integer.parseInt(this.tProzent.getText()));
        this.auf.setReason(this.tGrund.getText());
        if (!StringTool.isNothing((Object)zus)) {
            this.auf.setNote(zus);
        }
        CoreModelServiceHolder.get().save((Identifiable)this.auf);
        super.okPressed();
    }

    private static boolean validDateSpan(Date startDate, Date endDate) {
        return startDate.before(endDate) || startDate.equals(endDate);
    }

    public ISickCertificate getAuf() {
        return this.auf;
    }

    protected boolean isResizable() {
        return true;
    }
}

