/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.rgw.io.FileTool;
import ch.rgw.tools.MimeTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DisplayLabDokumenteDialog
extends TitleAreaDialog {
    private final String title;
    private final List<LabResult> labResultList;
    private TimeTool date = null;
    private IDocumentManager docManager;

    public DisplayLabDokumenteDialog(Shell parentShell, String _title, List<LabResult> _labResultList) {
        super(parentShell);
        this.title = _title;
        this.labResultList = _labResultList;
        if (this.labResultList != null && !this.labResultList.isEmpty()) {
            this.date = new TimeTool(this.labResultList.get(0).getDate());
        }
        this.initDocumentManager();
    }

    private void initDocumentManager() {
        TimeTool today = new TimeTool();
        today.setTime(new Date());
        Object os = Extensions.findBestService((String)"DocumentManagement");
        if (os != null) {
            this.docManager = (IDocumentManager)os;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)list);
        for (LabResult lr : this.labResultList) {
            list.add(lr.getResult());
        }
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DisplayLabDokumenteDialog.this.docManager != null && list.getSelectionCount() > 0) {
                    DisplayLabDokumenteDialog.this.openDocument(list.getSelection()[0]);
                }
            }
        });
        SWTHelper.center(UiDesk.getTopShell(), this.getShell());
        return composite;
    }

    public int open() {
        if (this.labResultList != null && this.labResultList.size() == 1) {
            this.openDocument(this.labResultList.get(0).getResult());
            return 0;
        }
        return super.open();
    }

    private void openDocument(String docName) {
        block12: {
            Patient patient = ElexisEventDispatcher.getSelectedPatient();
            try {
                if (this.docManager == null) break block12;
                List documentList = this.docManager.listDocuments(patient, null, docName, null, new TimeSpan(this.date, this.date), null);
                if (documentList == null || documentList.isEmpty()) {
                    throw new IOException(MessageFormat.format("Dokument {0} nicht vorhanden!", docName));
                }
                int counter = 0;
                for (IOpaqueDocument document : documentList) {
                    String fileExtension;
                    block13: {
                        fileExtension = null;
                        String mimeType = document.getMimeType();
                        if ("pdf".equalsIgnoreCase(mimeType)) {
                            mimeType = "application/pdf";
                        }
                        try {
                            MimeType docMimeType = new MimeType(mimeType);
                            fileExtension = MimeTool.getExtension((String)docMimeType.toString());
                        }
                        catch (MimeTypeParseException mpe) {
                            fileExtension = FileTool.getExtension((String)document.getMimeType());
                            if (fileExtension != null) break block13;
                            fileExtension = FileTool.getExtension((String)docName);
                        }
                    }
                    if (fileExtension == null) {
                        fileExtension = "";
                    }
                    File temp = File.createTempFile("lab" + counter, "doc." + fileExtension);
                    temp.deleteOnExit();
                    byte[] b = document.getContentsAsBytes();
                    if (b == null) {
                        throw new IOException("Dokument ist leer!");
                    }
                    FileOutputStream fos = new FileOutputStream(temp);
                    fos.write(b);
                    fos.close();
                    Program proggie = Program.findProgram((String)FileTool.getExtension((String)fileExtension));
                    if (proggie != null) {
                        proggie.execute(temp.getAbsolutePath());
                    } else if (!Program.launch((String)temp.getAbsolutePath())) {
                        Runtime.getRuntime().exec(temp.getAbsolutePath());
                    }
                    ++counter;
                }
            }
            catch (Exception ex) {
                SWTHelper.showError("Fehler beim \u00d6ffnen des Dokumentes", ex.getMessage());
            }
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        this.setTitle(sp != null ? sp.getLabel() : "missing patient name");
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        SWTHelper.center(this.getShell());
    }
}

