/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.UserServiceHolder;
import ch.rgw.tools.PasswordValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangePasswordDialog
extends TitleAreaDialog {
    private IUser user;
    private Text txtPassword1;
    private Text txtPassword2;
    private boolean passwordOk = false;
    private boolean rulesDisabled = false;
    private Button okButton;
    private PasswordChangeListener pcl = new PasswordChangeListener();
    private Set<String> disallowedPasswords = new HashSet<String>();

    public ChangePasswordDialog(Shell parentShell, IUser user) {
        super(parentShell);
        this.user = user;
        this.disallowedPasswords.add("Vkwi42Ja");
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(String.format("Passwort f\u00fcr User %s \u00e4ndern", this.user.getId()));
        this.setTitle("Passwort \u00e4ndern");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblNewPassword = new Label(container, 0);
        lblNewPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewPassword.setText("Neues Passwort");
        this.txtPassword1 = new Text(container, 0x400800);
        this.txtPassword1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtPassword1.addKeyListener((KeyListener)this.pcl);
        Label lblConfirm = new Label(container, 0);
        lblConfirm.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblConfirm.setText("Best\u00e4tigen");
        this.txtPassword2 = new Text(container, 0x400800);
        this.txtPassword2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtPassword2.addKeyListener((KeyListener)this.pcl);
        new Label(container, 0);
        new Label(container, 0);
        Label lblHint = new Label(container, 0);
        lblHint.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblHint.setText("Tipp");
        Label lblHintText = new Label(container, 0);
        lblHintText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblHintText.setText("Denken Sie sich einen kompletten Satz mit einer Zahl.\nVerwenden Sie nun die Anfangsbuchstaben jedes Wortes, \nunter Ber\u00fccksichtigung der Gro\u00df/Kleinschreibung.\n\nEin Beispiel:\nDer Satz \u201eVor kurzem wurde ich 42 Jahre alt.\u201c wird zum\nPasswort \u201eVkwi42Ja\u201c.");
        new Label(container, 0);
        final Button btnDisableRules = new Button(container, 32);
        btnDisableRules.setText("Pr\u00fcfregeln ignorieren (nicht empfohlen)");
        btnDisableRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangePasswordDialog.this.rulesDisabled = btnDisableRules.getSelection();
                ChangePasswordDialog.this.update();
            }
        });
        return area;
    }

    private void update() {
        this.okButton.setEnabled(this.rulesDisabled | this.passwordOk);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        UserServiceHolder.get().setPasswordForUser(this.user, this.txtPassword1.getText());
        super.okPressed();
    }

    private class PasswordChangeListener
    extends KeyAdapter {
        private PasswordChangeListener() {
        }

        public void keyReleased(KeyEvent e) {
            Set validateNewPass = PasswordValidator.validateNewPass((String)ChangePasswordDialog.this.txtPassword1.getText(), (String)ChangePasswordDialog.this.txtPassword2.getText(), ChangePasswordDialog.this.disallowedPasswords);
            if (Collections.singleton(PasswordValidator.PasswordValidationResult.SUCCESS).equals(validateNewPass)) {
                ChangePasswordDialog.this.passwordOk = true;
                ChangePasswordDialog.this.setErrorMessage(null);
            } else {
                ChangePasswordDialog.this.passwordOk = false;
                StringBuilder errorMessage = new StringBuilder();
                for (PasswordValidator.PasswordValidationResult pwvr : validateNewPass) {
                    switch (pwvr) {
                        case DO_NOT_MATCH: {
                            errorMessage.append("Passwords do not match.\n");
                            break;
                        }
                        case EXCLUDED_PASSWORD: {
                            errorMessage.append("Passwords is not allowed.\n");
                            break;
                        }
                        case IS_EMPTY: {
                            errorMessage.append("Passwords is empty.\n");
                            break;
                        }
                        case MISSING_LOWERCASE: {
                            errorMessage.append("At least one lowercase character required.\n");
                            break;
                        }
                        case MISSING_UPPERCASE: {
                            errorMessage.append("At least one uppercase character required.\n");
                            break;
                        }
                        case MISSING_NUMBER: {
                            errorMessage.append("At least one numeric character required.\n");
                            break;
                        }
                        case TOO_SHORT: {
                            errorMessage.append("At least 8 characters required.\n");
                            break;
                        }
                    }
                }
                ChangePasswordDialog.this.setErrorMessage(errorMessage.toString());
            }
            ChangePasswordDialog.this.update();
        }
    }
}

