/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.coolbar;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.UserServiceHolder;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MandantSelectionContributionItem {
    private ToolItem item;
    private Menu menu;
    private IMandator[] mandants;
    private MenuItem[] menuItems;
    private ToolBar fParent;
    private final Listener selectionListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.detail == 4 || event.type == 13) {
                Rectangle rect = MandantSelectionContributionItem.this.item.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = MandantSelectionContributionItem.this.fParent.toDisplay(pt);
                MandantSelectionContributionItem.this.menu.setLocation(pt.x, pt.y);
                MandantSelectionContributionItem.this.menu.setVisible(true);
            }
        }
    };

    @Inject
    public void activeMandator(@Optional IMandator mandator) {
        if (this.fParent != null && !this.fParent.isDisposed() && mandator != null) {
            CoreUiUtil.runAsyncIfActive(() -> CoreModelServiceHolder.get().load(mandator.getId(), IMandator.class).ifPresent(m -> {
                if (this.item != null) {
                    this.item.setText(m.getLabel());
                    this.fParent.setBackground(UiMandant.getColorForIMandator(m));
                    if (this.menuItems == null) {
                        this.fParent.pack();
                        return;
                    }
                    int i = 0;
                    while (i < this.menuItems.length) {
                        String id = (String)this.menuItems[i].getData();
                        if (m.getId().equalsIgnoreCase(id)) {
                            this.fParent.pack();
                            this.menuItems[i].setSelection(true);
                        } else {
                            this.menuItems[i].setSelection(false);
                        }
                        ++i;
                    }
                }
                this.fParent.getParent().layout();
            }), (Object)this.fParent);
        }
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (this.item != null && !this.item.isDisposed()) {
                this.adaptForUser(user);
            }
        });
    }

    private void adaptForUser(IUser user) {
        if (user == null && (user = (IUser)ContextServiceHolder.get().getActiveUser().orElse(null)) == null) {
            return;
        }
        List<String> workingForIds = UserServiceHolder.get().getExecutiveDoctorsWorkingFor(user).stream().map(a -> a.getId()).collect(Collectors.toList());
        this.rebuildMenuItems(workingForIds);
    }

    @PostConstruct
    protected Control createControl(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0);
        this.disposeItems();
        if (this.item != null) {
            this.item.dispose();
        }
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.fParent = toolbar;
        this.menu = new Menu((Control)this.fParent);
        List lMandator = CoreModelServiceHolder.get().getQuery(IMandator.class).execute();
        lMandator.sort(new Comparator<IMandator>(){

            @Override
            public int compare(IMandator m1, IMandator m2) {
                return m1.getLabel().compareTo(m2.getLabel());
            }
        });
        this.mandants = lMandator.toArray(new IMandator[0]);
        if (this.mandants.length < 2) {
            return null;
        }
        this.item = new ToolItem(toolbar, 4);
        this.item.setToolTipText("Aktuell ausgew\u00e4hlter Mandant bzw. Mandantenauswahl");
        ArrayList<MenuItem> menuItemList = new ArrayList<MenuItem>();
        IMandator[] iMandatorArray = this.mandants;
        int n = this.mandants.length;
        int n2 = 0;
        while (n2 < n) {
            IMandator m = iMandatorArray[n2];
            MenuItem item = this.buildMenuItem(m);
            menuItemList.add(item);
            ++n2;
        }
        this.menuItems = menuItemList.toArray(new MenuItem[0]);
        this.item.addListener(13, this.selectionListener);
        if (ContextServiceHolder.getActiveMandatorOrNull() != null && this.item != null) {
            this.item.setText(ContextServiceHolder.getActiveMandatorOrNull().getLabel());
            this.fParent.setBackground(UiMandant.getColorForIMandator(ContextServiceHolder.getActiveMandatorOrNull()));
        }
        this.adaptForUser(null);
        toolbar.pack();
        return toolbar;
    }

    private void rebuildMenuItems(List<String> workingForIds) {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int i = 0;
            while (i < this.menuItems.length) {
                if (this.menuItems[i] != null) {
                    this.menuItems[i].dispose();
                }
                ++i;
            }
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = new Menu((Control)this.fParent);
        ArrayList<MenuItem> menuItemList = new ArrayList<MenuItem>();
        IMandator[] iMandatorArray = this.mandants;
        int n = this.mandants.length;
        int n2 = 0;
        while (n2 < n) {
            IMandator m = iMandatorArray[n2];
            if (workingForIds.contains(m.getId())) {
                MenuItem item = this.buildMenuItem(m);
                menuItemList.add(item);
            }
            ++n2;
        }
        this.menuItems = menuItemList.toArray(new MenuItem[0]);
    }

    private MenuItem buildMenuItem(final IMandator m) {
        MenuItem menuItem = new MenuItem(this.menu, 16);
        menuItem.setText(m.getLabel());
        Image img = MandantSelectionContributionItem.getBoxSWTColorImage(UiMandant.getColorForIMandator(m));
        if (img != null && !img.isDisposed()) {
            menuItem.setImage(img);
        }
        menuItem.setData((Object)m.getId());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextServiceHolder.get().setActiveMandator(m);
            }
        });
        IMandator activeMandator = ContextServiceHolder.getActiveMandatorOrNull();
        if (activeMandator != null) {
            menuItem.setSelection(activeMandator.equals(m));
        }
        return menuItem;
    }

    private void disposeItems() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int i = 0;
            while (i < this.menuItems.length) {
                if (this.menuItems[i] != null) {
                    Image img = this.menuItems[i].getImage();
                    if (img != null) {
                        img.dispose();
                    }
                    this.menuItems[i].dispose();
                }
                ++i;
            }
        }
    }

    public static Image getBoxSWTColorImage(Color color) {
        String colorName = String.valueOf(color.hashCode());
        if (JFaceResources.getImageRegistry().get(colorName) == null) {
            Display display = Display.getCurrent();
            Image image = new Image((Device)display, 16, 16);
            GC gc = new GC((Drawable)image);
            gc.setBackground(color);
            gc.fillRoundRectangle(0, 0, 16, 16, 8, 8);
            gc.setForeground(display.getSystemColor(2));
            gc.dispose();
            JFaceResources.getImageRegistry().put(colorName, image);
        }
        return JFaceResources.getImageRegistry().get(colorName);
    }
}

