/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Messages;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Rechnungssteller;
import ch.rgw.io.Settings;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.text.ParseException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class MahnlaufCommand
extends AbstractHandler {
    private static final String STR_STATUS_DATUM = "StatusDatum";
    private static final String STR_MANDANT_I_D = "MandantID";
    private static final String STR_RN_STATUS = "RnStatus";
    public static final String ID = "bill.reminder";
    private Settings rnsSettings;

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        Mandant mandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        Rechnungssteller rechnungssteller = mandant.getRechnungssteller();
        this.rnsSettings = CoreHub.getUserSetting((Kontakt)rechnungssteller);
        Query qbe = new Query(Mandant.class);
        List allMandants = qbe.execute();
        for (Mandant m : allMandants) {
            if (!m.getRechnungssteller().equals((Object)rechnungssteller)) continue;
            this.performMahnlaufForMandant(m.getId());
        }
        return null;
    }

    private void performMahnlaufForMandant(String mandantId) {
        Query qbe = new Query(Rechnung.class);
        qbe.add(STR_RN_STATUS, "=", Integer.toString(InvoiceState.OPEN_AND_PRINTED.getState()));
        qbe.add(STR_MANDANT_I_D, "=", mandantId);
        TimeTool tt = new TimeTool();
        int days = this.rnsSettings.get("rechnung/days_until_1st", 30);
        Money betrag = new Money();
        try {
            betrag = new Money(this.rnsSettings.get("rechnung/amount_1st", "0.00"));
        }
        catch (ParseException ex) {
            ExHandler.handle((Throwable)ex);
        }
        tt.addHours(days * 24 * -1);
        qbe.add(STR_STATUS_DATUM, "<", tt.toString(9));
        List list = qbe.execute();
        for (Rechnung rn : list) {
            rn.setStatus(InvoiceState.DEMAND_NOTE_1);
            if (betrag.isZero()) continue;
            rn.addZahlung(new Money(betrag).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        }
        qbe.clear();
        qbe.add(STR_RN_STATUS, "=", Integer.toString(InvoiceState.DEMAND_NOTE_1_PRINTED.getState()));
        qbe.add(STR_MANDANT_I_D, "=", mandantId);
        tt = new TimeTool();
        days = this.rnsSettings.get("rechnung/days_until_2nd", 10);
        try {
            betrag = new Money(this.rnsSettings.get("rechnung/amount_2nd", "0.00"));
        }
        catch (ParseException ex) {
            ExHandler.handle((Throwable)ex);
            betrag = new Money();
        }
        tt.addHours(days * 24 * -1);
        qbe.add(STR_STATUS_DATUM, "<", tt.toString(9));
        list = qbe.execute();
        for (Rechnung rn : list) {
            rn.setStatus(InvoiceState.DEMAND_NOTE_2);
            if (betrag.isZero()) continue;
            rn.addZahlung(new Money(betrag).multiply(-1.0), Messages.Rechnung_Mahngebuehr2, null);
        }
        qbe.clear();
        qbe.add(STR_RN_STATUS, "=", Integer.toString(InvoiceState.DEMAND_NOTE_2_PRINTED.getState()));
        qbe.add(STR_MANDANT_I_D, "=", mandantId);
        tt = new TimeTool();
        days = this.rnsSettings.get("rechnung/days_until_3rd", 10);
        try {
            betrag = new Money(this.rnsSettings.get("rechnung/amount_3rd", "0.00"));
        }
        catch (ParseException ex) {
            ExHandler.handle((Throwable)ex);
            betrag = new Money();
        }
        tt.addHours(days * 24 * -1);
        qbe.add(STR_STATUS_DATUM, "<", tt.toString(9));
        list = qbe.execute();
        for (Rechnung rn : list) {
            rn.setStatus(InvoiceState.DEMAND_NOTE_3);
            if (betrag.isZero()) continue;
            rn.addZahlung(new Money(betrag).multiply(-1.0), Messages.Rechnung_Mahngebuehr3, null);
        }
    }
}

