/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.text.MimeTypeUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import ch.rgw.io.FileTool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTemplateCommand
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ExportTemplateCommand.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TextTemplate textTemplate;
        Object firstElement;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection == null || (firstElement = ((IStructuredSelection)selection).getFirstElement()) == null || !(firstElement instanceof TextTemplate) || (textTemplate = (TextTemplate)firstElement).getTemplate() == null) return null;
        FileDialog fdl = new FileDialog(UiDesk.getTopShell(), 8192);
        fdl.setFilterExtensions(new String[]{MimeTypeUtil.getExtensions((String)textTemplate.getMimeType()), "*.*"});
        fdl.setFilterNames(new String[]{textTemplate.getMimeTypePrintname(), "All files"});
        fdl.setFileName(textTemplate.getName());
        String fileString = fdl.open();
        if (fileString == null) return null;
        File file = new File(String.valueOf(fileString) + "." + textTemplate.getMimeType());
        byte[] contents = textTemplate.getTemplate().loadBinary();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(contents);
                try {
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        FileTool.copyStreams((InputStream)bais, (OutputStream)fos);
                    }
                    if (bais == null) return null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bais == null) throw throwable;
                    bais.close();
                    throw throwable;
                }
                bais.close();
                return null;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error creating template", (Throwable)e);
        }
        return null;
    }
}

