/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.commands.Messages;
import ch.elexis.core.ui.dialogs.GenericPrintDialog;
import ch.elexis.core.ui.views.AUF2;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AufPrintListHandler
extends AbstractHandler {
    public static final String CMD_ID = "ch.elexis.core.ui.commands.AufPrintList";
    private static final String PLACEHOLDER = "[Liste]";
    private static final String EMPTY_STRING = " ";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        AUF2 view = (AUF2)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        IPatient pat = ContextServiceHolder.get().getActivePatient().orElse(null);
        List<ISickCertificate> selectedCertificates = view.getSelectedCertificates();
        ArrayList<ISickCertificate> certificatesToPrint = new ArrayList<ISickCertificate>();
        if (!selectedCertificates.isEmpty()) {
            certificatesToPrint.addAll(selectedCertificates);
        } else if (pat != null) {
            Object[] elements;
            Object[] objectArray = elements = ((AUF2.AUFContentProvider)view.getViewer().getContentProvider()).getElements(view.getViewer().getInput());
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if ((!view.isFilterActive() || view.getFilter().select((Viewer)view.getViewer(), null, element)) && element instanceof ISickCertificate) {
                    certificatesToPrint.add((ISickCertificate)element);
                }
                ++n2;
            }
        }
        if (!certificatesToPrint.isEmpty()) {
            String[][] aufData = new String[certificatesToPrint.size() + 2][];
            aufData[0] = new String[]{String.valueOf(Messages.PATIENT_AUF) + EMPTY_STRING + (pat != null ? pat.getLabel() : "")};
            aufData[1] = new String[]{EMPTY_STRING};
            int i = 0;
            while (i < certificatesToPrint.size()) {
                ISickCertificate auf = (ISickCertificate)certificatesToPrint.get(i);
                aufData[i + 2] = new String[]{auf.getLabel().toString()};
                ++i;
            }
            GenericPrintDialog gpl = new GenericPrintDialog(activeShell, Messages.AUF_LISTE, Messages.AUF_LISTE);
            gpl.create();
            gpl.insertTable(PLACEHOLDER, aufData, null);
            gpl.open();
        } else {
            MessageDialog.openInformation((Shell)activeShell, (String)Messages.INFORMATION, (String)Messages.AUF_No_List);
        }
        return null;
    }
}

