/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.usage;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.performance.EventPerformanceStatisticHandler;
import ch.elexis.core.ui.usage.util.StatisticsManager;
import ch.elexis.core.ui.util.PerspectiveUtil;
import java.io.IOException;
import java.util.Date;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class StartupHandler
implements EventHandler {
    public void handleEvent(Event event) {
        LoggerFactory.getLogger(this.getClass()).info("APPLICATION STARTUP COMPLETE");
        if (ConfigServiceHolder.getGlobal((String)"statistics/usage/sentUsageStatistics", (boolean)false)) {
            this.registerNotifications();
            StatisticsManager.INSTANCE.getStatistics().setFrom(new Date());
            MPerspective mPerspective = PerspectiveUtil.getActivePerspective();
            if (mPerspective != null) {
                StatisticsManager.INSTANCE.addCallingStatistic(mPerspective.getElementId(), true);
            }
        }
        if (ConfigServiceHolder.getGlobal((String)"statistics/usage/sentUsageStatistics", (boolean)false)) {
            this.registerEventPerformance();
        }
    }

    private void registerEventPerformance() {
        EventPerformanceStatisticHandler eventStatisticHandler = new EventPerformanceStatisticHandler();
        ElexisEventDispatcher.getInstance().setPerformanceStatisticHandler((ElexisEventDispatcher.IPerformanceStatisticHandler)eventStatisticHandler);
        StatisticsManager.INSTANCE.setEventPerformanceStatisticHandler(eventStatisticHandler);
    }

    private void registerNotifications() {
        IEventBroker b = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        b.subscribe("org/eclipse/e4/ui/LifeCycle/bringToTop", new EventHandler(){

            public void handleEvent(Event event) {
                MPart mPart;
                Object part = event.getProperty("ChangedElement");
                if (part instanceof MPart && (mPart = (MPart)part).isToBeRendered()) {
                    StatisticsManager.INSTANCE.addCallingStatistic(mPart.getElementId(), false);
                }
            }
        });
        b.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/SET", new EventHandler(){

            public void handleEvent(Event event) {
                MPlaceholder mPlaceholder;
                Object placeholder = event.getProperty("ChangedElement");
                if (placeholder instanceof MPlaceholder && !(mPlaceholder = (MPlaceholder)placeholder).isToBeRendered()) {
                    StatisticsManager.INSTANCE.addClosingStatistic(mPlaceholder.getElementId(), false);
                }
            }
        });
        b.subscribe("org/eclipse/e4/ui/LifeCycle/appShutdownStarted", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    StatisticsManager.INSTANCE.autoExportStatistics();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(StartupHandler.class).error("cannot export usage on application exist statistics", (Throwable)e);
                }
            }
        });
        b.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/SET", new EventHandler(){

            public void handleEvent(Event event) {
                MPerspectiveStack mpartStack;
                MPerspective selectedPerspective;
                Object stack = event.getProperty("ChangedElement");
                if (stack instanceof MPerspectiveStack && (selectedPerspective = (MPerspective)(mpartStack = (MPerspectiveStack)stack).getSelectedElement()) != null) {
                    StatisticsManager.INSTANCE.addCallingStatistic(selectedPerspective.getElementId(), true);
                }
            }
        });
    }
}

