/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.performance;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.usage.model.EventStatistic;
import ch.elexis.core.ui.usage.model.IStatistic;
import ch.elexis.core.ui.usage.model.ModelFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class EventPerformanceStatisticHandler
implements ElexisEventDispatcher.IPerformanceStatisticHandler {
    private Map<String, EventStatistic> statistics = new HashMap<String, EventStatistic>();

    public void startCatchEvent(ElexisEvent ee, ElexisEventListener listener) {
        EventStatistic stat = this.getOrCreateStatistics(ee, listener);
        stat.setLastStart(System.currentTimeMillis());
        int count = stat.getValue();
        stat.setValue(++count);
    }

    public void endCatchEvent(ElexisEvent ee, ElexisEventListener listener) {
        EventStatistic stat = this.getStatistics(ee, listener);
        if (stat != null) {
            long durationMs = System.currentTimeMillis() - stat.getLastStart();
            if (durationMs > (long)stat.getMaxDuration()) {
                stat.setMaxDuration((int)durationMs);
            }
            if (durationMs < (long)stat.getMinDuration()) {
                stat.setMinDuration((int)durationMs);
            }
            long lastAverage = stat.getAvgDuration();
            stat.setAvgDuration(lastAverage + (durationMs - lastAverage) / (long)stat.getValue());
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No start stat found for " + this.getEventKey(ee, listener));
        }
    }

    private EventStatistic getStatistics(ElexisEvent ee, ElexisEventListener listener) {
        String key = this.getEventKey(ee, listener);
        return this.statistics.get(key);
    }

    private EventStatistic getOrCreateStatistics(ElexisEvent ee, ElexisEventListener listener) {
        String key = this.getEventKey(ee, listener);
        EventStatistic ret = this.statistics.get(key);
        if (ret == null) {
            ret = ModelFactory.eINSTANCE.createEventStatistic();
            ret.setAction(key);
            ret.setMinDuration(Integer.MAX_VALUE);
            this.statistics.put(key, ret);
        }
        return ret;
    }

    private String getEventKey(ElexisEvent ee, ElexisEventListener listener) {
        return String.valueOf(ee.getObjectClass() != null ? ee.getObjectClass().getName() : "noObjectClass") + "[" + this.getEventType(ee.getType()) + ", " + this.getPriority(ee.getPriority()) + "] -> " + listener.getClass();
    }

    public Collection<? extends IStatistic> getStatistics() {
        return this.statistics.values();
    }

    private String getEventType(int eventType) {
        switch (eventType) {
            case 1: {
                return "EVENT_CREATE";
            }
            case 2: {
                return "EVENT_DELETE";
            }
            case 4: {
                return "EVENT_UPDATE";
            }
            case 8: {
                return "EVENT_RELOAD";
            }
            case 16: {
                return "EVENT_SELECTED";
            }
            case 32: {
                return "EVENT_DESELECTED";
            }
            case 64: {
                return "EVENT_USER_CHANGED";
            }
            case 128: {
                return "EVENT_MANDATOR_CHANGED";
            }
            case 256: {
                return "EVENT_ELEXIS_STATUS";
            }
            case 512: {
                return "EVENT_OPERATION_PROGRESS";
            }
            case 1024: {
                return "EVENT_NOTIFICATION";
            }
            case 4096: {
                return "EVENT_LOCK_AQUIRED";
            }
            case 8192: {
                return "EVENT_LOCK_PRERELEASE";
            }
            case 16384: {
                return "EVENT_LOCK_RELEASED";
            }
        }
        return "EVENT_UNKNOWN";
    }

    private String getPriority(int priority) {
        switch (priority) {
            case 1: {
                return "PRIORITY_SYNC";
            }
            case 1000: {
                return "PRIORITY_HIGH";
            }
            case 10000: {
                return "PRIORITY_NORMAL";
            }
        }
        return "PRIORITY_UNKNOWN";
    }
}

