/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder.internal.handler;

import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.ui.mediorder.MediorderPart;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ShowPatientOrderHandler {
    @Inject
    IOrderService orderService;
    @Inject
    EPartService partService;
    @Inject
    IContextService contextService;

    @Execute
    public void execute(MPart part) {
        MediorderPart mediOrderPart = (MediorderPart)part.getObject();
        List<IStockEntry> selectedStockEntries = mediOrderPart.getSelectedStockEntries();
        for (IStockEntry stockEntry : selectedStockEntries) {
            IOrder order;
            IOrderEntry orderEntry = this.orderService.findOpenOrderEntryForStockEntry(stockEntry);
            if (orderEntry == null || (order = orderEntry.getOrder()) == null) continue;
            MPart orderPart = this.partService.findPart("ch.elexis.BestellenView");
            if (orderPart == null) {
                orderPart = this.partService.createPart("ch.elexis.BestellenView");
            }
            this.partService.showPart(orderPart, EPartService.PartState.VISIBLE);
            this.contextService.setTyped((Object)order);
            break;
        }
    }
}

