/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder.internal.handler;

import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.ui.mediorder.MediorderPart;
import ch.elexis.core.ui.mediorder.MediorderPartUtil;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class RemoveMediorderEntryHandler {
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.core.model)")
    IModelService coreModelService;
    @Inject
    IContextService contextService;
    @Inject
    IStockService stockService;

    @Execute
    public void execute(MPart part, ESelectionService selectionService) {
        MediorderPart mediOrderPart = (MediorderPart)part.getObject();
        List<IStockEntry> selectedStockEntries = mediOrderPart.getSelectedStockEntries();
        selectedStockEntries.forEach(entry -> MediorderPartUtil.removeStockEntry(entry, this.coreModelService, this.contextService, this.stockService));
        mediOrderPart.refresh();
    }
}

