/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder.internal.handler;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.mediorder.MediorderUtil;
import ch.elexis.core.model.IStock;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.ui.mediorder.MediorderPart;
import ch.elexis.core.ui.mediorder.MediorderStockState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class FilterByOrderStatusHandler {
    @Execute
    public Object execute(MPart part, MHandledToolItem item, @Named(value="activeShell") @Named(value="activeShell") Shell shell) throws ExecutionException {
        MediorderPart mediorderPart = (MediorderPart)part.getObject();
        ToolItem widget = (ToolItem)item.getWidget();
        final Map<Integer, String> stockStateMap = this.createValues();
        if (!widget.getSelection()) {
            mediorderPart.setFilterActive(false);
            mediorderPart.refresh();
        } else {
            ArrayList<Integer> reversedKeys = new ArrayList<Integer>(stockStateMap.keySet());
            Collections.reverse(reversedKeys);
            ListSelectionDialog dialog = ListSelectionDialog.of((Object)reversedKeys.toArray()).contentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance()).labelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Integer key = (Integer)element;
                    return stockStateMap.getOrDefault(key, null);
                }
            }).message(Messages.Mediorder_filter_by_status).create(shell);
            dialog.setTitle(Messages.Core_Filter);
            if (dialog.open() == 0) {
                List<Integer> selections = Arrays.stream(dialog.getResult()).filter(obj -> obj instanceof Integer).map(obj -> (Integer)obj).toList();
                mediorderPart.setCurrentFilterValue(selections);
                mediorderPart.setFilterActive(true);
                mediorderPart.setFilteredStocks(this.filterPatientStock(selections));
                mediorderPart.refresh();
            } else {
                widget.setSelection(false);
            }
        }
        return null;
    }

    private Map<Integer, String> createValues() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        MediorderStockState[] mediorderStockStateArray = MediorderStockState.values();
        int n = mediorderStockStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediorderStockState state = mediorderStockStateArray[n2];
            map.put(state.ordinal(), state.getLocaleText());
            ++n2;
        }
        return map;
    }

    private List<IStock> filterPatientStock(List<Integer> values) {
        List stocks = StockServiceHolder.get().getAllPatientStock();
        return stocks.stream().filter(stock -> {
            Integer state = MediorderUtil.calculateStockState((IStock)stock);
            return state != null && values.contains(state);
        }).toList();
    }
}

