/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.ui.mediorder.MediorderPartUtil;
import ch.rgw.tools.Result;
import ch.rgw.tools.VersionedResource;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractBillAndCloseMediorderHandler {
    private IModelService coreModelService;
    private IContextService contextService;
    private ICoverageService coverageService;
    private IBillingService billingService;
    private IStockService stockService;
    private IStickerService stickerService;
    private boolean removeStockEntry;

    protected IStatus billAndClose(IModelService coreModelService, IContextService contextService, IStockService stockService, IStickerService stickerService, ICoverageService coverageService, IBillingService billingService, List<IStockEntry> stockEntries, boolean removeStockEntry) {
        this.coreModelService = coreModelService;
        this.contextService = contextService;
        this.coverageService = coverageService;
        this.billingService = billingService;
        this.removeStockEntry = removeStockEntry;
        this.stockService = stockService;
        this.stickerService = stickerService;
        if (stockEntries.isEmpty()) {
            return Status.OK_STATUS;
        }
        IStock stock = stockEntries.get(0).getStock();
        IPerson person = stock.getOwner();
        if (!person.isPatient()) {
            return Status.error((String)Messages.Mediorder_inactive_patient_stock);
        }
        IPatient patient = person.asIPatient();
        List entries = stock.getStockEntries();
        Map<Boolean, List<IStockEntry>> mapEntries = entries.stream().collect(Collectors.partitioningBy(entry -> entry.getArticle().isObligation()));
        for (Map.Entry<Boolean, List<IStockEntry>> entry2 : mapEntries.entrySet()) {
            IStatus status = this.processArticles(entry2.getValue(), patient, entry2.getKey());
            if (status.isOK()) continue;
            return status;
        }
        if (stock.getStockEntries().isEmpty() && removeStockEntry) {
            coreModelService.remove((Identifiable)stock);
        }
        return Status.OK_STATUS;
    }

    private IStatus processArticles(List<IStockEntry> articles, IPatient patient, boolean isObligatory) {
        Optional<IEncounter> encounter;
        if (articles.isEmpty()) {
            return Status.OK_STATUS;
        }
        Optional<ICoverage> coverage = this.coverageService.getLatestOpenCoverage(patient);
        if (isObligatory) {
            if (coverage.isEmpty() || !((ICoverage)coverage.get()).getBillingSystem().getLaw().equals((Object)BillingLaw.KVG)) {
                coverage = this.getOrCreateCoverage(patient, BillingLaw.KVG);
            }
        } else if (coverage.isEmpty() || !((ICoverage)coverage.get()).getBillingSystem().getLaw().equals((Object)BillingLaw.ORG) && !coverage.get().getBillingSystem().getLaw().equals((Object)BillingLaw.privat)) {
            coverage = this.getOrCreateCoverage(patient, BillingLaw.privat);
        }
        if ((encounter = this.coverageService.getLatestEncounter(coverage.get())).isEmpty()) {
            encounter = Optional.of((IEncounter)new IEncounterBuilder(this.coreModelService, coverage.get(), (IMandator)this.contextService.getActiveMandator().get()).buildAndSave());
        }
        this.setBillingText((IEncounter)encounter.get());
        return this.billAndAdjustArticleStock((IEncounter)encounter.get(), articles, this.removeStockEntry);
    }

    private Optional<ICoverage> getOrCreateCoverage(IPatient patient, BillingLaw law) {
        Optional<ICoverage> coverage = this.coverageService.getCoverageWithLaw(patient, new BillingLaw[]{law});
        if (coverage.isEmpty()) {
            coverage = Optional.of(new ICoverageBuilder(this.coreModelService, patient, this.coverageService.getDefaultCoverageLabel(), this.coverageService.getDefaultCoverageReason(), law.toString()).buildAndSave());
        }
        return coverage;
    }

    private void setBillingText(IEncounter encounter) {
        VersionedResource vr = VersionedResource.load(null);
        vr.update(Messages.Mediorder_Billing_Text, ((IUser)this.contextService.getActiveUser().get()).getId());
        encounter.setVersionedEntry(vr);
        this.coreModelService.save((Identifiable)encounter);
    }

    private IStatus billAndAdjustArticleStock(IEncounter encounter, List<IStockEntry> entries, boolean removeStockEntry) {
        for (IStockEntry stockEntry : entries) {
            boolean isBalanced;
            IArticle article = stockEntry.getArticle();
            Result result = this.billingService.bill((IBillable)article, encounter, (double)stockEntry.getCurrentStock());
            if (!result.isOK()) {
                return Status.error((String)result.getCombinedMessages());
            }
            int currentStock = stockEntry.getCurrentStock();
            int maximumStock = stockEntry.getMaximumStock();
            int minimumStock = stockEntry.getMinimumStock();
            boolean bl = isBalanced = currentStock == maximumStock && maximumStock == minimumStock;
            if (!isBalanced) continue;
            if (removeStockEntry) {
                this.coreModelService.remove((Identifiable)stockEntry);
            } else {
                stockEntry.setMinimumStock(0);
                stockEntry.setCurrentStock(0);
                stockEntry.setMaximumStock(0);
                this.coreModelService.save((Identifiable)stockEntry);
            }
            MediorderPartUtil.removeMailSticker(this.coreModelService, this.stockService, this.stickerService, encounter.getPatient());
        }
        return Status.OK_STATUS;
    }
}

