/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.views;

import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.laboratory.controls.model.LaborItemResults;
import ch.elexis.core.ui.laboratory.views.Messages;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.jdom2.Document;
import org.jdom2.Element;

public class LaborblattView
extends ViewPart
implements ITextPlugin.ICallback {
    public static final String ID = "ch.elexis.Laborblatt";
    TextContainer text;

    public void createPartControl(Composite parent) {
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, (ITextPlugin.ICallback)this);
    }

    public void setFocus() {
    }

    public boolean createLaborblatt(Patient pat, String[] header, TreeItem[] rows) {
        return this.createLaborblatt(pat, header, rows, null);
    }

    public boolean createLaborblatt(Patient pat, String[] header, TreeItem[] rows, int[] skipColumnsIndex) {
        String[] cleanedHeader;
        if (StringUtils.isBlank((CharSequence)header[0])) {
            cleanedHeader = new String[header.length - 1];
            System.arraycopy(header, 1, cleanedHeader, 0, cleanedHeader.length);
        } else {
            cleanedHeader = header;
        }
        Brief br = this.text.createFromTemplateName(this.text.getAktuelleKons(), "Laborblatt", "Labor", (Kontakt)pat, null);
        if (br == null) {
            return false;
        }
        Tree tree = rows[0].getParent();
        int cols = tree.getColumnCount() - skipColumnsIndex.length;
        int[] colsizes = new int[cols];
        float first = 25.0f;
        float second = 10.0f;
        if (cols > 2) {
            int rest = Math.round((100.0f - first - second) / ((float)cols - 2.0f));
            int i = 2;
            while (i < cols) {
                colsizes[i] = rest;
                ++i;
            }
        }
        colsizes[0] = Math.round(first);
        colsizes[1] = Math.round(second);
        LinkedList<String[]> itemResults = new LinkedList<String[]>();
        itemResults.add(cleanedHeader);
        String[] days = new String[cleanedHeader.length - 2];
        int numberOfDays = 2;
        while (numberOfDays < cleanedHeader.length) {
            if (StringUtils.isNotBlank((CharSequence)cleanedHeader[numberOfDays]) && Character.isDigit(cleanedHeader[numberOfDays].charAt(0))) {
                days[numberOfDays - 2] = LocalDate.parse(cleanedHeader[numberOfDays], DateTimeFormatter.ofPattern("dd.MM.yyyy")).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            }
            ++numberOfDays;
        }
        String provenance = "";
        int numberOfRows = 0;
        while (numberOfRows < rows.length) {
            String[] itemResult = new String[cleanedHeader.length];
            LaborItemResults laborItemResults = (LaborItemResults)rows[numberOfRows].getData();
            itemResult[0] = String.valueOf(laborItemResults.getLabItem().getKuerzel()) + " - [" + laborItemResults.getLabItem().getUnit() + "]";
            itemResult[1] = laborItemResults.getFirstResult().getPatient().getGeschlecht().equalsIgnoreCase("m") ? laborItemResults.getFirstResult().getRefMale() : laborItemResults.getFirstResult().getRefFemale();
            int numberOfDays2 = 2;
            String[] stringArray = days;
            int n = days.length;
            int n2 = 0;
            while (n2 < n) {
                String day = stringArray[n2];
                List<LabResult> labResults = laborItemResults.getResult(day);
                if (labResults != null) {
                    for (LabResult labResult : labResults) {
                        String string = itemResult[numberOfDays2] = labResult.getFlags() == 1 ? "**" + labResult.getResult() : labResult.getResult();
                    }
                } else {
                    itemResult[numberOfDays2] = "";
                }
                ++numberOfDays2;
                ++n2;
            }
            if (!provenance.equalsIgnoreCase(laborItemResults.getFirstResult().getItem().getGroup())) {
                String[] intermediateTitle = new String[cleanedHeader.length];
                intermediateTitle[0] = laborItemResults.getFirstResult().getItem().getGroup();
                provenance = laborItemResults.getFirstResult().getItem().getGroup();
                itemResults.add(intermediateTitle);
            }
            itemResults.add(itemResult);
            ++numberOfRows;
        }
        String[][] fld = (String[][])itemResults.toArray((T[])new String[0][]);
        boolean ret = this.text.getPlugin().insertTable("[Laborwerte]", 1, fld, colsizes);
        this.text.saveBrief(br, "Labor");
        return ret;
    }

    public boolean createLaborblatt(Patient pat, String[] header, TableItem[] rows) {
        int i;
        Brief br = this.text.createFromTemplateName(this.text.getAktuelleKons(), "Laborblatt", "Labor", (Kontakt)pat, null);
        if (br == null) {
            return false;
        }
        Table table = rows[0].getParent();
        int cols = table.getColumnCount();
        int[] colsizes = new int[cols];
        float first = 25.0f;
        float second = 10.0f;
        if (cols > 2) {
            int rest = Math.round((100.0f - first - second) / ((float)cols - 2.0f));
            i = 2;
            while (i < cols) {
                colsizes[i] = rest;
                ++i;
            }
        }
        colsizes[0] = Math.round(first);
        colsizes[1] = Math.round(second);
        LinkedList<String[]> usedRows = new LinkedList<String[]>();
        usedRows.add(header);
        i = 0;
        while (i < rows.length) {
            boolean used = false;
            String[] row = new String[cols];
            int j = 0;
            while (j < cols) {
                row[j] = rows[i].getText(j);
                if (j > 1 && row[j].length() > 0) {
                    used = true;
                }
                ++j;
            }
            if (used) {
                usedRows.add(row);
            }
            ++i;
        }
        String[][] fld = (String[][])usedRows.toArray((T[])new String[0][]);
        boolean ret = this.text.getPlugin().insertTable("[Laborwerte]", 1, fld, colsizes);
        this.text.saveBrief(br, "Labor");
        return ret;
    }

    public boolean createLaborblatt(Patient pat, Document doc) {
        this.text.createFromTemplateName(this.text.getAktuelleKons(), "Laborblatt", "Labor", (Kontakt)pat, null);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        Element root = doc.getRootElement();
        String druckdat = root.getAttributeValue(Messages.LaborblattView_created);
        Element daten = root.getChild("Daten");
        List datlist = daten.getChildren();
        int cols = datlist.size() + 1;
        String[] firstline = new String[cols];
        firstline[0] = druckdat;
        int i = 1;
        while (i < cols) {
            Element dat = (Element)datlist.get(i - 1);
            firstline[i] = dat.getAttributeValue("Tag");
            ++i;
        }
        rows.add(firstline);
        List groups = root.getChildren("Gruppe");
        for (Element el : groups) {
            rows.add(new String[]{el.getAttribute("Name").getValue()});
            List params = el.getChildren("Parameter");
            for (Element param : params) {
                Element ref = param.getChild("Referenz");
                String[] row = new String[cols];
                StringBuilder sb = new StringBuilder();
                sb.append(param.getAttributeValue("Name")).append(" (").append(ref.getAttributeValue("min")).append("-").append(ref.getAttributeValue("max")).append(") ").append(param.getAttributeValue("Einheit"));
                row[0] = sb.toString();
                List results = param.getChildren("Resultat");
                int i2 = 1;
                for (Element result : results) {
                    row[i2++] = result.getValue();
                }
                rows.add(row);
            }
        }
        if (this.text.getPlugin().insertTable("[Laborwerte]", 1, (String[][])rows.toArray((T[])new String[0][]), null) && this.text.getPlugin().isDirectOutput()) {
            this.text.getPlugin().print(null, null, true);
            this.getSite().getPage().hideView((IViewPart)this);
            return true;
        }
        return false;
    }

    public void save() {
    }

    public boolean saveAs() {
        return false;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

