/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.preferences;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.laboratory.controls.util.HL7AutoGroupImporter;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.data.LabMapping;
import ch.elexis.data.Query;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabSettings
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(LabSettings.class);
    private Text txtKeepUnseen;
    private String daysKeepUnseen;
    private Text txtAnzahlMonate;
    private Font histogramFont;

    public LabSettings() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER));
        this.getPreferenceStore().setDefault("lab/localRefValues", true);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        FontData[] fontData;
        this.addField((FieldEditor)new BooleanFieldEditor("lab/showMandantOnly", Messages.LabSettings_showOrdersActiveMandant, this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("lab/heartrate_unseen", Messages.LabSettings_frequencyNewLabvalues, 3, (String[][])new String[][]{{Messages.Core_Normal, "1"}, {Messages.LabSettings_medium, "2"}, {Messages.LabSettings_slow, "3"}}, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("lab/localRefValues", Messages.LabSettings_useLocalLabRefValues, this.getFieldEditorParent()));
        Composite area = new Composite(this.getFieldEditorParent(), 0);
        area.setLayoutData((Object)new GridData(4, 128, true, false));
        area.setLayout((Layout)new GridLayout(2, false));
        Label lblKeepUnseen = new Label(area, 0);
        lblKeepUnseen.setText(Messages.LabSettings_showNewLabvaluesDays);
        this.txtKeepUnseen = new Text(area, 2048);
        this.txtKeepUnseen.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtKeepUnseen.setText(this.daysKeepUnseen);
        Button btnValidateMappings = new Button(area, 8);
        btnValidateMappings.setText(Messages.LabSettings_validateMappings);
        btnValidateMappings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Query query = new Query(LabMapping.class);
                query.add("id", "<>", "VERSION");
                List mappings = query.execute();
                int countDeleted = 0;
                for (LabMapping labMapping : mappings) {
                    if (labMapping.isMappingValid()) continue;
                    ++countDeleted;
                    labMapping.delete();
                }
                MessageDialog.openInformation((Shell)LabSettings.this.getShell(), (String)Messages.LabSettings_validateMappings, (String)MessageFormat.format(Messages.LabSettings_validateMappingsResult, countDeleted));
            }
        });
        Label lblHistogramTitle = new Label(this.getFieldEditorParent(), 0);
        lblHistogramTitle.setText(Messages.LabSettings_histogramTitle);
        FontData[] fontDataArray = fontData = lblHistogramTitle.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(10);
            ++n2;
        }
        this.histogramFont = new Font((Device)this.getFieldEditorParent().getDisplay(), fontData);
        lblHistogramTitle.setFont(this.histogramFont);
        GridData histogramTitleGridData = new GridData(4, 128, true, false);
        histogramTitleGridData.verticalIndent = 20;
        lblHistogramTitle.setLayoutData((Object)histogramTitleGridData);
        Label separator = new Label(this.getFieldEditorParent(), 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite histogramComposite = new Composite(this.getFieldEditorParent(), 0);
        histogramComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        histogramComposite.setLayout((Layout)new GridLayout(1, false));
        BooleanFieldEditor histogramPopupCheckbox = new BooleanFieldEditor("histogramPopupCheckbox", Messages.LabSettings_histogramPopupLabel, histogramComposite);
        this.addField((FieldEditor)histogramPopupCheckbox);
        Composite monthsComposite = new Composite(histogramComposite, 0);
        monthsComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        monthsComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblAnzahlMonate = new Label(monthsComposite, 0);
        lblAnzahlMonate.setText(String.valueOf(Messages.Core_Count) + " " + Messages.AbstractGraphicalView_monthActionLabel);
        this.txtAnzahlMonate = new Text(monthsComposite, 2048);
        this.txtAnzahlMonate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtAnzahlMonate.setText(ConfigServiceHolder.getUser((String)"anzahlMonate", (String)"12"));
        this.txtAnzahlMonate.addModifyListener(event -> ConfigServiceHolder.setUser((String)"anzahlMonate", (String)this.txtAnzahlMonate.getText()));
        Label lblImportTitle = new Label(this.getFieldEditorParent(), 0);
        lblImportTitle.setText(Messages.LabSettings_importTitle);
        lblImportTitle.setFont(this.histogramFont);
        GridData importTitleGridData = new GridData(4, 128, true, false);
        importTitleGridData.verticalIndent = 20;
        lblImportTitle.setLayoutData((Object)importTitleGridData);
        Label separator2 = new Label(this.getFieldEditorParent(), 258);
        separator2.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite importComposite = new Composite(this.getFieldEditorParent(), 0);
        importComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        importComposite.setLayout((Layout)new GridLayout(3, false));
        Label lblImport = new Label(importComposite, 0);
        lblImport.setText(Messages.LabSettings_importDirLabel);
        final Text txtImportPath = new Text(importComposite, 2048);
        txtImportPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtImportPath.setText(this.getPreferenceStore().getString("CFG_HL7_IMPORT_DIR"));
        Button btnBrowse = new Button(importComposite, 8);
        btnBrowse.setText(Messages.LabSettings_browseButton);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(LabSettings.this.getShell());
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    txtImportPath.setText(selectedDir);
                    LabSettings.this.getPreferenceStore().setValue("CFG_HL7_IMPORT_DIR", selectedDir);
                }
            }
        });
        Composite profileComposite = new Composite(this.getFieldEditorParent(), 0);
        profileComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        profileComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblImportProfile = new Label(profileComposite, 0);
        lblImportProfile.setText(Messages.LabSettings_importProfileLabel);
        final Combo comboProfile = new Combo(profileComposite, 12);
        comboProfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String[] profiles = new String[]{"Analytica"};
        comboProfile.setItems(profiles);
        String currentProfile = this.getPreferenceStore().getString("CFG_HL7_IMPORT_PROFILE");
        int index = Arrays.asList(profiles).indexOf(currentProfile);
        comboProfile.select(index >= 0 ? index : 0);
        comboProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedProfile = comboProfile.getItem(comboProfile.getSelectionIndex());
                LabSettings.this.getPreferenceStore().setValue("CFG_HL7_IMPORT_PROFILE", selectedProfile);
            }
        });
        Button btnAutoGroup = new Button(this.getFieldEditorParent(), 8);
        btnAutoGroup.setText(Messages.LabSettings_startAutoGroupButton);
        btnAutoGroup.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        btnAutoGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pfad = txtImportPath.getText();
                if (pfad == null || pfad.isEmpty()) {
                    MessageDialog.openWarning((Shell)LabSettings.this.getShell(), (String)Messages.LabSettings_pathMissingTitle, (String)Messages.LabSettings_pathMissingMessage);
                    return;
                }
                try {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(LabSettings.this.getShell());
                    dialog.run(true, false, monitor -> {
                        HL7AutoGroupImporter importer = new HL7AutoGroupImporter();
                        importer.setProgressMonitor(monitor);
                        AtomicInteger anzahl = new AtomicInteger();
                        try {
                            anzahl.set(importer.importDirectory(pfad));
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        Display.getDefault().asyncExec(() -> {
                            String msg = MessageFormat.format(Messages.LabSettings_importDoneMessage, anzahl.get());
                            MessageDialog.openInformation((Shell)LabSettings.this.getShell(), (String)Messages.LabSettings_importDoneTitle, (String)msg);
                        });
                    });
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)LabSettings.this.getShell(), (String)Messages.LabSettings_importErrorTitle, (String)(String.valueOf(Messages.LabSettings_importErrorMessage) + ex.getMessage()));
                    ex.printStackTrace();
                }
            }
        });
    }

    public void dispose() {
        this.disposeResources();
        super.dispose();
    }

    private void disposeResources() {
        if (this.histogramFont != null && !this.histogramFont.isDisposed()) {
            this.histogramFont.dispose();
        }
    }

    public void init(IWorkbench workbench) {
        this.daysKeepUnseen = ConfigServiceHolder.getGlobal((String)"lab/keepUnseen", null);
        if (this.daysKeepUnseen == null || !this.isValidNumber(this.daysKeepUnseen)) {
            ConfigServiceHolder.get().set("lab/keepUnseen", "3");
            this.daysKeepUnseen = "3";
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor fe;
        super.propertyChange(event);
        if (event.getSource() instanceof FieldEditor && "lab/localRefValues".equals((fe = (FieldEditor)event.getSource()).getPreferenceName()) && event.getNewValue().equals(Boolean.TRUE)) {
            MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.LabSettings_enableUseLocalLabRefValues_title, (String)Messages.LabSettings_enableUseLocalLabRefValues_text);
        }
    }

    public boolean performOk() {
        if (this.isValidNumber(this.txtKeepUnseen.getText())) {
            ConfigServiceHolder.get().set("lab/keepUnseen", this.txtKeepUnseen.getText());
        }
        this.disposeResources();
        ConfigServiceHolder.setUser((String)"anzahlMonate", (String)this.txtAnzahlMonate.getText());
        return super.performOk();
    }

    private boolean isValidNumber(String nrString) {
        try {
            Integer.parseInt(nrString);
            return true;
        }
        catch (NumberFormatException nfe) {
            log.warn("Can't use [" + nrString + "] for KeepUnseen in lab settings as it can't be parsed to an integer.");
            return false;
        }
    }
}

