/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.dialogs;

import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.laboratory.dialogs.Messages;
import ch.elexis.data.LabItem;
import ch.elexis.data.PersistentObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.statushandlers.StatusManager;

public class LabItemLabelProvider
extends ColumnLabelProvider
implements ILabelProvider {
    private HashMap<LabItem, String> cache = new HashMap();
    private static List<ItemLabelFields> defaultFields = Arrays.asList(ItemLabelFields.KUERZEL, ItemLabelFields.NAME, ItemLabelFields.GROUP, ItemLabelFields.UNIT, ItemLabelFields.REFERENCES);
    private List<ItemLabelFields> fields;
    private boolean createToolTip = false;
    private StringBuilder sb = new StringBuilder();

    public LabItemLabelProvider(boolean createToolTip) {
        this(null, createToolTip);
    }

    public LabItemLabelProvider(List<ItemLabelFields> fields, boolean createToolTip) {
        this.fields = fields == null ? defaultFields : fields;
        this.createToolTip = createToolTip;
    }

    public String getText(Object element) {
        String ret = this.cache.get(element);
        if (ret == null) {
            this.sb.setLength(0);
            if (element instanceof LabItem) {
                ((LabItem)element).get(true, new String[]{"kuerzel", "titel", "Gruppe", "Einheit"});
                for (ItemLabelFields itemLabelField : this.fields) {
                    if (this.sb.length() == 0) {
                        this.sb.append(this.getItemLabelField(itemLabelField, (LabItem)element));
                        continue;
                    }
                    this.sb.append(", ").append(this.getItemLabelField(itemLabelField, (LabItem)element));
                }
            }
            ret = this.sb.toString();
            this.cache.put((LabItem)element, ret);
        }
        return ret;
    }

    private String getItemLabelField(ItemLabelFields itemLabelField, LabItem element) {
        String ret = "";
        String[] values = element.get(true, new String[]{"kuerzel", "titel", "Gruppe", "Einheit"});
        switch (itemLabelField) {
            case KUERZEL: {
                return values[0];
            }
            case REFERENCES: {
                String refW = this.shortenString(element.getRefW());
                String refM = this.shortenString(element.getRefM());
                return String.valueOf(refW) + " / " + refM;
            }
            case GROUP: {
                return values[2];
            }
            case NAME: {
                return values[1];
            }
            case UNIT: {
                return "[" + values[3] + "]";
            }
        }
        return ret;
    }

    private String shortenString(String string) {
        if (string.length() > 15) {
            return String.valueOf(string.substring(0, 14)) + "...";
        }
        return string;
    }

    public String getToolTipText(Object element) {
        if (this.createToolTip && element instanceof LabItem) {
            int results;
            block8: {
                results = 0;
                PreparedStatement ps = PersistentObject.getConnection().getPreparedStatement("SELECT COUNT(*) AS results FROM LABORWERTE WHERE ItemID=?");
                try {
                    try {
                        ps.setString(1, ((LabItem)element).getId());
                        if (ps.execute()) {
                            ResultSet resultSet = ps.getResultSet();
                            while (resultSet.next()) {
                                results = resultSet.getInt("results");
                            }
                            resultSet.close();
                        }
                    }
                    catch (SQLException e) {
                        StatusManager.getManager().handle((IStatus)new ElexisStatus(2, "ch.elexis", 1, "Could not determine count of LabResult.", (Exception)e));
                        PersistentObject.getConnection().releasePreparedStatement(ps);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    PersistentObject.getConnection().releasePreparedStatement(ps);
                    throw throwable;
                }
                PersistentObject.getConnection().releasePreparedStatement(ps);
            }
            return String.format(Messages.MergeLabItemDialog_toolTipResultsCount, results);
        }
        return null;
    }

    public static enum ItemLabelFields {
        REFERENCES,
        KUERZEL,
        NAME,
        GROUP,
        UNIT;

    }
}

