/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.fieldassist;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.e4.fieldassist.AsyncContentProposalProvider;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PatientSearchToken {
    private boolean ignore;
    private boolean name;
    private String token;
    private DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyyMMdd");

    private PatientSearchToken(String token) {
        this.token = token;
    }

    public void setIsIgnore() {
        this.ignore = true;
    }

    public void setIsName() {
        this.name = true;
    }

    public static PatientSearchToken of(String string) {
        PatientSearchToken ret = new PatientSearchToken(string);
        return ret;
    }

    public void apply(IQuery<?> query) {
        if (this.isPatientCode()) {
            query.and("code", IQuery.COMPARATOR.EQUALS, (Object)this.token.substring(1));
        } else if (this.isDate()) {
            query.and("dob", IQuery.COMPARATOR.LIKE, (Object)AsyncContentProposalProvider.getElexisDateSearchString(this.token));
        } else if (this.name) {
            String[] tokens;
            String[] stringArray = tokens = this.token.toLowerCase().split(" ");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                String pattern = "%" + t + "%";
                query.startGroup();
                query.or("description1", IQuery.COMPARATOR.LIKE, (Object)pattern, true);
                query.or("description2", IQuery.COMPARATOR.LIKE, (Object)pattern, true);
                query.andJoinGroups();
                ++n2;
            }
        }
    }

    public boolean test(IPatient patient) {
        if (this.isPatientCode()) {
            return patient.getCode().equals(this.token.substring(1));
        }
        if (this.isDate() && patient.getDateOfBirth() != null) {
            String searchToken = AsyncContentProposalProvider.getElexisDateSearchString(this.token);
            String compareToken = searchToken.replaceAll("%", "");
            if (searchToken.startsWith("%")) {
                return this.timestampFormat.format(patient.getDateOfBirth()).endsWith(compareToken);
            }
            return this.timestampFormat.format(patient.getDateOfBirth()).startsWith(compareToken);
        }
        if (this.name) {
            String fullName = String.valueOf(patient.getDescription1().toLowerCase()) + " " + patient.getDescription2().toLowerCase();
            return fullName.startsWith(this.token.toLowerCase());
        }
        return false;
    }

    boolean isNameToken() {
        return !this.isDate() && !this.isPatientCode() && StringUtils.isNotBlank((CharSequence)this.token);
    }

    private boolean isDate() {
        if (this.token.length() == 4 && StringUtils.isNumeric((CharSequence)this.token)) {
            return true;
        }
        return this.token.length() > 2 && this.token.matches("[0-9\\.]+");
    }

    private boolean isPatientCode() {
        return this.token.length() > 1 && this.token.startsWith("#");
    }

    public boolean ignore() {
        return this.ignore;
    }

    public static List<PatientSearchToken> getPatientSearchTokens(String[] split) {
        if (split != null && split.length > 0) {
            List<PatientSearchToken> tokens = Arrays.stream(split).map(PatientSearchToken::of).collect(Collectors.toList());
            tokens.forEach(PatientSearchToken::setIsName);
            return tokens.stream().filter(st -> !st.ignore()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

