/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.fieldassist;

import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal;
import ch.elexis.core.ui.e4.fieldassist.PatientSearchToken;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public abstract class AsyncContentProposalProvider<T extends Identifiable>
implements IContentProposalProvider {
    private List<IdentifiableContentProposal<T>> proposals = new LinkedList<IdentifiableContentProposal<T>>();
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private String[] dbFields = null;
    private ContentProposalAdapter adapter = null;
    private static final int PROPOSAL_MONITORING_DELAY = 1000;
    private int lastQueriedContentHash = 0;
    private String contents = null;
    private boolean startMonitoring = false;

    public AsyncContentProposalProvider(String ... dbFields) {
        this.dbFields = dbFields;
        this.getWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AsyncContentProposalProvider.this.stopMonitoringProposalChanges();
                if (AsyncContentProposalProvider.this.executor != null) {
                    AsyncContentProposalProvider.this.executor.shutdown();
                }
            }
        });
    }

    public abstract IQuery<T> createBaseQuery();

    public abstract Widget getWidget();

    private void monitorProposalChanges(Display display) {
        if (!this.startMonitoring) {
            this.startMonitoring = true;
            Objects.requireNonNull(this.adapter, "no adapter configured");
            CompletableFuture.runAsync(() -> {
                while (this.startMonitoring) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.contents.hashCode() != this.lastQueriedContentHash) {
                        this.lastQueriedContentHash = this.contents.hashCode();
                        IQuery query = this.createBaseQuery();
                        if (this.isPatientQuery()) {
                            List<PatientSearchToken> searchParts = PatientSearchToken.getPatientSearchTokens(this.contents.toLowerCase().split(" "));
                            searchParts.forEach(st -> st.apply(query));
                        } else {
                            int i = 0;
                            String[] stringArray = this.contents.toLowerCase().split(" ");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String searchPart = stringArray[n2];
                                if (i < this.dbFields.length) {
                                    if ("dob".equals(this.dbFields[i])) {
                                        query.and(this.dbFields[i], IQuery.COMPARATOR.LIKE, (Object)AsyncContentProposalProvider.getElexisDateSearchString(searchPart), true);
                                    } else {
                                        query.and(this.dbFields[i], IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(searchPart) + "%"), true);
                                    }
                                }
                                ++i;
                                ++n2;
                            }
                        }
                        query.limit(100);
                        this.proposals.clear();
                        for (Identifiable o : query.execute()) {
                            if (o == null) continue;
                            this.proposals.add(new IdentifiableContentProposal<Identifiable>(o.getLabel(), o));
                        }
                        display.syncExec(() -> {
                            if (this.adapter != null && this.adapter.getControl() != null && !this.adapter.getControl().isDisposed()) {
                                Event event = new Event();
                                event.character = (char)32;
                                this.adapter.getControl().notifyListeners(1, event);
                                event = new Event();
                                event.character = (char)32;
                                this.adapter.getControl().notifyListeners(24, event);
                            }
                        });
                        continue;
                    }
                    this.stopMonitoringProposalChanges();
                }
            }, this.executor);
        }
    }

    protected boolean isPatientQuery() {
        return false;
    }

    private void stopMonitoringProposalChanges() {
        this.startMonitoring = false;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (contents == null || contents.length() < 1) {
            return null;
        }
        this.contents = contents;
        this.monitorProposalChanges(Display.getDefault());
        return (IContentProposal[])this.proposals.toArray(new ContentProposal[0]);
    }

    public String getLabelForObject(T a) {
        return a.getLabel();
    }

    public static String getElexisDateSearchString(String value) {
        StringBuilder sb = null;
        String ret = value.replaceAll("%", "");
        String filler = "%%%%%%%%";
        if (ret.matches("[0-9]{3,}")) {
            sb = new StringBuilder(ret);
            sb.append("%%%%%%%%");
            ret = sb.substring(0, 8);
        } else {
            int dotCount = ret.length() - ret.replace(".", "").length();
            String[] parts = ret.split("\\.");
            StringJoiner sj = new StringJoiner("");
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.length() == 1 && Character.isDigit(string.charAt(0))) {
                    sj.add("0" + string);
                } else {
                    sj.add(string);
                }
                ++n2;
            }
            sb = new StringBuilder(sj.toString());
            int lengthNoDots = sb.length();
            sb.append("%%%%%%%%");
            ret = dotCount == 1 && lengthNoDots == 6 ? String.valueOf(sb.substring(2, 6)) + sb.substring(0, 2) + sb.substring(6, 8) : String.valueOf(sb.substring(4, 8)) + sb.substring(2, 4) + sb.substring(0, 2);
        }
        return ret;
    }

    public void configureContentProposalAdapter(ContentProposalAdapter adapter) {
        this.adapter = adapter;
    }
}

