/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import ch.elexis.core.l10n.Messages;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StatusDialog {
    public static void show(IStatus status, boolean showIfOk) {
        if (!status.getMessage().isEmpty()) {
            if (status.isOK()) {
                if (showIfOk) {
                    StatusDialog.showInfo(status);
                }
            } else if (StatusDialog.isWarning(status)) {
                StatusDialog.showWarning(status);
            } else {
                StatusDialog.showError(status);
            }
        }
    }

    private static boolean showStatus(IStatus status, boolean showIfOk) {
        if (!status.getMessage().isEmpty() && status.isOK()) {
            return showIfOk;
        }
        return true;
    }

    private static boolean isWarning(IStatus status) {
        return 2 == status.getSeverity();
    }

    private static void showError(IStatus status) {
        MessageDialog.openError((Shell)StatusDialog.getShell(), (String)Messages.Core_Error, (String)StatusDialog.getStatusMessage(status));
    }

    private static void showWarning(IStatus status) {
        MessageDialog.openWarning((Shell)StatusDialog.getShell(), (String)Messages.Core_Warning, (String)StatusDialog.getStatusMessage(status));
    }

    private static void showInfo(IStatus status) {
        MessageDialog.openInformation((Shell)StatusDialog.getShell(), (String)Messages.Core_Information, (String)StatusDialog.getStatusMessage(status));
    }

    private static String getStatusMessage(IStatus status) {
        if (status instanceof MultiStatus) {
            MultiStatus _status = (MultiStatus)status;
            StringBuilder sb = new StringBuilder();
            sb.append(_status.getMessage());
            IStatus[] children = status.getChildren();
            if (children != null && children.length > 0) {
                sb.append(":");
                Arrays.asList(_status.getChildren()).forEach(entry -> {
                    StringBuilder stringBuilder2 = sb.append("\n" + entry.getMessage());
                });
            }
            return sb.toString();
        }
        return status.getMessage();
    }

    private static Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    public static void show(UISynchronize uiSynchronizer, IStatus status, boolean showIfOk) {
        if (StatusDialog.showStatus(status, showIfOk)) {
            uiSynchronizer.syncExec(() -> StatusDialog.show(status, showIfOk));
        }
    }
}

