/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.handler;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.documents.FilterCategory;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentExportHandler
extends AbstractHandler
implements IHandler {
    private static Logger logger = LoggerFactory.getLogger(DocumentExportHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        List selections = selection.toList();
        HashSet types = new HashSet();
        for (Object first : selections) {
            if (types.contains(first.getClass())) continue;
            if (first instanceof IDocument) {
                if (!types.stream().noneMatch(t -> t instanceof IDocument)) continue;
                types.add(first);
                continue;
            }
            types.add(first.getClass());
        }
        if (types.size() > 1) {
            MessageDialog.openInformation((Shell)shell, (String)"Export Information", (String)"Es k\u00f6nnen nicht Ordner und Dokumente gleichzeitig exportiert werden.");
        } else {
            Object selectionType = selection.getFirstElement();
            if (selectionType != null) {
                if (selectionType instanceof IDocument) {
                    for (Object documentToExport : selections) {
                        this.openExportDialog(shell, (IDocument)documentToExport);
                    }
                } else if (selectionType instanceof FilterCategory) {
                    this.openExportFilterCategoryDialog(shell, (FilterCategory)selectionType, selection);
                }
            }
        }
        return null;
    }

    private void openExportDialog(Shell shell, IDocument document) {
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setFileName(document.getTitle());
        fd.setFilterExtensions(this.createExtensionFilter(document));
        String fname = fd.open();
        if (fname != null) {
            try {
                if (DocumentStoreServiceHolder.getService().saveContentToFile(document, fname) == null) {
                    SWTHelper.showError((String)Messages.Core_Error_while_exporting, (String)Messages.DocumentView_exportErrorEmptyText);
                }
            }
            catch (ElexisException e) {
                logger.error("cannot export file", (Throwable)e);
                SWTHelper.showError((String)Messages.Core_Error_while_exporting, (String)Messages.DocumentView_exportErrorText);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openExportFilterCategoryDialog(Shell shell, FilterCategory filterCategory, IStructuredSelection selection) {
        FileDialog fileDialog = new FileDialog(shell, 8194);
        fileDialog.setFileName(filterCategory.getName());
        String filterCategoryName = fileDialog.open();
        if (filterCategoryName == null) return;
        int i = 0;
        block9: while (i < selection.size()) {
            FilterCategory fc = (FilterCategory)selection.toList().get(i);
            File folder = new File(String.valueOf(fileDialog.getFilterPath()) + File.separator + fc.getName());
            folder.mkdir();
            IPatient activePatient = ContextServiceHolder.get().getActivePatient().orElse(null);
            List documentList = DocumentStoreServiceHolder.getService().getDocumentsByCategory(activePatient.getId(), (ICategory)fc);
            HashSet<String> titles = new HashSet<String>();
            int a = 0;
            while (true) {
                block23: {
                    if (a >= documentList.size()) {
                        ++i;
                        continue block9;
                    }
                    IDocument document = (IDocument)documentList.get(a);
                    String _titel = document.getTitle();
                    if (titles.contains(document.getTitle())) {
                        _titel = String.valueOf(document.getTitle()) + "(" + a + ")";
                    } else {
                        titles.add(document.getTitle());
                    }
                    if (document.getContent() != null) {
                        File newFile = new File(folder.getAbsoluteFile() + File.separator + _titel + "." + document.getExtension());
                        try {
                            Throwable throwable = null;
                            Object var17_19 = null;
                            try {
                                InputStream inputStream = ((IDocument)documentList.get(a)).getContent();
                                try {
                                    try (FileOutputStream outputStream = new FileOutputStream(newFile);){
                                        if (inputStream != null) {
                                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                        }
                                    }
                                    if (inputStream == null) break block23;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (inputStream == null) throw throwable;
                                    inputStream.close();
                                    throw throwable;
                                }
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                }
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++a;
            }
            break;
        }
        return;
    }

    private String[] createExtensionFilter(IDocument document) {
        ArrayList<String> filterExtensions = new ArrayList<String>();
        if (document.getExtension() != null && !document.getExtension().isEmpty()) {
            filterExtensions.add("*." + document.getExtension());
        }
        filterExtensions.add("*.*");
        return filterExtensions.toArray(new String[0]);
    }
}

