/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.DBConnection;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RemoveDSGWhenDeceased
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        int numDeletedSticker = 0;
        ArrayList<IPatient> lIPatients = new ArrayList<IPatient>();
        String STICKER_DECEASED = "Verstorben";
        String STICKER_DSG = "missing_dsg_consent_v1";
        IQuery queryPatient = CoreModelServiceHolder.get().getQuery(IPatient.class);
        queryPatient.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DECEASED, IQuery.COMPARATOR.EQUALS, (Object)true);
        List lDeceasedPatients = queryPatient.execute();
        for (IPatient p : lDeceasedPatients) {
            lIPatients.add(p);
        }
        IQuery querySticker = CoreModelServiceHolder.get().getQuery(ISticker.class);
        querySticker.and("ID", IQuery.COMPARATOR.EQUALS, (Object)"missing_dsg_consent_v1");
        List listSticker = querySticker.execute();
        if (listSticker.isEmpty()) {
            return Messages.RemoveDSGWhenDeceased_no_dsg_found;
        }
        ISticker stickerToBeDeleted = (ISticker)listSticker.get(0);
        IQuery queryStickerDeceased = CoreModelServiceHolder.get().getQuery(ISticker.class);
        queryStickerDeceased.and((EStructuralFeature)ModelPackage.Literals.ISTICKER__NAME, IQuery.COMPARATOR.EQUALS, (Object)"Verstorben");
        List listStickerDeceased = queryStickerDeceased.execute();
        if (listStickerDeceased.isEmpty()) {
            return Messages.RemoveDSGWhenDeceased_no_deceased_found;
        }
        ISticker deceasedStcker = (ISticker)listStickerDeceased.get(0);
        DBConnection connection = PersistentObject.getDefaultConnection();
        JdbcLink.Stm stmGetObject = connection.getStatement();
        if (stickerToBeDeleted != null) {
            ResultSet resultObject = stmGetObject.query("SELECT OBJ FROM etiketten_object_link WHERE ETIKETTE = '" + deceasedStcker.getId() + "'");
            try {
                while (resultObject.next()) {
                    IPatient patient = CoreModelServiceHolder.get().load(resultObject.getString(1), IPatient.class).orElse(null);
                    if (patient == null || lIPatients.contains(patient)) continue;
                    lIPatients.add(patient);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            IStickerService stickerService = StickerServiceHolder.get();
            for (IPatient pat : lIPatients) {
                if (!stickerService.hasSticker((Identifiable)pat, stickerToBeDeleted)) continue;
                stickerService.removeSticker(stickerToBeDeleted, (Identifiable)pat);
                ++numDeletedSticker;
            }
        }
        return String.valueOf(numDeletedSticker) + " " + Messages.RemoveDSGWhenDeceased_deleted_successfully;
    }

    @Override
    public String getMaintenanceDescription() {
        return Messages.RemoveDSGWhenDeceased_description;
    }
}

