/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.test.matchers;

import ch.elexis.core.model.IEncounter;
import ch.rgw.tools.Money;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class IBillingMatch {
    public final String code;
    public final double count;
    public final int scale1;
    public final int scale2;
    public final boolean deleted;
    public Integer vk_tp;
    public Money vk_preis;

    public IBillingMatch(String code, double count) {
        this(code, count, false);
    }

    public IBillingMatch(String code, double count, boolean deleted) {
        this(code, count, 100, 100, deleted);
    }

    public IBillingMatch(String code, double count, int scale1, int scale2, boolean deleted) {
        this(code, count, scale1, scale2, null, null, deleted);
    }

    public IBillingMatch(String code, double count, int scale1, int scale2, Integer vk_tp, Money vk_preis, boolean deleted) {
        this.code = code;
        this.scale1 = scale1;
        this.scale2 = scale2;
        this.count = count;
        this.vk_tp = vk_tp;
        this.vk_preis = vk_preis;
        this.deleted = deleted;
    }

    public String getCode() {
        return this.code;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (int)(this.count * 100.0);
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + this.scale1;
        result = 31 * result + this.scale2;
        result = 31 * result + (this.vk_preis == null ? 0 : this.vk_preis.hashCode());
        result = 31 * result + (this.vk_tp == null ? 0 : this.vk_tp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IBillingMatch other = (IBillingMatch)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.scale1 != other.scale1) {
            return false;
        }
        if (this.scale2 != other.scale2) {
            return false;
        }
        if (this.vk_preis == null ? other.vk_preis != null : !this.vk_preis.equals((Object)other.vk_preis)) {
            return false;
        }
        return !(this.vk_tp == null ? other.vk_tp != null : !this.vk_tp.equals(other.vk_tp));
    }

    public String toString() {
        return "IBillingMatch [code=" + this.code + ", count=" + this.count + ", scale1=" + this.scale1 + ", scale2=" + this.scale2 + ", deleted=" + this.deleted + ", vk_tp=" + this.vk_tp + ", vk_preis=" + this.vk_preis + "]\n";
    }

    public static void assertMatch(IEncounter encounter, List<IBillingMatch> matches) {
        Collection disjunction;
        List billed = encounter.getBilled();
        List existingVerrechnet = billed.stream().map(v -> new IBillingMatch(v.getBillable().getId(), v.getAmount(), v.getPrimaryScale(), v.getSecondaryScale(), v.getPoints(), v.getPrice(), v.isDeleted())).collect(Collectors.toList());
        HashSet<String> dontMatchPrice = new HashSet<String>();
        for (IBillingMatch vm : matches) {
            if (vm.vk_tp != null && vm.vk_preis != null) continue;
            dontMatchPrice.add(vm.code);
        }
        if (!dontMatchPrice.isEmpty()) {
            for (IBillingMatch vm : existingVerrechnet) {
                if (!dontMatchPrice.contains(vm.code)) continue;
                vm.vk_preis = null;
                vm.vk_tp = null;
            }
        }
        if (!(disjunction = CollectionUtils.disjunction(existingVerrechnet, matches)).isEmpty()) {
            throw new AssertionError(disjunction);
        }
    }
}

