/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.test.context;

import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.test.context.TestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component
public class TestContextService
implements IContextService {
    private ThreadLocal<IContext> rootContext;
    @Reference
    private EventAdmin eventAdmin;
    private ConcurrentHashMap<String, TestContext> contexts;

    @Activate
    public void activate() {
        this.rootContext = new ThreadLocal<IContext>(){

            @Override
            protected IContext initialValue() {
                return new TestContext();
            }
        };
        this.contexts = new ConcurrentHashMap();
    }

    public IContext getRootContext() {
        return this.rootContext.get();
    }

    public Optional<IContext> getNamedContext(String name) {
        return Optional.ofNullable((IContext)this.contexts.get(name));
    }

    public IContext createNamedContext(String name) {
        TestContext context = new TestContext((TestContext)this.rootContext.get(), name);
        this.contexts.put(name, context);
        return context;
    }

    public void releaseContext(String name) {
        TestContext context = this.contexts.get(name);
        if (context != null) {
            context.setParent(null);
            this.contexts.remove(name);
        }
    }

    public void postEvent(String eventTopic, Object object, Map<String, Object> additionalProperties) {
        HashMap<String, Object> properites;
        if (this.eventAdmin != null) {
            properites = new HashMap<String, Object>();
            properites.put("org.eclipse.e4.data", object);
            if (additionalProperties != null) {
                properites.putAll(additionalProperties);
            }
        } else {
            throw new IllegalStateException("No EventAdmin available");
        }
        Event event = new Event(eventTopic, properites);
        this.eventAdmin.postEvent(event);
    }

    public void sendEvent(String eventTopic, Object object, Map<String, Object> additionalProperties) {
        HashMap<String, Object> properites;
        if (this.eventAdmin != null) {
            properites = new HashMap<String, Object>();
            properites.put("org.eclipse.e4.data", object);
            if (additionalProperties != null) {
                properites.putAll(additionalProperties);
            }
        } else {
            throw new IllegalStateException("No EventAdmin available");
        }
        Event event = new Event(eventTopic, properites);
        this.eventAdmin.sendEvent(event);
    }

    public <T> T submitContextInheriting(Callable<T> callable) {
        try {
            return (T)((ForkJoinTask)ForkJoinPool.commonPool().submit((Callable)callable)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            return null;
        }
    }
}

