/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service.sysevents;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskTriggerType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=info/elexis/*", "event.topics=remote/info/elexis/*"})
public class SysEventWatcher
implements EventHandler {
    private static Map<String, Set<ITaskDescriptor>> incurred = new HashMap<String, Set<ITaskDescriptor>>();
    @Reference
    private ITaskService taskService;

    public void incur(ITaskDescriptor taskDescriptor) throws TaskException {
        String topic = this.fetchTopic(taskDescriptor);
        String clazz = this.fetchClass(taskDescriptor);
        if (!StringUtils.startsWith((CharSequence)topic, (CharSequence)"info/elexis/") && !StringUtils.startsWith((CharSequence)topic, (CharSequence)"remote/info/elexis/")) {
            throw new TaskException(7, "Invalid topic, must start with [info/elexis/] or [remote/info/elexis/]");
        }
        this.registerInMap(topic, clazz, taskDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInMap(String topic, String clazz, ITaskDescriptor taskDescriptor) {
        Map<String, Set<ITaskDescriptor>> map = incurred;
        synchronized (map) {
            Set<ITaskDescriptor> topicTds = incurred.get(String.valueOf(topic) + "_" + clazz);
            if (topicTds == null) {
                topicTds = new HashSet<ITaskDescriptor>();
            }
            topicTds.add(taskDescriptor);
            incurred.put(String.valueOf(topic) + "_" + clazz, topicTds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ITaskDescriptor taskDescriptor) {
        String topic = this.fetchTopic(taskDescriptor);
        String clazz = this.fetchClass(taskDescriptor);
        Map<String, Set<ITaskDescriptor>> map = incurred;
        synchronized (map) {
            Set<ITaskDescriptor> topicTds = incurred.get(String.valueOf(topic) + "_" + clazz);
            if (topicTds != null) {
                topicTds.remove(taskDescriptor);
            }
            incurred.put(String.valueOf(topic) + "_" + clazz, topicTds);
        }
    }

    private String fetchTopic(ITaskDescriptor taskDescriptor) {
        Map<String, String> triggerParameters = taskDescriptor.getTriggerParameters();
        return triggerParameters.get("topic");
    }

    private String fetchClass(ITaskDescriptor taskDescriptor) {
        Map<String, String> triggerParameters = taskDescriptor.getTriggerParameters();
        return triggerParameters.get("class");
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        String clazz = (String)event.getProperty("class");
        Set<ITaskDescriptor> set = incurred.get(String.valueOf(topic) + "_" + clazz);
        if (set != null) {
            for (ITaskDescriptor taskDescriptor : set) {
                try {
                    HashMap<String, String> runContext = new HashMap<String, String>();
                    runContext.put("identifiableId", (String)event.getProperty("id"));
                    this.taskService.trigger(taskDescriptor, null, TaskTriggerType.SYSTEM_EVENT, runContext);
                }
                catch (TaskException e) {
                    LoggerFactory.getLogger((String)(String.valueOf(this.getClass().getName()) + "_" + taskDescriptor.getId())).warn("Error triggering taskDescriptor", (Throwable)e);
                }
            }
        }
    }
}

