/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.internal.contributors;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.spotlight.ISpotlightResult;
import ch.elexis.core.spotlight.ISpotlightResultContributor;
import ch.elexis.core.spotlight.ISpotlightResultEntry;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PatientCategorySpotlightResultContributor
implements ISpotlightResultContributor {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;

    @Override
    public void computeResult(List<String> stringTerms, List<LocalDate> dateTerms, List<Number> numericTerms, ISpotlightResult spotlightResult, Map<String, String> searchParams) {
        if (searchParams != null && searchParams.containsKey("patientId")) {
            return;
        }
        IQuery query = this.modelService.getQuery(IPatient.class);
        boolean isFirstGroup = true;
        if (!stringTerms.isEmpty()) {
            query.startGroup();
            if (stringTerms.size() == 1) {
                query.or((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true).or((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true);
            } else {
                query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true).and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(1)) + "%"), true).startGroup().and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(1)) + "%"), true).and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(stringTerms.get(0)) + "%"), true);
                query.orJoinGroups();
            }
            isFirstGroup = false;
        }
        if (!dateTerms.isEmpty()) {
            if (!isFirstGroup) {
                query.andJoinGroups();
            }
            query.startGroup().and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)dateTerms.get(0));
            isFirstGroup = false;
        }
        if (!numericTerms.isEmpty()) {
            if (!isFirstGroup) {
                query.andJoinGroups();
            }
            query.startGroup().and((EStructuralFeature)ModelPackage.Literals.ICONTACT__CODE, IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(numericTerms.get(0).intValue()) + "%"));
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.ORDER.ASC).limit(5);
        List patients = query.execute();
        for (IPatient patient : patients) {
            spotlightResult.addEntry(ISpotlightResultEntry.Category.PATIENT, patient.getLabel(), patient.getId(), patient);
        }
    }
}

