/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.internal;

import ch.elexis.core.spotlight.ISpotlightResult;
import ch.elexis.core.spotlight.ISpotlightResultContributor;
import ch.elexis.core.spotlight.ISpotlightService;
import ch.elexis.core.spotlight.internal.SpotlightResult;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class SpotlightService
implements ISpotlightService {
    private static final Pattern DATE_PATTERN = Pattern.compile("([0-9]{1,2}\\.[0-9]{1,2}\\.[0-9]{2,4})");
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ISpotlightResultContributor> resultContributors;
    Consumer<ISpotlightResult> consumer;
    private ISpotlightResult spotlightResult = new SpotlightResult();

    @Override
    public void setResultsChangedConsumer(Consumer<ISpotlightResult> resultsChangedConsumer) {
        this.consumer = resultsChangedConsumer;
    }

    @Override
    public void computeResult(String searchInput, Map<String, String> searchParams) {
        this.spotlightResult.clear();
        if (searchInput == null || searchInput.length() == 0) {
            return;
        }
        String[] searchTerms = searchInput.trim().toLowerCase().replaceAll("[^a-z0-9 .,=%]", "").split(" ");
        ArrayList<String> stringTerms = new ArrayList<String>(searchTerms.length);
        ArrayList<LocalDate> dateTerms = new ArrayList<LocalDate>(searchTerms.length);
        ArrayList<Number> numericTerms = new ArrayList<Number>(searchTerms.length);
        String[] stringArray = searchTerms;
        int n = searchTerms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            if (term.length() != 0) {
                if (term.charAt(0) >= 'a' && term.charAt(0) <= 'z' || term.length() > 1 && term.charAt(0) == '%') {
                    stringTerms.add(term);
                } else if (NumberUtils.isCreatable((String)term)) {
                    Number number = NumberUtils.createNumber((String)term);
                    numericTerms.add(number);
                } else {
                    Matcher datePatternMatcher = DATE_PATTERN.matcher(term);
                    if (datePatternMatcher.find()) {
                        String group = datePatternMatcher.group();
                        LocalDate localDate = new TimeTool(group).toLocalDate();
                        dateTerms.add(localDate);
                    } else {
                        System.out.println("unhandled " + term);
                    }
                }
            }
            ++n2;
        }
        if (stringTerms.isEmpty() && dateTerms.isEmpty() && numericTerms.isEmpty()) {
            return;
        }
        this.resultContributors.parallelStream().forEach(contributor -> {
            contributor.computeResult(stringTerms, dateTerms, numericTerms, this.spotlightResult, searchParams);
            this.consumer.accept(this.spotlightResult);
        });
    }
}

