/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.eenv.IOcrMyPdfService;
import ch.elexis.core.services.eenv.IRemoteOcrMyPdfService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class OcrMyPdfService
implements IOcrMyPdfService {
    @Reference
    private IElexisEnvironmentService elexisEnvironmentService;
    private IRemoteOcrMyPdfService remoteOcrMyPdfService;
    private final String PARAMS = "-l deu";

    @Activate
    public void activate() {
        try {
            String ocrMyPdfUrl = this.elexisEnvironmentService.getOcrMyPdfBaseUrl();
            Client client = ((ClientBuilder)ClientBuilder.newBuilder().connectTimeout(5L, TimeUnit.SECONDS).register(MultiPartFeature.class)).build();
            this.remoteOcrMyPdfService = (IRemoteOcrMyPdfService)WebResourceFactory.newResource(IRemoteOcrMyPdfService.class, (WebTarget)client.target(ocrMyPdfUrl));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error activating service", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized byte[] performOcr(byte[] in, String parameters) throws IOException, IOcrMyPdfService.OcrMyPdfException {
        if (in == null) {
            throw new IllegalArgumentException("null");
        }
        String params = parameters != null ? parameters : "-l deu";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FormDataMultiPart form = new FormDataMultiPart();){
                form.bodyPart((BodyPart)new StreamDataBodyPart("file", (InputStream)new ByteArrayInputStream(in), "filename.pdf"));
                form.field("params", params);
                InputStream performOcr = this.remoteOcrMyPdfService.performOcr(form);
                return IOUtils.toByteArray((InputStream)performOcr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClientErrorException re) {
            int status = re.getResponse().getStatus();
            Object entity = re.getResponse().getEntity();
            String body = String.valueOf(entity);
            Object object = entity;
            if (object instanceof InputStream) {
                void is;
                InputStream inputStream = (InputStream)object;
                InputStream cfr_ignored_0 = (InputStream)object;
                body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            if (status == 400) {
                if (body.contains("already")) {
                    return in;
                }
                if (body.contains("TaggedPDFError")) {
                    return in;
                }
                if (body.contains("encrypted")) {
                    throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.ENCRYPTED_FILE);
                }
                if (body.contains("dynamic XFA")) {
                    throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.UNREADABLE_XFA_FORM_FILE);
                }
                throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.OTHER, String.valueOf(re.getMessage()) + " [" + body + "]");
            }
            if (status == 413) {
                throw new IOcrMyPdfService.OcrMyPdfException(IOcrMyPdfService.OcrMyPdfException.TYPE.OTHER, "(HTTP 413) PDF is too large.");
            }
            throw new IllegalStateException("invalid state " + status + ": " + re.getMessage(), re);
        }
    }
}

