/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.services.holder.StockCommissioningServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class StockService
implements IStockService {
    private static final String PAT_STOCK_PREFIX = "P";
    private static Logger log = LoggerFactory.getLogger(StockService.class);
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IConfigService configService;
    @Reference
    private IStoreToStringService storeToStringService;

    public Long getCumulatedStockForArticle(IArticle article) {
        INamedQuery query = CoreModelServiceHolder.get().getNamedQueryByName(Long.class, IStockEntry.class, "StockEntry_SumCurrentStock.articleId.articleType");
        Optional storeToString = StoreToStringServiceHolder.get().storeToString((Identifiable)article);
        if (storeToString.isPresent()) {
            String[] parts = ((String)storeToString.get()).split("::");
            List results = query.executeWithParameters(query.getParameterMap(new Object[]{"articleId", parts[1], "articleType", parts[0]}));
            if (!results.isEmpty()) {
                return (Long)results.get(0);
            }
        }
        return null;
    }

    public void performSingleDisposal(IArticle article, int count) {
        Optional mandator = ContextServiceHolder.get().getActiveMandator();
        this.performSingleDisposal(article, count, mandator.isPresent() ? ((IMandator)mandator.get()).getId() : null);
    }

    public IStatus performSingleDisposal(IArticle article, int count, String mandatorId) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (article == null) {
            return new Status(4, "ch.elexis.core.services", "Article is null");
        }
        IStockEntry se = this.findPreferredStockEntryForArticle(StoreToStringServiceHolder.getStoreToString(article), mandatorId);
        if (se == null) {
            return new Status(2, "ch.elexis.core.services", "No stock entry for article found");
        }
        if (se.getStock().isCommissioningSystem()) {
            boolean performPartialOutlay;
            boolean isPartialUnitOutput;
            boolean suspendOutlay = this.configService.getLocal("inventory/machineOutlaySuspended", false);
            if (suspendOutlay) {
                return Status.OK_STATUS;
            }
            int sellingUnit = article.getSellingSize();
            boolean bl = isPartialUnitOutput = sellingUnit > 0 && sellingUnit < article.getPackageSize();
            if (isPartialUnitOutput && !(performPartialOutlay = this.configService.get("inventory/machineOutlayPartialPackages", false))) {
                return Status.OK_STATUS;
            }
            return StockCommissioningServiceHolder.get().performArticleOutlay(se, count, null);
        }
        LockResponse lr = LocalLockServiceHolder.get().acquireLockBlocking((Object)se, 1, (IProgressMonitor)new NullProgressMonitor());
        if (lr.isOk()) {
            int fractionUnits = se.getFractionUnits();
            int ve = article.getSellingSize();
            int vk = article.getPackageSize();
            if (vk == 0 && ve != 0) {
                vk = ve;
            }
            if (ve == 0 && vk != 0) {
                ve = vk;
            }
            int num = count * ve;
            int cs = se.getCurrentStock();
            if (vk == ve) {
                se.setCurrentStock(cs - count);
            } else {
                int rest = fractionUnits - num;
                while (rest < 0) {
                    rest += vk;
                    se.setCurrentStock(cs - 1);
                }
                se.setFractionUnits(rest);
            }
            this.coreModelService.save((Identifiable)se);
            LocalLockServiceHolder.get().releaseLock((Object)se);
            return Status.OK_STATUS;
        }
        return new Status(2, "ch.elexis.core.services", "Could not acquire lock");
    }

    public IStatus performSingleReturn(IArticle article, int count, String mandatorId) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (article == null) {
            return new Status(4, "ch.elexis.core.services", "Article is null");
        }
        IStockEntry se = this.findPreferredStockEntryForArticle(StoreToStringServiceHolder.getStoreToString(article), mandatorId);
        if (se == null) {
            return new Status(2, "ch.elexis.core.services", "No stock entry for article found");
        }
        if (se.getStock().isCommissioningSystem()) {
            return Status.OK_STATUS;
        }
        LockResponse lr = LocalLockServiceHolder.get().acquireLockBlocking((Object)se, 1, (IProgressMonitor)new NullProgressMonitor());
        if (lr.isOk()) {
            int fractionUnits = se.getFractionUnits();
            int ve = article.getSellingSize();
            int vk = article.getPackageSize();
            if (vk == 0 && ve != 0) {
                vk = ve;
            }
            if (ve == 0 && vk != 0) {
                ve = vk;
            }
            int num = count * ve;
            int cs = se.getCurrentStock();
            if (vk == ve) {
                se.setCurrentStock(cs + count);
            } else {
                int rest = fractionUnits + num;
                while (rest > vk) {
                    rest -= vk;
                    se.setCurrentStock(cs + 1);
                }
                se.setFractionUnits(rest);
            }
            this.coreModelService.save((Identifiable)se);
            LocalLockServiceHolder.get().releaseLock((Object)se);
            return Status.OK_STATUS;
        }
        return new Status(2, "ch.elexis.core.services", "Could not acquire lock");
    }

    private boolean isTriggerStockAvailabilityOnBelow() {
        int trigger = this.configService.get("inventory/order_trigger", 0);
        return trigger == 0;
    }

    public IStockService.Availability getCumulatedAvailabilityForArticle(IArticle article) {
        String[] parts;
        List results;
        INamedQuery query = null;
        query = this.isTriggerStockAvailabilityOnBelow() ? CoreModelServiceHolder.get().getNamedQueryByName(Integer.class, IStockEntry.class, "StockEntry_AvailableCurrentBelowStock.articleId.articleType") : CoreModelServiceHolder.get().getNamedQueryByName(Integer.class, IStockEntry.class, "StockEntry_AvailableCurrentStock.articleId.articleType");
        Optional storeToString = StoreToStringServiceHolder.get().storeToString((Identifiable)article);
        if (storeToString.isPresent() && !(results = query.executeWithParameters(query.getParameterMap(new Object[]{"articleId", (parts = ((String)storeToString.get()).split("::"))[1], "articleType", parts[0]}))).isEmpty()) {
            Integer value = (Integer)results.get(0);
            if (value > 1) {
                return IStockService.Availability.IN_STOCK;
            }
            if (value == 1) {
                return IStockService.Availability.CRITICAL_STOCK;
            }
            return IStockService.Availability.OUT_OF_STOCK;
        }
        return null;
    }

    public List<IStockEntry> getAllStockEntries(boolean includePatientStockEntries) {
        IQuery stockQuery = CoreModelServiceHolder.get().getQuery(IStock.class);
        stockQuery.and("ID", IQuery.COMPARATOR.LIKE, (Object)"PatientStock-%");
        List lStock = stockQuery.execute();
        IQuery query = CoreModelServiceHolder.get().getQuery(IStockEntry.class);
        if (!includePatientStockEntries) {
            for (IStock stock : lStock) {
                query.and((EStructuralFeature)ModelPackage.Literals.ISTOCK_ENTRY__STOCK, IQuery.COMPARATOR.NOT_EQUALS, (Object)stock);
            }
        }
        return query.execute();
    }

    public IStockEntry findPreferredStockEntryForArticle(String storeToString, String mandatorId) {
        List<IStockEntry> entries = this.findAllStockEntriesForArticle(storeToString);
        int val = Integer.MAX_VALUE;
        IStockEntry ret = null;
        for (IStockEntry iStockEntry : entries) {
            IPerson owner;
            IStock stock = iStockEntry.getStock();
            Integer priority = stock.getPriority();
            if (priority < val) {
                val = priority;
                ret = iStockEntry;
            }
            if (mandatorId == null || (owner = stock.getOwner()) == null || !owner.getId().equals(mandatorId)) continue;
            return iStockEntry;
        }
        return ret;
    }

    private IArticle loadArticle(String article) {
        if (article == null) {
            log.warn("performSingleReturn for null article", new Throwable("Diagnosis"));
            return null;
        }
        Optional loaded = StoreToStringServiceHolder.get().loadFromString(article);
        if (loaded.isPresent() && loaded.get() instanceof IArticle) {
            return (IArticle)loaded.get();
        }
        return null;
    }

    public List<IStock> getAllStocks(boolean includeCommissioningSystems, boolean includePatientStocks) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IStock.class);
        if (!includeCommissioningSystems) {
            query.and("driverConfig", IQuery.COMPARATOR.EQUALS, null);
        }
        if (!includePatientStocks) {
            query.and("id", IQuery.COMPARATOR.NOT_LIKE, (Object)"PatientStock-%");
        }
        query.orderBy("PRIORITY", IQuery.ORDER.ASC);
        return query.execute();
    }

    public IStock getDefaultStock() {
        IQuery query = CoreModelServiceHolder.get().getQuery(IStock.class, true, false);
        query.and((EStructuralFeature)ModelPackage.Literals.ISTOCK__CODE, IQuery.COMPARATOR.EQUALS, (Object)"STD");
        List existing = query.execute();
        if (!existing.isEmpty()) {
            return (IStock)existing.get(0);
        }
        IStock stock = (IStock)CoreModelServiceHolder.get().create(IStock.class);
        stock.setCode("STD");
        CoreModelServiceHolder.get().save((Identifiable)stock);
        return stock;
    }

    public IStock getMandatorDefaultStock(String mandatorId) {
        IMandator mandator = this.coreModelService.load(mandatorId, IMandator.class).orElse(null);
        if (mandator != null) {
            IQuery query = CoreModelServiceHolder.get().getQuery(IStock.class, true, false);
            query.and((EStructuralFeature)ModelPackage.Literals.ISTOCK__OWNER, IQuery.COMPARATOR.EQUALS, (Object)mandator);
            query.orderBy("PRIORITY", IQuery.ORDER.DESC);
            List result = query.execute();
            if (!result.isEmpty()) {
                return (IStock)result.get(0);
            }
        }
        return this.getDefaultStock();
    }

    public IStockService.Availability getArticleAvailabilityForStock(IStock stock, String article) {
        IStockEntry se = this.findStockEntryForArticleInStock(stock, article);
        return this.determineAvailability(se.getCurrentStock(), se.getMinimumStock(), this.isTriggerStockAvailabilityOnBelow());
    }

    public IStockEntry findStockEntryForArticleInStock(IStock stock, IArticle article) {
        String articleSts = this.storeToStringService.storeToString((Identifiable)article).orElse(null);
        return this.findStockEntryForArticleInStock(stock, articleSts);
    }

    public IStockEntry findStockEntryForArticleInStock(IStock iStock, String storeToString) {
        String[] vals = storeToString.split("::");
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IStockEntry.class, new String[]{"articleId", "articleType"});
        List entries = query.executeWithParameters(query.getParameterMap(new Object[]{"articleId", vals[1], "articleType", vals[0]}));
        if (entries != null && !entries.isEmpty()) {
            for (IStockEntry iStockEntry : entries) {
                if (!iStockEntry.getStock().equals(iStock)) continue;
                return iStockEntry;
            }
        }
        return null;
    }

    public IStockEntry storeArticleInStock(IStock stock, IArticle article) {
        String articleSts = this.storeToStringService.storeToString((Identifiable)article).orElse(null);
        return this.storeArticleInStock(stock, articleSts);
    }

    public IStockEntry storeArticleInStock(IStock stock, String article) {
        IStockEntry stockEntry = this.findStockEntryForArticleInStock(stock, article);
        if (stockEntry != null) {
            stockEntry.setCurrentStock(stockEntry.getCurrentStock() + 1);
        } else {
            IArticle loadArticle = this.loadArticle(article);
            if (loadArticle == null) {
                return null;
            }
            stockEntry = (IStockEntry)CoreModelServiceHolder.get().create(IStockEntry.class);
            stockEntry.setStock(stock);
            stockEntry.setCurrentStock(1);
            stockEntry.setArticle(loadArticle);
        }
        CoreModelServiceHolder.get().save((Identifiable)stockEntry);
        LocalLockServiceHolder.get().acquireLock((Object)stockEntry);
        LocalLockServiceHolder.get().releaseLock((Object)stockEntry);
        return stockEntry;
    }

    public void unstoreArticleFromStock(IStock stock, String article) {
        IStockEntry stockEntry = this.findStockEntryForArticleInStock(stock, article);
        if (stockEntry != null) {
            LockResponse lr = LocalLockServiceHolder.get().acquireLockBlocking((Object)stockEntry, 1, (IProgressMonitor)new NullProgressMonitor());
            if (lr.isOk()) {
                CoreModelServiceHolder.get().remove((Identifiable)stockEntry);
                LocalLockServiceHolder.get().releaseLock((Object)stockEntry);
            } else {
                log.warn("Could not unstore article [{}]", (Object)article);
            }
        }
    }

    public List<IStockEntry> findAllStockEntriesForArticle(String storeToString) {
        String[] vals = storeToString.split("::");
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IStockEntry.class, new String[]{"articleId", "articleType"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"articleId", vals[1], "articleType", vals[0]}));
    }

    public List<IStockEntry> findAllStockEntriesForStock(IStock stock) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IStockEntry.class);
        query.and("stock", IQuery.COMPARATOR.EQUALS, (Object)stock);
        return query.execute();
    }

    public IStatus performSingleDisposal(String articleStoreToString, int count, String mandatorId) {
        Optional article = StoreToStringServiceHolder.get().loadFromString(articleStoreToString);
        if (article.isPresent()) {
            return this.performSingleDisposal((IArticle)article.get(), count, mandatorId);
        }
        return new Status(2, "ch.elexis.core.services", "No article found [" + articleStoreToString + "]");
    }

    public IStatus performSingleReturn(String articleStoreToString, int count, String mandatorId) {
        Optional article = StoreToStringServiceHolder.get().loadFromString(articleStoreToString);
        if (article.isPresent()) {
            return this.performSingleReturn((IArticle)article.get(), count, mandatorId);
        }
        return new Status(2, "ch.elexis.core.services", "No article found [" + articleStoreToString + "]");
    }

    public Optional<IStock> getPatientStock(IPatient patient) {
        if (patient == null) {
            return Optional.empty();
        }
        return this.coreModelService.load("PatientStock-" + patient.getPatientNr(), IStock.class);
    }

    public void setEnablePatientStock(IPatient patient, boolean stockState) {
        IStock patientStock = this.getPatientStock(patient).orElse(null);
        if (stockState) {
            if (patientStock == null) {
                patientStock = (IStock)this.coreModelService.create(IStock.class);
                patientStock.setId("PatientStock-" + patient.getPatientNr());
                patientStock.setPriority(0);
                patientStock.setCode(PAT_STOCK_PREFIX + patient.getPatientNr());
                patientStock.setDescription(String.valueOf(patient.getDescription1()) + " " + patient.getDescription2());
                patientStock.setOwner((IPerson)patient);
                patientStock.setLocation("Patient");
                this.coreModelService.save((Identifiable)patientStock);
            }
        } else if (patientStock != null) {
            List<IStockEntry> entries = this.findAllStockEntriesForStock(patientStock);
            entries.forEach(arg_0 -> ((IModelService)this.coreModelService).remove(arg_0));
            this.coreModelService.remove((Identifiable)patientStock);
        }
    }

    public IStock getOrCreatePatientStock(IPatient patient) {
        return this.getPatientStock(patient).orElseGet(() -> {
            this.setEnablePatientStock(patient, true);
            return this.getPatientStock(patient).orElse(null);
        });
    }

    public List<IStock> getAllPatientStock() {
        IQuery query = this.coreModelService.getQuery(IStock.class);
        query.and("id", IQuery.COMPARATOR.LIKE, (Object)"PatientStock-%");
        return query.execute();
    }

    public void removePatientStock(IStock patientStock) {
        patientStock.getStockEntries().forEach(entry -> this.unstoreArticleFromStock(patientStock, (String)this.storeToStringService.storeToString((Identifiable)entry.getArticle()).get()));
        this.coreModelService.remove((Identifiable)patientStock);
    }
}

