/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAppointmentHistoryManagerService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AppointmentHistoryManagerService
implements IAppointmentHistoryManagerService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IContextService contextService;

    public void addHistoryEntry(IAppointment appointment, String action) {
        String currentHistory = appointment.getStateHistory();
        String user = this.getCurrentUser();
        if (!StringUtils.isEmpty((CharSequence)currentHistory)) {
            currentHistory = String.valueOf(currentHistory) + "\n";
        }
        String timestamp = this.toMinutesTimeStamp(LocalDateTime.now());
        String entry = String.valueOf(timestamp) + ";" + action + " [" + user + "]";
        appointment.setStateHistory(String.valueOf(currentHistory) + entry);
        this.coreModelService.save((Identifiable)appointment);
    }

    public void logAppointmentMove(IAppointment appointment, LocalDateTime oldStartTime, LocalDateTime newStartTime, String oldArea, String newArea) {
        String entry = String.valueOf(Messages.AppointmentHistory_Move_From) + " " + this.formatDateTime(oldStartTime) + " (" + oldArea + ") " + Messages.AppointmentHistory_Move_To + " " + this.formatDateTime(newStartTime) + " (" + newArea + ")";
        this.addHistoryEntry(appointment, entry);
    }

    public void logAppointmentCopyFromTo(IAppointment appointment, String originalId, String newId) {
        String entry = String.valueOf(Messages.AppointmentHistory_Copy_From) + " " + "{{" + originalId + "}}" + Messages.AppointmentHistory_Move_To + " " + "{{" + newId + "}}";
        this.addHistoryEntry(appointment, entry);
    }

    public void logAppointmentCopy(IAppointment appointment, String originalId) {
        String entry = String.valueOf(Messages.AppointmentHistory_Copied_To) + " " + "{{" + originalId + "}}";
        this.addHistoryEntry(appointment, entry);
    }

    public void logAppointmentDurationChange(IAppointment appointment, LocalDateTime oldEndTime, LocalDateTime newEndTime) {
        String entry = String.valueOf(Messages.AppointmentHistory_Duration_Changed_From) + " " + this.formatDateTime(oldEndTime) + " " + Messages.AppointmentHistory_Move_To + " " + this.formatDateTime(newEndTime);
        this.addHistoryEntry(appointment, entry);
    }

    public String getFormattedHistory(IAppointment appointment, String formatPattern) {
        StringBuilder sb = new StringBuilder();
        String history = appointment.getStateHistory();
        if (StringUtils.isNotBlank((CharSequence)history)) {
            String[] lines;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
            String[] stringArray = lines = history.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] parts = line.split(";");
                if (parts.length == 2) {
                    LocalDateTime timestamp = this.fromMinutesTimeStamp(parts[0]);
                    sb.append(formatter.format(timestamp)).append(": ").append(parts[1]).append("\n");
                }
                ++n2;
            }
        }
        return sb.toString();
    }

    private String getCurrentUser() {
        return this.contextService != null && this.contextService.getActiveUser().isPresent() ? ((IUser)this.contextService.getActiveUser().get()).getLabel() : Messages.UNKNOWN;
    }

    private String formatDateTime(LocalDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        return formatter.format(dateTime);
    }

    private LocalDateTime fromMinutesTimeStamp(String timestamp) {
        long minutes = Long.parseLong(timestamp);
        return LocalDateTime.ofEpochSecond(minutes * 60L, 0, ZoneId.systemDefault().getRules().getOffset(Instant.now()));
    }

    private String toMinutesTimeStamp(LocalDateTime localDateTime) {
        long minutes = localDateTime.toEpochSecond(ZoneId.systemDefault().getRules().getOffset(localDateTime)) / 60L;
        return Long.toString(minutes);
    }

    public void logAppointmentEdit(IAppointment appointment) {
        String timestamp = this.formatDateTime(LocalDateTime.now());
        String entry = MessageFormat.format(Messages.AppointmentHistory_Edited_On_By, timestamp);
        this.addHistoryEntry(appointment, entry);
    }

    public void logAppointmentDeletion(IAppointment appointment) {
        String formattedDateTime = this.formatDateTime(LocalDateTime.now());
        String entry = MessageFormat.format(Messages.AppointmentHistory_Deleted_On_By, formattedDateTime);
        this.addHistoryEntry(appointment, entry);
    }
}

