/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.vfs.AbstractVirtualFileHandle_Webdav_Test;
import ch.elexis.core.services.vfs.AssumingWebdavConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class VirtualFileHandle_WebdavFile_Test
extends AbstractVirtualFileHandle_Webdav_Test {
    IVirtualFilesystemService.IVirtualFilesystemHandle handle;
    @ClassRule
    public static AssumingWebdavConnection assumingWebdavConnection = new AssumingWebdavConnection("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/");

    @BeforeClass
    public static void beforeClass() throws IOException {
        AbstractVirtualFileHandle_Webdav_Test.beforeClass();
    }

    @AfterClass
    public static void afterClass() {
        AbstractVirtualFileHandle_Webdav_Test.afterClass();
    }

    @Before
    public void initialize() throws IOException {
        this.handle = service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/testfile.txt");
        Assert.assertNotNull((Object)this.handle);
    }

    @Test
    public void a_createFile() throws IOException, InterruptedException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (OutputStream outputStream = this.handle.openOutputStream();){
            IOUtils.write((byte[])randomBytes, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Thread.sleep(200L);
    }

    @Test
    public void b_isDirectory() throws IOException {
        Assert.assertFalse((boolean)this.handle.isDirectory());
    }

    @Test
    public void c_openInputStream() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = this.handle.openInputStream();){
            byte[] byteArray = IOUtils.toByteArray((InputStream)is);
            Assert.assertArrayEquals((byte[])randomBytes, (byte[])byteArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void ca_getContentLength() throws IOException {
        Assert.assertEquals((long)36L, (long)this.handle.getContentLenght());
    }

    @Test
    public void d_getNameExtension() {
        Assert.assertEquals((Object)"testfile.txt", (Object)this.handle.getName());
        Assert.assertEquals((Object)"txt", (Object)this.handle.getExtension());
    }

    @Test
    public void e_existsCanReadCanWrite() throws IOException {
        Assert.assertTrue((boolean)this.handle.exists());
        Assert.assertTrue((boolean)this.handle.canRead());
        Assert.assertTrue((boolean)this.handle.canWrite());
    }

    @Test
    public void ee_moveToAnotherDirectory() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle ftm = service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/testFileToMove.txt");
        ftm.writeAllBytes(randomBytes);
        IVirtualFilesystemService.IVirtualFilesystemHandle dtm = service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/moveTo/");
        dtm.mkdir();
        IVirtualFilesystemService.IVirtualFilesystemHandle targetFtm = ftm.moveTo(dtm);
        Assert.assertFalse((boolean)ftm.exists());
        Assert.assertEquals((Object)"dav://admin:admin@localhost:22808/remote.php/dav/files/admin/moveTo/testFileToMove.txt", (Object)targetFtm.getURI().toString());
        Assert.assertTrue((boolean)targetFtm.exists());
        dtm.delete();
        Assert.assertFalse((boolean)dtm.exists());
        Assert.assertFalse((boolean)targetFtm.exists());
    }

    @Test
    public void ee_copyToAnotherDirectory() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle ftm = service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/testFileToMove.txt");
        ftm.writeAllBytes(randomBytes);
        IVirtualFilesystemService.IVirtualFilesystemHandle dtm = service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/copyTo/");
        dtm.mkdir();
        IVirtualFilesystemService.IVirtualFilesystemHandle targetFtm = ftm.copyTo(dtm);
        Assert.assertTrue((boolean)ftm.exists());
        Assert.assertEquals((Object)"dav://admin:admin@localhost:22808/remote.php/dav/files/admin/copyTo/testFileToMove.txt", (Object)targetFtm.getURI().toString());
        Assert.assertTrue((boolean)targetFtm.exists());
        dtm.delete();
        Assert.assertFalse((boolean)dtm.exists());
        Assert.assertFalse((boolean)targetFtm.exists());
    }

    @Test
    public void f_delete() throws IOException {
        this.handle.delete();
    }

    @Test
    public void g_subDir() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle subDir = this.handle.subDir("testSubDir");
        Assert.assertEquals((Object)(String.valueOf(this.handle.getAbsolutePath()) + "/testSubDir/"), (Object)subDir.getAbsolutePath());
        Assert.assertFalse((boolean)subDir.exists());
    }

    @Test(expected=IOException.class)
    public void h_subFileFails() throws IOException {
        this.handle.subFile("testSubFile");
    }

    @Test
    public void i_getParent() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle parent = this.handle.getParent();
        Assert.assertEquals((Object)service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/").toURL(), (Object)parent.getURI().toURL());
    }

    @Test(expected=IOException.class)
    public void j_listFails() throws IOException {
        this.handle.listHandles();
    }

    @Test(expected=IOException.class)
    public void k_listWithFilterFails() throws IOException {
        this.handle.listHandles(handle -> {
            String extension = handle.getExtension();
            boolean result = "txt".equalsIgnoreCase(extension);
            return result;
        });
    }

    @Test
    public void z_mkdir() throws IOException {
        Assert.assertFalse((boolean)this.handle.exists());
        Assert.assertFalse((boolean)this.handle.isDirectory());
        this.handle.mkdir();
        Assert.assertTrue((boolean)this.handle.exists());
        Assert.assertTrue((boolean)this.handle.isDirectory());
    }

    @Test
    public void zz_mkdirDelete() throws IOException {
        Assert.assertTrue((boolean)this.handle.isDirectory());
        this.handle.delete();
        Assert.assertFalse((boolean)this.handle.exists());
    }
}

