/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.vfs.VirtualFilesystemServiceTestUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class VirtualFileHandle_SmbDirectory_Test {
    private static IVirtualFilesystemService service;

    @BeforeClass
    public static void beforeClass() throws IOException {
        service = (IVirtualFilesystemService)OsgiServiceUtil.getService(IVirtualFilesystemService.class).get();
    }

    @Test
    public void canRead() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        Assert.assertTrue((boolean)service.of(String.valueOf(VirtualFilesystemServiceTestUtil.PREFIX_NOAUTH_SAMBA) + "testfile.txt").canRead());
        Assert.assertTrue((boolean)service.of("\\\\gitlab.medelexis.ch\\tests\\testfile.txt").canRead());
    }

    @Test
    public void isDirectory() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        Assert.assertTrue((boolean)service.of(String.valueOf(VirtualFilesystemServiceTestUtil.PREFIX_NOAUTH_SAMBA) + "/ZLErD3ZPHCcBj").isDirectory());
        Assert.assertFalse((boolean)service.of(String.valueOf(VirtualFilesystemServiceTestUtil.PREFIX_NOAUTH_SAMBA) + "/ZLErD3ZPHCcBj/zXlpZK7UC8qwp.txt").isDirectory());
    }

    @Test
    public void testListHandles() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = service.of(VirtualFilesystemServiceTestUtil.PREFIX_NOAUTH_SAMBA).listHandles();
        Assert.assertTrue((listHandles.length > 0 ? 1 : 0) != 0);
        Throwable throwable = null;
        Object var3_3 = null;
        try {
            InputStream is = listHandles[1].openInputStream();
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testCreateAndMoveToAndDelete() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        IVirtualFilesystemService.IVirtualFilesystemHandle dir = service.of(VirtualFilesystemServiceTestUtil.PREFIX_AUTH_SAMBA);
        IVirtualFilesystemService.IVirtualFilesystemHandle subFile = dir.subFile("Test File.txt");
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter p = new PrintWriter(subFile.openOutputStream());){
            p.write("TestFile\n");
            p.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((long)9L, (long)subFile.getContentLenght());
        Assert.assertTrue((boolean)subFile.exists());
        Assert.assertTrue((boolean)subFile.canRead());
        IVirtualFilesystemService.IVirtualFilesystemHandle subFileRenamed = dir.subFile("Test File renamed.txt");
        subFile.moveTo(subFileRenamed);
        Assert.assertFalse((boolean)subFile.exists());
        Assert.assertTrue((boolean)subFileRenamed.exists());
        Assert.assertTrue((boolean)subFileRenamed.canRead());
        subFileRenamed.delete();
        Assert.assertFalse((boolean)subFileRenamed.exists());
    }

    @Test
    public void testCreateAndMoveToBetweenHosts() throws UnknownHostException, IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        boolean ee_medevit_atIsReachable = InetAddress.getByName("192.168.0.23").isReachable(300) || InetAddress.getAllByName("192.168.0.23")[0].isReachable(300);
        Assume.assumeTrue((boolean)ee_medevit_atIsReachable);
        IVirtualFilesystemService.IVirtualFilesystemHandle dir = service.of("smb://192.168.0.23/scan/processed/");
        IVirtualFilesystemService.IVirtualFilesystemHandle subFile = dir.subFile("Test File.txt");
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintWriter p = new PrintWriter(subFile.openOutputStream());){
            p.write("TestFile\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)subFile.exists());
        Assert.assertTrue((boolean)subFile.canRead());
        IVirtualFilesystemService.IVirtualFilesystemHandle dirOtherResource = service.of(VirtualFilesystemServiceTestUtil.PREFIX_AUTH_SAMBA);
        IVirtualFilesystemService.IVirtualFilesystemHandle subFileRenamed = dirOtherResource.subFile("Test File renamed.txt");
        subFile.moveTo(subFileRenamed);
        Assert.assertFalse((boolean)subFile.exists());
        Assert.assertTrue((boolean)subFileRenamed.exists());
        Assert.assertTrue((boolean)subFileRenamed.canRead());
        subFileRenamed.delete();
        Assert.assertFalse((boolean)subFileRenamed.exists());
    }

    @Test
    public void testCopyToAndDelete() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = service.of(VirtualFilesystemServiceTestUtil.PREFIX_NOAUTH_SAMBA).listHandles(handle -> "pdf".equalsIgnoreCase(handle.getExtension()));
        Assert.assertEquals((long)2L, (long)listHandles.length);
        IVirtualFilesystemService.IVirtualFilesystemHandle target = service.of(VirtualFilesystemServiceTestUtil.PREFIX_AUTH_SAMBA).subFile(listHandles[0].getName());
        IVirtualFilesystemService.IVirtualFilesystemHandle _target = listHandles[0].copyTo(target);
        Assert.assertTrue((boolean)_target.exists());
        Assert.assertTrue((boolean)_target.canRead());
        _target.delete();
        Assert.assertFalse((boolean)_target.exists());
    }

    @Test
    public void testListHandlesIVirtualFilesystemhandleFilter() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        IVirtualFilesystemService.IVirtualFilesystemhandleFilter ivfh = new IVirtualFilesystemService.IVirtualFilesystemhandleFilter(){

            public boolean accept(IVirtualFilesystemService.IVirtualFilesystemHandle handle) {
                String extension = handle.getExtension();
                boolean result = "txt".equalsIgnoreCase(extension);
                return result;
            }
        };
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = service.of(VirtualFilesystemServiceTestUtil.PREFIX_NOAUTH_SAMBA).listHandles(ivfh);
        Assert.assertEquals((long)2L, (long)listHandles.length);
    }

    @Test
    public void testMkdirs() throws IOException {
        Assume.assumeTrue((boolean)VirtualFilesystemServiceTestUtil.serviceIsReachable());
        IVirtualFilesystemService.IVirtualFilesystemHandle subMkdirs = service.of(VirtualFilesystemServiceTestUtil.PREFIX_AUTH_SAMBA).subDir("parent1").subDir("parent2").subDir("parent3").mkdirs();
        Assert.assertTrue((boolean)subMkdirs.exists());
        service.of(VirtualFilesystemServiceTestUtil.PREFIX_AUTH_SAMBA).subDir("parent1").delete();
    }
}

