/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.vfs.AbstractVirtualFileHandleTest;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class VirtualFileHandle_FileFile_Test
extends AbstractVirtualFileHandleTest {
    static File testDirectory;
    static File testFile;

    @BeforeClass
    public static void beforeClass() throws IOException {
        service = (IVirtualFilesystemService)OsgiServiceUtil.getService(IVirtualFilesystemService.class).get();
        Path tempDirectory = Files.createTempDirectory("virtualFilesystemTest_filefile", new FileAttribute[0]);
        testDirectory = tempDirectory.toFile();
        testDirectory.deleteOnExit();
        testFile = Files.createTempFile(tempDirectory, "test", ".txt", new FileAttribute[0]).toFile();
        testFile.deleteOnExit();
        VirtualFileHandle_FileFile_Test.createPopulateTestFile();
        testHandle = service.of(testFile);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        FileUtils.deleteDirectory((File)testDirectory);
    }

    private static void createPopulateTestFile() throws IOException {
        Files.write(testFile.toPath(), "meaninglessTestText".getBytes(), StandardOpenOption.CREATE);
    }

    @Test
    public void testOpenOutputStream() throws IOException {
        String now = LocalDateTime.now().toString();
        Assert.assertEquals((long)19L, (long)testHandle.getContentLenght());
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream os = testHandle.openOutputStream();){
            IOUtils.write((String)now, (OutputStream)os, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((long)now.length(), (long)testHandle.getContentLenght());
    }

    @Test
    public void testCopyTo() throws IOException {
        File copyToFile = new File(testDirectory, "copyToFile");
        testHandle.copyTo(service.of(copyToFile));
        byte[] readAllBytes = Files.readAllBytes(copyToFile.toPath());
        Assert.assertArrayEquals((byte[])"meaninglessTestText".getBytes(), (byte[])readAllBytes);
        Assert.assertTrue((boolean)testHandle.exists());
        Assert.assertTrue((boolean)copyToFile.delete());
    }

    @Test
    public void testGetParent() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle parent = testHandle.getParent();
        Assert.assertEquals((Object)testDirectory, parent.toFile().get());
        Assert.assertTrue((String)(String.valueOf(testHandle.getAbsolutePath()) + " [" + parent.getName() + "]"), (boolean)parent.getName().startsWith("virtualFilesystemTest_filefile"));
    }

    @Test(expected=IOException.class)
    public void listFails() throws IOException {
        testHandle.listHandles();
    }

    @Test(expected=IOException.class)
    public void listWithFilterFails() throws IOException {
        testHandle.listHandles(null);
    }

    @Test
    public void testDelete() throws IOException {
        testHandle.delete();
        Assert.assertFalse((boolean)testFile.exists());
        Assert.assertTrue((boolean)testFile.createNewFile());
        VirtualFileHandle_FileFile_Test.createPopulateTestFile();
    }

    @Test
    public void testToURL() throws MalformedURLException {
        Assert.assertEquals((Object)testFile.toURI().toURL(), (Object)testHandle.toURL());
    }

    @Test
    public void testIsDirectory() throws IOException {
        Assert.assertFalse((boolean)testHandle.isDirectory());
    }

    @Test
    public void testToFile() {
        Assert.assertEquals((Object)testFile, testHandle.toFile().get());
    }

    @Test
    public void testGetExtension() {
        Assert.assertEquals((Object)"txt", (Object)testHandle.getExtension());
    }

    @Test
    public void testExists() throws IOException {
        Assert.assertTrue((boolean)testFile.delete());
        Assert.assertFalse((boolean)testHandle.exists());
        VirtualFileHandle_FileFile_Test.createPopulateTestFile();
        Assert.assertTrue((boolean)testHandle.exists());
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)testFile.getName(), (Object)testHandle.getName());
    }

    @Test
    public void testCanRead() {
        Assert.assertTrue((boolean)testHandle.canRead());
    }

    @Test
    public void testGetAbsolutePath() {
        Assert.assertEquals((Object)testFile.toURI().toString(), (Object)testHandle.getAbsolutePath());
    }

    @Test
    public void testMoveTo() throws IOException {
        File moveToFile = new File(testDirectory, "moveToFile");
        testHandle.moveTo(service.of(moveToFile));
        byte[] readAllBytes = Files.readAllBytes(moveToFile.toPath());
        Assert.assertArrayEquals((byte[])"meaninglessTestText".getBytes(), (byte[])readAllBytes);
        Assert.assertFalse((boolean)testHandle.exists());
        VirtualFileHandle_FileFile_Test.createPopulateTestFile();
    }

    @Test
    public void testSubDir() throws IOException {
        testHandle.subDir("subdir");
    }

    @Test(expected=IOException.class)
    public void testSubFile() throws IOException {
        testHandle.subFile("subfile");
    }

    @Test
    public void testMkdir() throws IOException {
        testHandle.mkdir();
    }

    @Test
    public void openInputStream() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = testHandle.openInputStream();){
            String string = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            System.out.println(string);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

