/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITextReplacementServiceTest
extends AbstractServiceTest {
    private ITextReplacementService textReplacementService = (ITextReplacementService)OsgiServiceUtil.getService(ITextReplacementService.class).get();
    private IContextService contextService = (IContextService)OsgiServiceUtil.getService(IContextService.class).get();
    private static IAppointment appointment;

    @BeforeClass
    public static void beforeClass() {
        LocalDateTime ldt = LocalDateTime.of(2019, 12, 12, 12, 12);
        appointment = (IAppointment)new IAppointmentBuilder(coreModelService, "testSchedule", ldt, ldt.plusHours(1L), "type", "state").buildAndSave();
    }

    @Test
    public void patientReplacement() {
        this.contextService.setActivePatient(AllServiceTests.getPatient());
        String template = "Liebe[Patient:mw:r/ ] [Patient.Name] [Patient.Vorname],";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Liebe Patient Test,", (Object)replaced);
        template = "[Patient.Geschlecht]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"w", (Object)replaced);
        AllServiceTests.getPatient().setPersonalAnamnese("pers anamnese");
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getPatient());
        template = "[Patient.PersAnamnese]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"pers anamnese", (Object)replaced);
        AllServiceTests.getPatient().setFamilyAnamnese("fam anamnese");
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getPatient());
        template = "[Patient.FamilienAnamnese]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"fam anamnese", (Object)replaced);
        AllServiceTests.getPatient().setRisk("risks");
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getPatient());
        template = "[Patient.Risiken]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"risks", (Object)replaced);
        AllServiceTests.getPatient().addXid("www.ahv.ch/xid", "1234", true);
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getPatient());
        template = "[Patient.AHV]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"1234", (Object)replaced);
        AllServiceTests.getPatient().setLegalGuardian(AllServiceTests.getCoverage().getCostBearer());
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getPatient());
        template = "[Patient:-:-:GesetzVertreter]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Test Organization\nStreet 10\n123 City\n", (Object)replaced);
        AllServiceTests.getPatient().setLegalGuardian(null);
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getPatient());
    }

    @Test
    public void adressatReplacement() {
        this.contextService.getRootContext().setNamed("Adressat", (Object)AllServiceTests.getMandator());
        String template = "Liebe[Adressat:mw:r/ ] [Adressat.Vorname]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Lieber Test", (Object)replaced);
        template = "[Adressat.Anschrift]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Herr\nTest Mandant\nStreet 100\n123 City\n", (Object)replaced);
    }

    @Test
    public void terminReplacement() {
        this.contextService.getRootContext().setTyped((Object)appointment);
        String template = "[Termin.Tag] [Termin.zeit] [Termin.Bereich]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"12.12.2019 12:12 testSchedule", (Object)replaced);
    }

    @Test
    public void konsultationReplacement() {
        this.createTestMandantPatientFallBehandlung();
        IEncounter encounter = (IEncounter)this.testEncounters.get(0);
        encounter.getVersionedEntry().update("Test consultation\ndone by user", "user");
        CoreModelServiceHolder.get().save((Identifiable)encounter);
        this.contextService.getRootContext().setTyped((Object)encounter);
        String template = "[Konsultation.Eintrag]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Test consultation\ndone by user", (Object)replaced);
    }

    @Test
    public void mandantReplacement() {
        this.contextService.setActiveMandator(AllServiceTests.getMandator());
        String template = "[Mandant.Anschrift]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Herr\nTest Mandant\nStreet 100\n123 City\n", (Object)replaced);
        IPerson person = AllServiceTests.getMandator().asIPerson();
        person.setTitel("Titel");
        CoreModelServiceHolder.get().save((Identifiable)person);
        template = "[Mandant.Titel]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Titel", (Object)replaced);
        person = AllServiceTests.getMandator().asIPerson();
        person.setEmail("test@test.tst");
        CoreModelServiceHolder.get().save((Identifiable)person);
        template = "[Mandant.E-Mail]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"test@test.tst", (Object)replaced);
        AllServiceTests.getMandator().setExtInfo((Object)"TarmedSpezialit\u00e4t", (Object)"Allgemein");
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getMandator());
        template = "[Mandant.TarmedSpezialit\u00e4t]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Allgemein", (Object)replaced);
        AllServiceTests.getMandator().addXid("www.xid.ch/id/ean", "2000000000000", true);
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getMandator());
        template = "[Mandant.EAN]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"2000000000000", (Object)replaced);
        AllServiceTests.getMandator().addXid("www.xid.ch/id/ksk", "C000002", true);
        CoreModelServiceHolder.get().save((Identifiable)AllServiceTests.getMandator());
        template = "[Mandant.KSK]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"C000002", (Object)replaced);
    }

    @Test
    public void datumReplacement() {
        String template = "[Datum.heute]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)TimeUtil.DATE_GER.format(LocalDate.now()), (Object)replaced);
        template = "[Datum.Datum]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)TimeUtil.DATE_GER.format(LocalDate.now()), (Object)replaced);
    }

    @Test
    public void aufReplacement() {
        LocalDate start = LocalDate.of(2000, 1, 12);
        ISickCertificate sickCertificate = (ISickCertificate)CoreModelServiceHolder.get().create(ISickCertificate.class);
        sickCertificate.setPatient(AllServiceTests.getPatient());
        sickCertificate.setStart(start);
        sickCertificate.setEnd(start.plusDays(7L));
        sickCertificate.setNote("note");
        sickCertificate.setReason("reason");
        sickCertificate.setPercent(99);
        CoreModelServiceHolder.get().save((Identifiable)sickCertificate);
        this.contextService.getRootContext().setTyped((Object)sickCertificate);
        String template = "[AUF.von]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"12.01.2000", (Object)replaced);
        template = "[AUF.bis]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"19.01.2000", (Object)replaced);
        template = "[AUF.Grund]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"reason", (Object)replaced);
        template = "[AUF.Prozent]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"99", (Object)replaced);
        template = "[AUF.Zusatz]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"note", (Object)replaced);
    }

    @Test
    public void fallReplacement() {
        this.contextService.getRootContext().setNamed("Fall", (Object)AllServiceTests.getCoverage());
        String template = "[Fall.Versicherungsnummer]";
        String replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"1234-5678", (Object)replaced);
        template = "[Fall.Kostentraeger]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Test Organization\nStreet 10\n123 City\n", (Object)replaced);
        template = "[Fall:-:-:Kostentraeger]";
        replaced = this.textReplacementService.performReplacement(this.contextService.getRootContext(), template);
        Assert.assertEquals((Object)"Test Organization\nStreet 10\n123 City\n", (Object)replaced);
    }
}

