/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class IStickerServiceTest
extends AbstractServiceTest {
    private IStickerService service = (IStickerService)OsgiServiceUtil.getService(IStickerService.class).get();

    @Test
    public void getStickers() {
        Optional load = coreModelService.load("zd8d46d1b8d44330501105", IPatient.class);
        List stickers = this.service.getStickers((Identifiable)load.get());
        Assert.assertEquals((long)2L, (long)stickers.size());
    }

    @Test
    public void getSticker() {
        Optional load = coreModelService.load("zd8d46d1b8d44330501105", IPatient.class);
        Optional sticker = this.service.getSticker((Identifiable)load.get());
        Assert.assertEquals((Object)"verstorben", (Object)((ISticker)sticker.get()).getName());
    }

    @Test
    public void addSticker() {
        Optional patient = coreModelService.load("zd8d46d1b8d44330501105", IPatient.class);
        ISticker newSticker = (ISticker)coreModelService.create(ISticker.class);
        newSticker.setName("test sticker");
        coreModelService.save((Identifiable)newSticker);
        this.service.addSticker(newSticker, (Identifiable)patient.get());
        List patientStickers = this.service.getStickers((Identifiable)patient.get());
        Assert.assertFalse((boolean)patientStickers.isEmpty());
        Assert.assertTrue((boolean)patientStickers.contains(newSticker));
        for (ISticker iSticker : patientStickers) {
            Assert.assertNotNull((Object)iSticker.getLastupdate());
        }
        this.service.removeSticker(newSticker, (Identifiable)patient.get());
    }

    @Test
    public void removeSticker() {
        Optional patient = coreModelService.load("zd8d46d1b8d44330501105", IPatient.class);
        ISticker newSticker = (ISticker)coreModelService.create(ISticker.class);
        newSticker.setName("test sticker");
        coreModelService.save((Identifiable)newSticker);
        this.service.addSticker(newSticker, (Identifiable)patient.get());
        List patientStickers = this.service.getStickers((Identifiable)patient.get());
        Assert.assertTrue((boolean)patientStickers.contains(newSticker));
        Assert.assertTrue((boolean)this.service.hasSticker((Identifiable)patient.get(), newSticker));
        this.service.removeSticker(newSticker, (Identifiable)patient.get());
        patientStickers = this.service.getStickers((Identifiable)patient.get());
        Assert.assertFalse((boolean)patientStickers.contains(newSticker));
        Assert.assertFalse((boolean)this.service.hasSticker((Identifiable)patient.get(), newSticker));
    }

    @Ignore(value="Not yet implemented the required mapping")
    @Test
    public void isStickerAddableToClass() {
        ISticker sticker = (ISticker)coreModelService.load("T3811f3656cea91c2080136", ISticker.class).get();
        Assert.assertTrue((boolean)this.service.isStickerAddableToClass(IPatient.class, sticker));
    }

    @Test
    public void findStickersApplicableToPatients() {
        ISticker newSticker = (ISticker)coreModelService.create(ISticker.class);
        newSticker.setName("Sticker 2");
        coreModelService.save((Identifiable)newSticker);
        this.service.setStickerAddableToClass(IPatient.class, newSticker);
        Assert.assertTrue((boolean)this.service.isStickerAddableToClass(IPatient.class, newSticker));
        Assert.assertFalse((boolean)this.service.isStickerAddableToClass(IArticle.class, newSticker));
        Assert.assertFalse((boolean)this.service.isStickerAddableToClass(IOrganization.class, newSticker));
    }

    @Test
    public void applyAndRemoveStickerWithData() {
        ISticker sticker = (ISticker)coreModelService.create(ISticker.class);
        sticker.setName("Sticker With Data");
        coreModelService.save((Identifiable)sticker);
        this.service.setStickerAddableToClass(IPatient.class, sticker);
        IPatient patient = (IPatient)coreModelService.load("zd8d46d1b8d44330501105", IPatient.class).orElseThrow(() -> new IllegalStateException());
        Assert.assertNull((Object)sticker.getAttachedTo());
        Assert.assertNull((Object)sticker.getAttachedToData());
        int size = this.service.getStickers((Identifiable)patient).size();
        this.service.addSticker(sticker, (Identifiable)patient, "abcd-1234-efgh-8765-ijkl");
        this.service.addSticker(sticker, (Identifiable)patient, "abcd-1234-efgh-5678-ijkl");
        Assert.assertEquals((long)(size + 1), (long)this.service.getStickers((Identifiable)patient).size());
        ISticker boundSticker = this.service.getSticker((Identifiable)patient, sticker);
        Assert.assertNotNull((Object)boundSticker.getLastupdate());
        Assert.assertEquals((Object)patient, (Object)boundSticker.getAttachedTo());
        Assert.assertEquals((Object)"abcd-1234-efgh-5678-ijkl", (Object)boundSticker.getAttachedToData());
        this.service.removeSticker(sticker, (Identifiable)patient);
        boundSticker = this.service.getSticker((Identifiable)patient, sticker);
        Assert.assertNull((Object)boundSticker);
    }
}

