/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IOrderServiceTest
extends AbstractServiceTest {
    static IModelService coreModelService = AllServiceTests.getModelService();
    private static IOrderService orderService;
    private static IArticle article;
    private static IStock stock;
    private static IStockEntry stockEntry;
    private static IOrder order;

    @BeforeClass
    public static void beforeClass() {
        orderService = (IOrderService)OsgiServiceUtil.getService(IOrderService.class).get();
        article = (IArticle)new IArticleBuilder(coreModelService, "test medication article", "1234567", ArticleTyp.ARTIKELSTAMM).buildAndSave();
        stock = IOrderServiceTest.createStock();
        stockEntry = IOrderServiceTest.createStockEntry();
        order = IOrderServiceTest.createOrder();
    }

    @Test
    public void addRefillForStockEntryToOrder() {
        IOrderEntry newEntry = orderService.addRefillForStockEntryToOrder(stockEntry, order);
        Assert.assertNotNull((Object)newEntry);
        Assert.assertEquals((Object)stockEntry.getArticle(), (Object)newEntry.getArticle());
        Assert.assertEquals((long)2L, (long)newEntry.getAmount());
    }

    @Test
    public void findOpenOrderEntryForStockEntry() {
        IOrderEntry entry = orderService.findOpenOrderEntryForStockEntry(stockEntry);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals(order.getEntries().get(0), (Object)entry);
    }

    @Test
    public void findOrderEntryForStock() {
        IOrderEntry orderEntry = (IOrderEntry)order.getEntries().get(0);
        orderEntry.setState(OrderEntryState.DONE);
        List entries = orderService.findOrderEntryForStock(stock);
        Assert.assertFalse((boolean)entries.isEmpty());
        Assert.assertTrue((boolean)entries.contains(orderEntry));
    }

    private static IStock createStock() {
        IStock stock = (IStock)coreModelService.create(IStock.class);
        stock.setCode("TES");
        stock.setPriority(1);
        stock.setDescription("Test");
        coreModelService.save((Identifiable)stock);
        return stock;
    }

    private static IStockEntry createStockEntry() {
        IStockEntry stockEntry = (IStockEntry)coreModelService.create(IStockEntry.class);
        stockEntry.setStock(stock);
        stockEntry.setCurrentStock(0);
        stockEntry.setMaximumStock(1);
        stockEntry.setArticle(article);
        return stockEntry;
    }

    private static IOrder createOrder() {
        IOrder order = (IOrder)coreModelService.create(IOrder.class);
        coreModelService.save((Identifiable)order);
        coreModelService.save((Identifiable)order.addEntry(article, stock, null, 1));
        return order;
    }
}

