/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IUser;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IMessageService;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.utils.OsgiServiceUtil;
import org.junit.Assert;
import org.junit.Test;

public class IMessageServiceTest
extends AbstractServiceTest {
    private IMessageService service = (IMessageService)OsgiServiceUtil.getService(IMessageService.class).get();

    @Test
    public void internalDatabaseMessage_explicitScheme_fromUser() {
        IUser user = coreModelService.load("user", IUser.class).orElse(null);
        TransientMessage message = this.service.prepare(user.getId(), "internaldb:" + user.getId());
        message.setMessageText("internalDatabaseMessage_explicitScheme_fromUser");
        message.addMessageCode("senderSubId", "tests.messageServiceTest");
        ObjectStatus status = this.service.send(message);
        Assert.assertTrue((String)status.getMessage(), (boolean)status.isOK());
        Assert.assertEquals((String)status.getMessage(), (Object)"internaldb", (Object)status.getObject());
    }

    @Test
    public void internalDatabaseMessage_internalScheme_fromUser() {
        IUser user = coreModelService.load("user", IUser.class).orElse(null);
        TransientMessage message = this.service.prepare(user.getId(), "internal:" + user.getId());
        message.setMessageText("internalDatabaseMessage_internalScheme_fromUser");
        message.addMessageCode("senderSubId", "tests.messageServiceTest");
        ObjectStatus status = this.service.send(message);
        Assert.assertTrue((String)status.getMessage(), (boolean)status.isOK());
    }
}

