/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IMessageService;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class IElexisEnvironmentServiceTest
extends AbstractServiceTest {
    private Optional<IElexisEnvironmentService> ee_service = OsgiServiceUtil.getService(IElexisEnvironmentService.class);
    private IMessageService messageService = (IMessageService)OsgiServiceUtil.getService(IMessageService.class).get();
    private static IContextService contextService = (IContextService)OsgiServiceUtil.getService(IContextService.class).get();

    @BeforeClass
    public static void beforeClass() throws NoSuchAlgorithmException, KeyManagementException {
        contextService.getRootContext().setNamed("rocketchat-station-integration-token", (Object)"b8fnKyMcMTRyeg22d/hM3LTStZheEt7w3L6fu8rDDNqcJiXWbbvmKsRrP2zm8zTYoA");
        IElexisEnvironmentServiceTest.acceptAllCerts();
    }

    @Test
    public void rocketChatMessage_fromStation() {
        Assume.assumeTrue((boolean)this.ee_service.isPresent());
        TransientMessage message = this.messageService.prepare(String.valueOf(this.getClass().getName()) + "@" + contextService.getStationIdentifier(), "rocketchat:demouser");
        message.setMessageText("rocketChatMessage_fromStation");
        message.addMessageCode("senderSubId", "tests.elexisenvironmentservicetest");
        message.addMessageCode("key", "value");
        ObjectStatus status = this.messageService.send(message);
        Assert.assertTrue((String)status.getMessage(), (boolean)status.isOK());
    }
}

